/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.code;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.contract.config.ContractContext;
import io.nuls.contract.vm.code.ClassCode;
import io.nuls.contract.vm.code.ClassCodeCacheKey;
import io.nuls.contract.vm.code.MethodCode;
import io.nuls.contract.vm.code.VariableType;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public class ClassCodeLoader {
    private static final Map<String, ClassCode> BASE_USED_CLASSES;
    private static final Map<String, ClassCode> RESOURCE_CLASS_CODES;
    private static final Map<String, ClassCode> RESOURCE_CLASS_CODES_V8;
    private static final Map<String, ClassCode> RESOURCE_CLASS_CODES_V14;
    private static final Map<String, ClassCode> RESOURCE_CLASS_CODES_V15;
    private static final LoadingCache<ClassCodeCacheKey, Map<String, ClassCode>> CACHE;

    public static ClassCode load(String className) {
        try {
            ClassReader classReader = new ClassReader(className);
            return ClassCodeLoader.load(classReader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ClassCode loadFromResource(String className) {
        ClassCode classCode = RESOURCE_CLASS_CODES.get(className);
        if (classCode == null) {
            throw new RuntimeException("can't load class " + className);
        }
        return classCode;
    }

    public static ClassCode loadFromResource_v8(String className) {
        ClassCode classCode = RESOURCE_CLASS_CODES_V8.get(className);
        if (classCode == null) {
            throw new RuntimeException("can't load class " + className);
        }
        return classCode;
    }

    public static ClassCode loadFromResource_v14(String className) {
        ClassCode classCode = RESOURCE_CLASS_CODES_V14.get(className);
        if (classCode == null) {
            throw new RuntimeException("can't load class " + className);
        }
        return classCode;
    }

    public static ClassCode loadFromResource_v15(String className) {
        ClassCode classCode = RESOURCE_CLASS_CODES_V15.get(className);
        if (classCode == null) {
            throw new RuntimeException("can't load class " + className);
        }
        return classCode;
    }

    public static ClassCode getFromResource(String className) {
        if (ProtocolGroupManager.getCurrentVersion((int)ContractContext.LOCAL_CHAIN_ID) >= ContractContext.PROTOCOL_15) {
            return RESOURCE_CLASS_CODES_V15.get(className);
        }
        if (ProtocolGroupManager.getCurrentVersion((int)ContractContext.LOCAL_CHAIN_ID) >= ContractContext.PROTOCOL_14) {
            return RESOURCE_CLASS_CODES_V14.get(className);
        }
        if (ProtocolGroupManager.getCurrentVersion((int)ContractContext.LOCAL_CHAIN_ID) >= ContractContext.UPDATE_VERSION_CONTRACT_ASSET) {
            return RESOURCE_CLASS_CODES_V8.get(className);
        }
        return RESOURCE_CLASS_CODES.get(className);
    }

    public static ClassCode loadFromResourceOrTmp(String className) {
        ClassCode classCode = RESOURCE_CLASS_CODES.get(className);
        if (classCode == null) {
            try {
                File file = new File("/tmp/classes/" + className + ".class");
                if (file.exists()) {
                    byte[] bytes = FileUtils.readFileToByteArray((File)file);
                    return ClassCodeLoader.load(bytes);
                }
                throw new RuntimeException("can't load class " + className);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return classCode;
    }

    public static void load(Map<String, ClassCode> classCodes, String className, Function<String, ClassCode> loader) {
        if (!classCodes.containsKey(className)) {
            ClassCode classCode = loader.apply(className);
            classCodes.put(className, classCode);
            if (StringUtils.isNotEmpty((CharSequence)classCode.superName)) {
                ClassCodeLoader.load(classCodes, classCode.superName, loader);
            }
            for (String interfaceName : classCode.interfaces) {
                ClassCodeLoader.load(classCodes, interfaceName, loader);
            }
            for (MethodCode methodCode : classCode.methods) {
                if (ClassCodeLoader.isSupport(methodCode.returnVariableType)) {
                    ClassCodeLoader.load(classCodes, methodCode.returnVariableType.getType(), loader);
                }
                for (VariableType variableType : methodCode.argsVariableType) {
                    if (!ClassCodeLoader.isSupport(variableType)) continue;
                    ClassCodeLoader.load(classCodes, variableType.getType(), loader);
                }
            }
        }
    }

    public static Map<String, ClassCode> loadAll(String className, Function<String, ClassCode> loader) {
        LinkedHashMap<String, ClassCode> classCodes = new LinkedHashMap<String, ClassCode>(100);
        ClassCodeLoader.load(classCodes, className, loader);
        return classCodes;
    }

    public static Map<String, ClassCode> loadJarCache(byte[] bytes) {
        try {
            return (Map)CACHE.get((Object)new ClassCodeCacheKey(bytes));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isSupport(VariableType variableType) {
        if (variableType.isPrimitiveType()) {
            return false;
        }
        return !variableType.isVoid();
    }

    private static ClassCode load(byte[] bytes) {
        return ClassCodeLoader.load(new ClassReader(bytes));
    }

    private static ClassCode load(ClassReader classReader) {
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 0);
        ClassCode classCode = new ClassCode(classNode);
        return classCode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, ClassCode> loadBaseFromResource() {
        try (InputStream baseInputStream = ClassCodeLoader.class.getResourceAsStream("/contract/used_classes_base");){
            Map<String, ClassCode> usedClasses;
            if (baseInputStream == null) {
                HashMap<String, ClassCode> hashMap = new HashMap<String, ClassCode>(0);
                return hashMap;
            }
            Map<String, ClassCode> map = usedClasses = ClassCodeLoader.loadJar(baseInputStream);
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, ClassCode> loadFromResource() {
        return ClassCodeLoader.loadFromResourceWithResourceName("/contract/used_classes_sdk");
    }

    private static Map<String, ClassCode> loadFromResource_v8() {
        return ClassCodeLoader.loadFromResourceWithResourceName("/contract/used_classes_sdk_v8");
    }

    private static Map<String, ClassCode> loadFromResource_v14() {
        return ClassCodeLoader.loadFromResourceWithResourceName("/contract/used_classes_sdk_v14");
    }

    private static Map<String, ClassCode> loadFromResource_v15() {
        return ClassCodeLoader.loadFromResourceWithResourceName("/contract/used_classes_sdk_v15");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, ClassCode> loadFromResourceWithResourceName(String usedClassesName) {
        try (InputStream sdkInputStream = ClassCodeLoader.class.getResourceAsStream(usedClassesName);){
            if (sdkInputStream == null) {
                Map<String, ClassCode> map2 = BASE_USED_CLASSES;
                return map2;
            }
            Map<String, ClassCode> sdkClasses = ClassCodeLoader.loadJar(sdkInputStream);
            if (sdkClasses != null) {
                sdkClasses.putAll(BASE_USED_CLASSES);
            }
            Map<String, ClassCode> map = sdkClasses;
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, ClassCode> loadJar(byte[] bytes) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        return ClassCodeLoader.loadJar(inputStream);
    }

    private static Map<String, ClassCode> loadJar(InputStream inputStream) {
        try {
            JarInputStream jarInputStream = new JarInputStream(inputStream);
            return ClassCodeLoader.loadJar(jarInputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, ClassCode> loadJar(JarInputStream jarInputStream) {
        HashMap<String, ClassCode> map = new HashMap<String, ClassCode>(100);
        try (JarInputStream jarInputStream2 = jarInputStream;){
            JarEntry jarEntry;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                if (jarEntry.isDirectory() || !jarEntry.getName().endsWith(".class")) continue;
                byte[] bytes = IOUtils.toByteArray((InputStream)jarInputStream);
                ClassCode classCode = ClassCodeLoader.load(bytes);
                map.put(classCode.name, classCode);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    static {
        CACHE = CacheBuilder.newBuilder().initialCapacity(100).maximumSize(4096L).expireAfterAccess(600L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<ClassCodeCacheKey, Map<String, ClassCode>>(){

            public Map<String, ClassCode> load(@Nonnull ClassCodeCacheKey cacheKey) {
                return ClassCodeLoader.loadJar(cacheKey.getBytes());
            }
        });
        BASE_USED_CLASSES = ClassCodeLoader.loadBaseFromResource();
        RESOURCE_CLASS_CODES = ClassCodeLoader.loadFromResource();
        RESOURCE_CLASS_CODES_V8 = ClassCodeLoader.loadFromResource_v8();
        RESOURCE_CLASS_CODES_V14 = ClassCodeLoader.loadFromResource_v14();
        RESOURCE_CLASS_CODES_V15 = ClassCodeLoader.loadFromResource_v15();
    }
}

