/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.code;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.nuls.contract.vm.code.Descriptors;
import io.nuls.contract.vm.util.Utils;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;

public class VariableType {
    private static final LoadingCache<String, VariableType> CACHE = CacheBuilder.newBuilder().initialCapacity(1024).maximumSize(409600L).expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, VariableType>(){

        public VariableType load(String desc) {
            return new VariableType(desc);
        }
    });
    private static final LoadingCache<String, List<VariableType>> CACHE_LIST = CacheBuilder.newBuilder().initialCapacity(1024).maximumSize(40960L).expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List<VariableType>>(){

        public List<VariableType> load(String desc) {
            return VariableType.parseList(desc);
        }
    });
    public static final VariableType INT_TYPE = VariableType.valueOf("I");
    public static final VariableType LONG_TYPE = VariableType.valueOf("J");
    public static final VariableType FLOAT_TYPE = VariableType.valueOf("F");
    public static final VariableType DOUBLE_TYPE = VariableType.valueOf("D");
    public static final VariableType BOOLEAN_TYPE = VariableType.valueOf("Z");
    public static final VariableType BYTE_TYPE = VariableType.valueOf("B");
    public static final VariableType CHAR_TYPE = VariableType.valueOf("C");
    public static final VariableType SHORT_TYPE = VariableType.valueOf("S");
    public static final VariableType INT_WRAPPER_TYPE = VariableType.valueOf("Ljava/lang/Integer;");
    public static final VariableType LONG_WRAPPER_TYPE = VariableType.valueOf("Ljava/lang/Long;");
    public static final VariableType FLOAT_WRAPPER_TYPE = VariableType.valueOf("Ljava/lang/Float;");
    public static final VariableType DOUBLE_WRAPPER_TYPE = VariableType.valueOf("Ljava/lang/Double;");
    public static final VariableType BOOLEAN_WRAPPER_TYPE = VariableType.valueOf("Ljava/lang/Boolean;");
    public static final VariableType BYTE_WRAPPER_TYPE = VariableType.valueOf("Ljava/lang/Byte;");
    public static final VariableType CHAR_WRAPPER_TYPE = VariableType.valueOf("Ljava/lang/Character;");
    public static final VariableType SHORT_WRAPPER_TYPE = VariableType.valueOf("Ljava/lang/Short;");
    public static final VariableType OBJECT_TYPE = VariableType.valueOf("Ljava/lang/Object;");
    public static final VariableType STRING_TYPE = VariableType.valueOf("Ljava/lang/String;");
    public static final VariableType RUNTIME_EXCEPTION_TYPE = VariableType.valueOf("Ljava/lang/RuntimeException;");
    public static final VariableType NUMBER_FORMAT_EXCEPTION_TYPE = VariableType.valueOf("Ljava/lang/NumberFormatException;");
    public static final VariableType NULL_POINTER_EXCEPTION_TYPE = VariableType.valueOf("Ljava/lang/NullPointerException;");
    public static final VariableType ARRAY_INDEX_OUT_OF_BOUNDS_EXCEPTION_TYPE = VariableType.valueOf("Ljava/lang/ArrayIndexOutOfBoundsException;");
    public static final VariableType NEGATIVE_ARRAY_SIZE_EXCEPTION_TYPE = VariableType.valueOf("Ljava/lang/NegativeArraySizeException;");
    public static final VariableType CLASS_CAST_EXCEPTION_TYPE = VariableType.valueOf("Ljava/lang/ClassCastException;");
    public static final VariableType STACK_OVERFLOW_ERROR_TYPE = VariableType.valueOf("Ljava/lang/StackOverflowError;");
    public static final VariableType ARITHMETIC_EXCEPTION_TYPE = VariableType.valueOf("Ljava/lang/ArithmeticException;");
    public static final VariableType BIGINTEGER_TYPE = VariableType.valueOf("Ljava/math/BigInteger;");
    public static final VariableType ARRAYLIST_TYPE = VariableType.valueOf("Ljava/util/ArrayList;");
    public static final VariableType STRINGBUILDER_TYPE = VariableType.valueOf("Ljava/lang/StringBuilder;");
    public static final VariableType ADDRESS_TYPE = VariableType.valueOf("Lio/nuls/contract/sdk/Address;");
    public static final VariableType BLOCK_HEADER_TYPE = VariableType.valueOf("Lio/nuls/contract/sdk/BlockHeader;");
    public static final VariableType INT_ARRAY_TYPE = VariableType.valueOf("[I");
    public static final VariableType LONG_ARRAY_TYPE = VariableType.valueOf("[J");
    public static final VariableType FLOAT_ARRAY_TYPE = VariableType.valueOf("[F");
    public static final VariableType DOUBLE_ARRAY_TYPE = VariableType.valueOf("[D");
    public static final VariableType BOOLEAN_ARRAY_TYPE = VariableType.valueOf("[Z");
    public static final VariableType BYTE_ARRAY_TYPE = VariableType.valueOf("[B");
    public static final VariableType CHAR_ARRAY_TYPE = VariableType.valueOf("[C");
    public static final VariableType SHORT_ARRAY_TYPE = VariableType.valueOf("[S");
    public static final VariableType STRING_ARRAY_TYPE = VariableType.valueOf("[Ljava/lang/String;");
    public static final VariableType STRING_TWO_DIMENSIONAL_ARRAY_TYPE = VariableType.valueOf("[[Ljava/lang/String;");
    public static final VariableType STACK_TRACE_ELEMENT_TYPE = VariableType.valueOf("Ljava/lang/StackTraceElement;");
    public static final VariableType STACK_TRACE_ELEMENT_ARRAY_TYPE = VariableType.valueOf("[Ljava/lang/StackTraceElement;");
    public static final VariableType ABSTRACT_COLLECTION_TYPE = VariableType.valueOf("Ljava/util/AbstractCollection;");
    public static final VariableType HASH_MAP_TYPE = VariableType.valueOf("Ljava/util/HashMap;");
    public static final VariableType HASH_MAP_NODE_TYPE = VariableType.valueOf("Ljava/util/HashMap$Node;");
    public static final VariableType MULTY_ASSET_VALUE_TYPE = VariableType.valueOf("Lio/nuls/contract/sdk/MultyAssetValue;");
    public static final VariableType MULTY_ASSET_VALUE_ARRAY_TYPE = VariableType.valueOf("[Lio/nuls/contract/sdk/MultyAssetValue;");
    public static final VariableType[] WRAPPER_TYPE = new VariableType[]{INT_WRAPPER_TYPE, LONG_WRAPPER_TYPE, FLOAT_WRAPPER_TYPE, DOUBLE_WRAPPER_TYPE, BOOLEAN_WRAPPER_TYPE, BYTE_WRAPPER_TYPE, CHAR_WRAPPER_TYPE, SHORT_WRAPPER_TYPE};
    public static final BiMap<String, String> DESCRIPTORS = HashBiMap.create();
    private String desc;
    private String type;
    private VariableType componentType;
    private boolean primitiveType;
    private boolean primitive;
    private boolean array;
    private int dimensions;
    private Object defaultValue;

    private VariableType(String desc) {
        String type;
        String descriptor = (String)Descriptors.DESCRIPTORS.get((Object)desc);
        this.desc = descriptor != null ? descriptor : desc;
        this.type = this.desc;
        if (this.type.contains("[")) {
            this.array = true;
            this.dimensions = this.type.lastIndexOf("[") + 1;
            this.type = this.desc.replace("[", "");
            this.componentType = VariableType.valueOf(this.desc.replaceFirst("\\[", ""));
        }
        if ((type = (String)Descriptors.DESCRIPTORS.inverse().get((Object)this.type)) != null) {
            this.type = type;
            this.primitiveType = this.isNotVoid();
        } else if (this.type.startsWith("L") && this.type.endsWith(";")) {
            this.type = this.type.substring(1, this.type.length() - 1);
        } else {
            this.desc = "L" + this.type + ";";
        }
        if (!this.array && this.primitiveType) {
            this.primitive = true;
            this.defaultValue = this.defaultValue();
        }
    }

    public static VariableType valueOf(String desc) {
        try {
            VariableType variableType = (VariableType)CACHE.get((Object)desc);
            if (!variableType.getDesc().equals(desc)) {
                variableType = (VariableType)CACHE.get((Object)variableType.getDesc());
                CACHE.put((Object)desc, (Object)variableType);
            }
            return variableType;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<VariableType> parseArgs(String desc) {
        List<VariableType> args = VariableType.parseAll(desc);
        return args.subList(0, args.size() - 1);
    }

    public static List<VariableType> parseAll(String desc) {
        try {
            return (List)CACHE_LIST.get((Object)desc);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<VariableType> parseList(String desc) {
        List<String> list = Descriptors.parse(desc, true);
        ArrayList<VariableType> args = new ArrayList<VariableType>(Utils.arrayListInitialCapacity(list.size()));
        for (String type : list) {
            args.add(VariableType.valueOf(type));
        }
        return args;
    }

    public boolean isVoid() {
        return "void".equals(this.type);
    }

    public boolean isNotVoid() {
        return !this.isVoid();
    }

    public boolean isByte() {
        return this.primitive && "byte".equals(this.type);
    }

    public boolean isChar() {
        return this.primitive && "char".equals(this.type);
    }

    public boolean isDouble() {
        return this.primitive && "double".equals(this.type);
    }

    public boolean isFloat() {
        return this.primitive && "float".equals(this.type);
    }

    public boolean isInt() {
        return this.primitive && "int".equals(this.type);
    }

    public boolean isLong() {
        return this.primitive && "long".equals(this.type);
    }

    public boolean isShort() {
        return this.primitive && "short".equals(this.type);
    }

    public boolean isBoolean() {
        return this.primitive && "boolean".equals(this.type);
    }

    public Object defaultValue() {
        Constable defaultValue = null;
        switch (this.type) {
            case "int": {
                defaultValue = 0;
                break;
            }
            case "long": {
                defaultValue = 0L;
                break;
            }
            case "float": {
                defaultValue = Float.valueOf(0.0f);
                break;
            }
            case "double": {
                defaultValue = 0.0;
                break;
            }
            case "boolean": {
                defaultValue = Boolean.valueOf(false);
                break;
            }
            case "byte": {
                defaultValue = (byte)0;
                break;
            }
            case "char": {
                defaultValue = Character.valueOf('\u0000');
                break;
            }
            case "short": {
                defaultValue = (short)0;
                break;
            }
        }
        return defaultValue;
    }

    public Class getPrimitiveTypeClass() {
        Class<Constable> clazz = null;
        if (!this.primitiveType) {
            return clazz;
        }
        switch (this.type) {
            case "int": {
                clazz = Integer.TYPE;
                break;
            }
            case "long": {
                clazz = Long.TYPE;
                break;
            }
            case "float": {
                clazz = Float.TYPE;
                break;
            }
            case "double": {
                clazz = Double.TYPE;
                break;
            }
            case "boolean": {
                clazz = Boolean.TYPE;
                break;
            }
            case "byte": {
                clazz = Byte.TYPE;
                break;
            }
            case "char": {
                clazz = Character.TYPE;
                break;
            }
            case "short": {
                clazz = Short.TYPE;
                break;
            }
        }
        return clazz;
    }

    public Object getPrimitiveValue(Object value) {
        if (this.primitive) {
            if (value == null || "".equals(value.toString())) {
                value = this.defaultValue();
            } else {
                String s = value.toString();
                switch (this.type) {
                    case "int": {
                        value = (int)Integer.valueOf(s);
                        break;
                    }
                    case "long": {
                        value = (long)Long.valueOf(s);
                        break;
                    }
                    case "float": {
                        value = Float.valueOf(Float.valueOf(s).floatValue());
                        break;
                    }
                    case "double": {
                        value = (double)Double.valueOf(s);
                        break;
                    }
                    case "boolean": {
                        if ("true".equalsIgnoreCase(s) || "1".equals(s)) {
                            value = true;
                            break;
                        }
                        value = false;
                        break;
                    }
                    case "byte": {
                        value = (byte)Byte.valueOf(s);
                        break;
                    }
                    case "char": {
                        if (value instanceof Integer) {
                            value = Character.valueOf((char)((Integer)value).intValue());
                            break;
                        }
                        value = Character.valueOf(s.charAt(0));
                        break;
                    }
                    case "short": {
                        value = (short)Short.valueOf(s);
                        break;
                    }
                }
            }
        }
        return value;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getType() {
        return this.type;
    }

    public VariableType getComponentType() {
        return this.componentType;
    }

    public boolean isPrimitiveType() {
        return this.primitiveType;
    }

    public boolean isWrapperType() {
        return ArrayUtils.contains((Object[])WRAPPER_TYPE, (Object)this);
    }

    public boolean isStringType() {
        return STRING_TYPE.equals(this);
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isArray() {
        return this.array;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableType that = (VariableType)o;
        if (this.primitiveType != that.primitiveType) {
            return false;
        }
        if (this.primitive != that.primitive) {
            return false;
        }
        if (this.array != that.array) {
            return false;
        }
        if (this.dimensions != that.dimensions) {
            return false;
        }
        if (this.desc != null ? !this.desc.equals(that.desc) : that.desc != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.componentType != null ? !this.componentType.equals(that.componentType) : that.componentType != null) {
            return false;
        }
        return this.defaultValue != null ? this.defaultValue.equals(that.defaultValue) : that.defaultValue == null;
    }

    public int hashCode() {
        int result = this.desc != null ? this.desc.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.componentType != null ? this.componentType.hashCode() : 0);
        result = 31 * result + (this.primitiveType ? 1 : 0);
        result = 31 * result + (this.primitive ? 1 : 0);
        result = 31 * result + (this.array ? 1 : 0);
        result = 31 * result + this.dimensions;
        result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "VariableType{desc=" + this.desc + ", type=" + this.type + ", componentType=" + this.componentType + ", primitiveType=" + this.primitiveType + ", primitive=" + this.primitive + ", array=" + this.array + ", dimensions=" + this.dimensions + ", defaultValue=" + this.defaultValue + "}";
    }

    static {
        DESCRIPTORS.put((Object)"z", (Object)"Ljava/lang/Boolean;");
        DESCRIPTORS.put((Object)"[z", (Object)"[Ljava/lang/Boolean;");
        DESCRIPTORS.put((Object)"b", (Object)"Ljava/lang/Byte;");
        DESCRIPTORS.put((Object)"[b", (Object)"[Ljava/lang/Byte;");
        DESCRIPTORS.put((Object)"s", (Object)"Ljava/lang/Short;");
        DESCRIPTORS.put((Object)"[s", (Object)"[Ljava/lang/Short;");
        DESCRIPTORS.put((Object)"c", (Object)"Ljava/lang/Character;");
        DESCRIPTORS.put((Object)"[c", (Object)"[Ljava/lang/Character;");
        DESCRIPTORS.put((Object)"i", (Object)"Ljava/lang/Integer;");
        DESCRIPTORS.put((Object)"[i", (Object)"[Ljava/lang/Integer;");
        DESCRIPTORS.put((Object)"l", (Object)"Ljava/lang/Long;");
        DESCRIPTORS.put((Object)"[l", (Object)"[Ljava/lang/Long;");
        DESCRIPTORS.put((Object)"f", (Object)"Ljava/lang/Float;");
        DESCRIPTORS.put((Object)"[f", (Object)"[Ljava/lang/Float;");
        DESCRIPTORS.put((Object)"d", (Object)"Ljava/lang/Double;");
        DESCRIPTORS.put((Object)"[d", (Object)"[Ljava/lang/Double;");
        DESCRIPTORS.put((Object)"r", (Object)"Ljava/lang/String;");
        DESCRIPTORS.put((Object)"[r", (Object)"[Ljava/lang/String;");
        DESCRIPTORS.put((Object)"e", (Object)"Ljava/math/BigInteger;");
        DESCRIPTORS.put((Object)"[e", (Object)"[Ljava/math/BigInteger;");
        DESCRIPTORS.put((Object)"a", (Object)"Lio/nuls/contract/sdk/Address;");
        DESCRIPTORS.put((Object)"[a", (Object)"[Lio/nuls/contract/sdk/Address;");
        DESCRIPTORS.put((Object)"m", (Object)"Ljava/util/HashMap;");
        DESCRIPTORS.put((Object)"n", (Object)"Ljava/util/HashMap$Node;");
        DESCRIPTORS.put((Object)"[n", (Object)"[Ljava/util/HashMap$Node;");
        DESCRIPTORS.put((Object)"g", (Object)"Ljava/util/ArrayList;");
        DESCRIPTORS.put((Object)"o", (Object)"Ljava/lang/Object;");
        DESCRIPTORS.put((Object)"[o", (Object)"[Ljava/lang/Object;");
    }
}

