/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.instructions.control;

import io.nuls.contract.vm.Frame;
import io.nuls.contract.vm.ObjectRef;

public class Return {
    public static void ireturn(Frame frame) {
        Comparable<Boolean> result;
        switch (frame.result.getVariableType().getType()) {
            case "boolean": {
                result = frame.operandStack.popBoolean();
                break;
            }
            case "byte": {
                result = frame.operandStack.popByte();
                break;
            }
            case "char": {
                result = Character.valueOf(frame.operandStack.popChar());
                break;
            }
            case "short": {
                result = frame.operandStack.popShort();
                break;
            }
            default: {
                result = frame.operandStack.popInt();
            }
        }
        frame.result.value(result);
    }

    public static void lreturn(Frame frame) {
        long result = frame.operandStack.popLong();
        frame.result.value(result);
    }

    public static void freturn(Frame frame) {
        float result = frame.operandStack.popFloat();
        frame.result.value(Float.valueOf(result));
    }

    public static void dreturn(Frame frame) {
        double result = frame.operandStack.popDouble();
        frame.result.value(result);
    }

    public static void areturn(Frame frame) {
        ObjectRef result = frame.operandStack.popRef();
        frame.result.value(result);
    }

    public static void return_(Frame frame) {
        frame.result.value(null);
    }
}

