/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.instructions.math;

import io.nuls.contract.vm.Frame;

public class Div {
    public static void idiv(Frame frame) {
        int value2 = frame.operandStack.popInt();
        int value1 = frame.operandStack.popInt();
        try {
            int result = value1 / value2;
            frame.operandStack.pushInt(result);
        }
        catch (ArithmeticException e) {
            frame.throwArithmeticException(e.getMessage());
            return;
        }
    }

    public static void ldiv(Frame frame) {
        long value2 = frame.operandStack.popLong();
        long value1 = frame.operandStack.popLong();
        try {
            long result = value1 / value2;
            frame.operandStack.pushLong(result);
        }
        catch (ArithmeticException e) {
            frame.throwArithmeticException(e.getMessage());
            return;
        }
    }

    public static void fdiv(Frame frame) {
        float value2 = frame.operandStack.popFloat();
        float value1 = frame.operandStack.popFloat();
        try {
            float result = value1 / value2;
            frame.operandStack.pushFloat(result);
        }
        catch (ArithmeticException e) {
            frame.throwArithmeticException(e.getMessage());
            return;
        }
    }

    public static void ddiv(Frame frame) {
        double value2 = frame.operandStack.popDouble();
        double value1 = frame.operandStack.popDouble();
        try {
            double result = value1 / value2;
            frame.operandStack.pushDouble(result);
        }
        catch (ArithmeticException e) {
            frame.throwArithmeticException(e.getMessage());
            return;
        }
    }
}

