/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.instructions.references;

import io.nuls.contract.vm.Frame;
import io.nuls.contract.vm.ObjectRef;
import io.nuls.contract.vm.code.ClassCode;
import java.util.Objects;
import org.objectweb.asm.tree.TryCatchBlockNode;

public class Athrow {
    public static void athrow(Frame frame) {
        ObjectRef objectRef = frame.operandStack.popRef();
        if (objectRef == null) {
            frame.throwNullPointerException();
            return;
        }
        while (frame.vm.isNotEmptyFrame()) {
            Frame lastFrame = frame.vm.lastFrame();
            TryCatchBlockNode tryCatchBlockNode = Athrow.getTryCatchBlockNode(lastFrame, objectRef);
            if (tryCatchBlockNode != null) {
                lastFrame.operandStack.clear();
                lastFrame.operandStack.pushRef(objectRef);
                lastFrame.jump(tryCatchBlockNode.handler);
                return;
            }
            frame.vm.popFrame();
        }
        frame.vm.getResult().exception(objectRef);
    }

    private static TryCatchBlockNode getTryCatchBlockNode(Frame frame, ObjectRef objectRef) {
        for (TryCatchBlockNode tryCatchBlockNode : frame.methodCode.tryCatchBlocks) {
            boolean result;
            String type = tryCatchBlockNode.type;
            int line = frame.getLine();
            int start = frame.getLine(tryCatchBlockNode.start);
            int end = frame.getLine(tryCatchBlockNode.end);
            int handler = frame.getLine(tryCatchBlockNode.handler);
            if (type != null && handler < end) {
                end = handler;
            }
            if (!(result = start <= line && line < end) || type != null && !Athrow.extends_(objectRef.getVariableType().getType(), type, frame)) continue;
            return tryCatchBlockNode;
        }
        return null;
    }

    private static boolean extends_(String refType, String className, Frame frame) {
        if (Objects.equals(refType, className)) {
            return true;
        }
        ClassCode classCode = frame.methodArea.loadClass(refType);
        String superName = classCode.superName;
        if ("java/lang/Object".equals(superName)) {
            return false;
        }
        return Athrow.extends_(superName, className, frame);
    }
}

