/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.instructions.references;

import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.contract.config.ContractContext;
import io.nuls.contract.vm.Frame;
import io.nuls.contract.vm.MethodArgs;
import io.nuls.contract.vm.ObjectRef;
import io.nuls.contract.vm.Result;
import io.nuls.contract.vm.code.MethodCode;
import io.nuls.contract.vm.natives.NativeMethod;
import org.objectweb.asm.tree.MethodInsnNode;

public class Invokespecial {
    private static final String GROW_CLASS_NAME = "java/util/ArrayList";
    private static final String GROW_METHOD_NAME = "grow";
    private static final String GROW_METHOD_DESC = "(I)V";

    public static void invokespecial(Frame frame) {
        MethodInsnNode methodInsnNode = frame.methodInsnNode();
        String className = methodInsnNode.owner;
        String methodName = methodInsnNode.name;
        String methodDesc = methodInsnNode.desc;
        MethodCode methodCode = frame.methodArea.loadMethod(className, methodName, methodDesc);
        MethodArgs methodArgs = new MethodArgs(methodCode.argsVariableType, frame.operandStack, false);
        ObjectRef objectRef = methodArgs.objectRef;
        if (objectRef == null) {
            frame.throwNullPointerException();
            return;
        }
        if ("java/lang/Object".equals(className) && "<init>".equals(methodName)) {
            return;
        }
        Result result = NativeMethod.run(methodCode, methodArgs, frame);
        if (result != null) {
            return;
        }
        if (ProtocolGroupManager.getCurrentVersion((int)ContractContext.LOCAL_CHAIN_ID) >= ContractContext.UPDATE_VERSION_CONTRACT_BALANCE && methodCode.isMethod(GROW_CLASS_NAME, GROW_METHOD_NAME, GROW_METHOD_DESC)) {
            MethodCode sizeMethod = frame.vm.methodArea.loadMethod(className, "size", "()I");
            frame.vm.run(sizeMethod, new Object[]{objectRef}, false);
            Object sizeResult = frame.vm.getResultValue();
            int size = (Integer)sizeResult;
            if (size >= 71140) {
                frame.throwRuntimeException("Max size of ArrayList is 71140");
                return;
            }
        }
        frame.vm.run(methodCode, methodArgs.frameArgs, true);
    }
}

