/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.instructions.stores;

import io.nuls.contract.vm.Frame;
import io.nuls.contract.vm.ObjectRef;

public class Xastore {
    public static void iastore(Frame frame) {
        int value = frame.operandStack.popInt();
        int index = frame.operandStack.popInt();
        ObjectRef arrayRef = frame.operandStack.popRef();
        if (!frame.checkArray(arrayRef, index)) {
            return;
        }
        frame.heap.putArray(arrayRef, index, value);
    }

    public static void lastore(Frame frame) {
        long value = frame.operandStack.popLong();
        int index = frame.operandStack.popInt();
        ObjectRef arrayRef = frame.operandStack.popRef();
        if (!frame.checkArray(arrayRef, index)) {
            return;
        }
        frame.heap.putArray(arrayRef, index, value);
    }

    public static void fastore(Frame frame) {
        float value = frame.operandStack.popFloat();
        int index = frame.operandStack.popInt();
        ObjectRef arrayRef = frame.operandStack.popRef();
        if (!frame.checkArray(arrayRef, index)) {
            return;
        }
        frame.heap.putArray(arrayRef, index, Float.valueOf(value));
    }

    public static void dastore(Frame frame) {
        double value = frame.operandStack.popDouble();
        int index = frame.operandStack.popInt();
        ObjectRef arrayRef = frame.operandStack.popRef();
        if (!frame.checkArray(arrayRef, index)) {
            return;
        }
        frame.heap.putArray(arrayRef, index, value);
    }

    public static void aastore(Frame frame) {
        ObjectRef value = frame.operandStack.popRef();
        int index = frame.operandStack.popInt();
        ObjectRef arrayRef = frame.operandStack.popRef();
        if (!frame.checkArray(arrayRef, index)) {
            return;
        }
        frame.heap.putArray(arrayRef, index, value);
    }

    public static void bastore(Frame frame) {
        int i = frame.operandStack.popInt();
        int index = frame.operandStack.popInt();
        ObjectRef arrayRef = frame.operandStack.popRef();
        if (!frame.checkArray(arrayRef, index)) {
            return;
        }
        if (arrayRef.getVariableType().getComponentType().isBoolean()) {
            boolean value = i == 1;
            frame.heap.putArray(arrayRef, index, value);
        } else {
            byte value = (byte)i;
            frame.heap.putArray(arrayRef, index, value);
        }
    }

    public static void castore(Frame frame) {
        char value = frame.operandStack.popChar();
        int index = frame.operandStack.popInt();
        ObjectRef arrayRef = frame.operandStack.popRef();
        if (!frame.checkArray(arrayRef, index)) {
            return;
        }
        frame.heap.putArray(arrayRef, index, Character.valueOf(value));
    }

    public static void sastore(Frame frame) {
        short value = frame.operandStack.popShort();
        int index = frame.operandStack.popInt();
        ObjectRef arrayRef = frame.operandStack.popRef();
        if (!frame.checkArray(arrayRef, index)) {
            return;
        }
        frame.heap.putArray(arrayRef, index, value);
    }
}

