/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.natives.io.nuls.contract.sdk;

import io.nuls.contract.model.dto.BlockHeaderDto;
import io.nuls.contract.vm.Frame;
import io.nuls.contract.vm.MethodArgs;
import io.nuls.contract.vm.ObjectRef;
import io.nuls.contract.vm.Result;
import io.nuls.contract.vm.code.MethodCode;
import io.nuls.contract.vm.code.VariableType;
import io.nuls.contract.vm.natives.NativeMethod;
import io.nuls.contract.vm.natives.io.nuls.contract.sdk.NativeAddress;
import io.nuls.core.crypto.HexUtil;

public class NativeBlock {
    public static final String TYPE = "io/nuls/contract/sdk/Block";
    public static final String getBlockHeader = "io/nuls/contract/sdk/Block.getBlockHeader(J)Lio/nuls/contract/sdk/BlockHeader;";
    public static final String currentBlockHeader = "io/nuls/contract/sdk/Block.currentBlockHeader()Lio/nuls/contract/sdk/BlockHeader;";
    public static final String newestBlockHeader = "io/nuls/contract/sdk/Block.newestBlockHeader()Lio/nuls/contract/sdk/BlockHeader;";

    public static Result nativeRun(MethodCode methodCode, MethodArgs methodArgs, Frame frame, boolean check) {
        switch (methodCode.fullName) {
            case "io/nuls/contract/sdk/Block.getBlockHeader(J)Lio/nuls/contract/sdk/BlockHeader;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeBlock.getBlockHeader(methodCode, methodArgs, frame);
            }
            case "io/nuls/contract/sdk/Block.currentBlockHeader()Lio/nuls/contract/sdk/BlockHeader;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeBlock.currentBlockHeader(methodCode, methodArgs, frame);
            }
            case "io/nuls/contract/sdk/Block.newestBlockHeader()Lio/nuls/contract/sdk/BlockHeader;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeBlock.newestBlockHeader(methodCode, methodArgs, frame);
            }
        }
        if (check) {
            return NativeMethod.NOT_SUPPORT_NATIVE;
        }
        frame.nonsupportMethod(methodCode);
        return null;
    }

    private static Result getBlockHeader(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        long blockNumber = (Long)methodArgs.invokeArgs[0];
        ObjectRef objectRef = NativeBlock.getBlockHeader(blockNumber, frame);
        Result result = NativeMethod.result(methodCode, objectRef, frame);
        return result;
    }

    private static Result currentBlockHeader(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        long blockNumber = frame.vm.getProgramInvoke().getNumber();
        ObjectRef objectRef = NativeBlock.getBlockHeader(blockNumber + 1L, frame);
        Result result = NativeMethod.result(methodCode, objectRef, frame);
        return result;
    }

    private static Result newestBlockHeader(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        long blockNumber = frame.vm.getProgramInvoke().getNumber();
        ObjectRef objectRef = NativeBlock.getBlockHeader(blockNumber, frame);
        Result result = NativeMethod.result(methodCode, objectRef, frame);
        return result;
    }

    private static ObjectRef getBlockHeader(long blockNumber, Frame frame) {
        String fieldName = "BlockHeader$" + blockNumber;
        Object object = frame.heap.getStatic(VariableType.BLOCK_HEADER_TYPE.getType(), fieldName);
        if (object != null) {
            return (ObjectRef)object;
        }
        BlockHeaderDto blockHeaderDto = frame.vm.getBlockHeader(blockNumber);
        if (blockHeaderDto != null) {
            ObjectRef objectRef = frame.heap.newObject(VariableType.BLOCK_HEADER_TYPE);
            frame.heap.putField(objectRef, "hash", frame.heap.newString(blockHeaderDto.getHash()));
            frame.heap.putField(objectRef, "time", blockHeaderDto.getTime());
            frame.heap.putField(objectRef, "height", blockHeaderDto.getHeight());
            frame.heap.putField(objectRef, "txCount", blockHeaderDto.getTxCount());
            ObjectRef packingAddress = null;
            if (blockHeaderDto.getPackingAddress() != null) {
                packingAddress = frame.heap.newAddress(NativeAddress.toString(blockHeaderDto.getPackingAddress()));
            }
            frame.heap.putField(objectRef, "packingAddress", packingAddress);
            String stateRoot = null;
            if (blockHeaderDto.getStateRoot() != null) {
                stateRoot = HexUtil.encode((byte[])blockHeaderDto.getStateRoot());
            }
            frame.heap.putField(objectRef, "stateRoot", frame.heap.newString(stateRoot));
            frame.heap.putStatic(VariableType.BLOCK_HEADER_TYPE.getType(), fieldName, objectRef);
            return objectRef;
        }
        return null;
    }
}

