/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.natives.io.nuls.contract.sdk;

import io.nuls.contract.vm.Frame;
import io.nuls.contract.vm.MethodArgs;
import io.nuls.contract.vm.Result;
import io.nuls.contract.vm.code.MethodCode;
import io.nuls.contract.vm.natives.NativeMethod;

public class NativeMsg {
    public static final String TYPE = "io/nuls/contract/sdk/Msg";
    public static final String gasleft = "io/nuls/contract/sdk/Msg.gasleft()J";
    public static final String sender = "io/nuls/contract/sdk/Msg.sender()Lio/nuls/contract/sdk/Address;";
    public static final String senderPublicKey = "io/nuls/contract/sdk/Msg.senderPublicKey()Ljava/lang/String;";
    public static final String value = "io/nuls/contract/sdk/Msg.value()Ljava/math/BigInteger;";
    public static final String multyAssetValues = "io/nuls/contract/sdk/Msg.multyAssetValues()[Lio/nuls/contract/sdk/MultyAssetValue;";
    public static final String gasprice = "io/nuls/contract/sdk/Msg.gasprice()J";
    public static final String address = "io/nuls/contract/sdk/Msg.address()Lio/nuls/contract/sdk/Address;";

    public static Result nativeRun(MethodCode methodCode, MethodArgs methodArgs, Frame frame, boolean check) {
        switch (methodCode.fullName) {
            case "io/nuls/contract/sdk/Msg.gasleft()J": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeMsg.gasleft(methodCode, methodArgs, frame);
            }
            case "io/nuls/contract/sdk/Msg.sender()Lio/nuls/contract/sdk/Address;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeMsg.sender(methodCode, methodArgs, frame);
            }
            case "io/nuls/contract/sdk/Msg.senderPublicKey()Ljava/lang/String;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeMsg.senderPublicKey(methodCode, methodArgs, frame);
            }
            case "io/nuls/contract/sdk/Msg.value()Ljava/math/BigInteger;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeMsg.value(methodCode, methodArgs, frame);
            }
            case "io/nuls/contract/sdk/Msg.multyAssetValues()[Lio/nuls/contract/sdk/MultyAssetValue;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeMsg.multyAssetValues(methodCode, methodArgs, frame);
            }
            case "io/nuls/contract/sdk/Msg.gasprice()J": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeMsg.gasprice(methodCode, methodArgs, frame);
            }
            case "io/nuls/contract/sdk/Msg.address()Lio/nuls/contract/sdk/Address;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeMsg.address(methodCode, methodArgs, frame);
            }
        }
        if (check) {
            return NativeMethod.NOT_SUPPORT_NATIVE;
        }
        frame.nonsupportMethod(methodCode);
        return null;
    }

    private static Result gasleft(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        Result result = NativeMethod.result(methodCode, frame.vm.getGasLeft(), frame);
        return result;
    }

    private static Result sender(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        Result result = NativeMethod.result(methodCode, frame.vm.getProgramContext().getSender(), frame);
        return result;
    }

    private static Result senderPublicKey(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        Result result = NativeMethod.result(methodCode, frame.vm.getProgramContext().getSenderPublicKey(), frame);
        return result;
    }

    private static Result value(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        Result result = NativeMethod.result(methodCode, frame.vm.getProgramContext().getValue(), frame);
        return result;
    }

    private static Result multyAssetValues(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        Result result = NativeMethod.result(methodCode, frame.vm.getProgramContext().getMultyAssetValues(), frame);
        return result;
    }

    private static Result gasprice(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        Result result = NativeMethod.result(methodCode, frame.vm.getProgramContext().getGasPrice(), frame);
        return result;
    }

    private static Result address(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        Result result = NativeMethod.result(methodCode, frame.vm.getProgramContext().getAddress(), frame);
        return result;
    }
}

