/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.natives.java.lang;

import io.nuls.contract.vm.Frame;
import io.nuls.contract.vm.MethodArgs;
import io.nuls.contract.vm.ObjectRef;
import io.nuls.contract.vm.Result;
import io.nuls.contract.vm.code.MethodCode;
import io.nuls.contract.vm.natives.NativeMethod;

public class NativeAbstractStringBuilder {
    public static final String TYPE = "java/lang/AbstractStringBuilder";
    public static final String appendD = "java/lang/AbstractStringBuilder.append(D)Ljava/lang/AbstractStringBuilder;";
    public static final String appendF = "java/lang/AbstractStringBuilder.append(F)Ljava/lang/AbstractStringBuilder;";

    public static Result override(MethodCode methodCode, MethodArgs methodArgs, Frame frame, boolean check) {
        switch (methodCode.fullName) {
            case "java/lang/AbstractStringBuilder.append(D)Ljava/lang/AbstractStringBuilder;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeAbstractStringBuilder.append(methodCode, methodArgs, frame);
            }
            case "java/lang/AbstractStringBuilder.append(F)Ljava/lang/AbstractStringBuilder;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeAbstractStringBuilder.append(methodCode, methodArgs, frame);
            }
        }
        return null;
    }

    private static Result append(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        ObjectRef objectRef = methodArgs.objectRef;
        Object a = methodArgs.invokeArgs[0];
        ObjectRef ref = frame.heap.newString(a.toString());
        MethodCode append = frame.methodArea.loadMethod(TYPE, "append", "(Ljava/lang/String;)Ljava/lang/AbstractStringBuilder;");
        frame.vm.run(append, new Object[]{objectRef, ref}, false);
        Result result = NativeMethod.result(methodCode, objectRef, frame);
        return result;
    }
}

