/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.natives.java.lang;

import io.nuls.contract.vm.Frame;
import io.nuls.contract.vm.MethodArgs;
import io.nuls.contract.vm.Result;
import io.nuls.contract.vm.code.MethodCode;
import io.nuls.contract.vm.natives.NativeMethod;

public class NativeCharacter {
    public static final String TYPE = "java/lang/Character";
    public static final String digit = "java/lang/Character.digit(II)I";

    public static Result override(MethodCode methodCode, MethodArgs methodArgs, Frame frame, boolean check) {
        switch (methodCode.fullName) {
            case "java/lang/Character.digit(II)I": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeCharacter.digit(methodCode, methodArgs, frame);
            }
        }
        return null;
    }

    private static Result digit(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        int codePoint = (Integer)methodArgs.invokeArgs[0];
        int radix = (Integer)methodArgs.invokeArgs[1];
        int i = Character.digit(codePoint, radix);
        Result result = NativeMethod.result(methodCode, i, frame);
        return result;
    }
}

