/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.natives.java.lang.reflect;

import io.nuls.contract.vm.Frame;
import io.nuls.contract.vm.MethodArgs;
import io.nuls.contract.vm.ObjectRef;
import io.nuls.contract.vm.Result;
import io.nuls.contract.vm.code.MethodCode;
import io.nuls.contract.vm.code.VariableType;
import io.nuls.contract.vm.natives.NativeMethod;

public class NativeArray {
    public static final String TYPE = "java/lang/reflect/Array";
    public static final String newArray = "java/lang/reflect/Array.newArray(Ljava/lang/Class;I)Ljava/lang/Object;";

    public static Result nativeRun(MethodCode methodCode, MethodArgs methodArgs, Frame frame, boolean check) {
        switch (methodCode.fullName) {
            case "java/lang/reflect/Array.newArray(Ljava/lang/Class;I)Ljava/lang/Object;": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeArray.newArray(methodCode, methodArgs, frame);
            }
        }
        if (check) {
            return NativeMethod.NOT_SUPPORT_NATIVE;
        }
        frame.nonsupportMethod(methodCode);
        return null;
    }

    private static Result newArray(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        ObjectRef componentType = (ObjectRef)methodArgs.invokeArgs[0];
        int length = (Integer)methodArgs.invokeArgs[1];
        VariableType variableType = VariableType.valueOf("[" + componentType.getRef());
        ObjectRef array = frame.heap.newArray(variableType, length);
        Result result = NativeMethod.result(methodCode, array, frame);
        return result;
    }
}

