/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.natives.java.sun.misc;

import io.nuls.contract.vm.Frame;
import io.nuls.contract.vm.MethodArgs;
import io.nuls.contract.vm.ObjectRef;
import io.nuls.contract.vm.Result;
import io.nuls.contract.vm.code.MethodCode;
import io.nuls.contract.vm.natives.NativeMethod;

public class NativeVM {
    public static final String TYPE = "sun/misc/VM";
    public static final String initialize = "sun/misc/VM.initialize()V";

    public static Result nativeRun(MethodCode methodCode, MethodArgs methodArgs, Frame frame, boolean check) {
        switch (methodCode.fullName) {
            case "sun/misc/VM.initialize()V": {
                if (check) {
                    return NativeMethod.SUPPORT_NATIVE;
                }
                return NativeVM.initialize(methodCode, methodArgs, frame);
            }
        }
        if (check) {
            return NativeMethod.NOT_SUPPORT_NATIVE;
        }
        frame.nonsupportMethod(methodCode);
        return null;
    }

    private static Result initialize(MethodCode methodCode, MethodArgs methodArgs, Frame frame) {
        ObjectRef savedProps = (ObjectRef)frame.heap.getStatic(TYPE, "savedProps");
        ObjectRef key = frame.heap.newString("user.script");
        ObjectRef value = frame.heap.newString("");
        MethodCode methodCode1 = frame.methodArea.loadMethod("java/util/Properties", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        frame.vm.run(methodCode1, new Object[]{savedProps, key, value}, false);
        Result result = NativeMethod.result(methodCode, null, frame);
        return result;
    }
}

