/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.program;

import io.nuls.base.basic.AddressTool;
import java.math.BigInteger;

public class ProgramAccount {
    private byte[] address;
    private BigInteger balance;
    private BigInteger freeze;
    private String nonce;
    private int assetChainId;
    private int assetId;

    public ProgramAccount(byte[] address, BigInteger balance, String nonce, int assetChainId, int assetId) {
        this.address = address;
        this.balance = balance;
        this.nonce = nonce;
        this.freeze = BigInteger.ZERO;
        this.assetChainId = assetChainId;
        this.assetId = assetId;
    }

    public byte[] getAddress() {
        return this.address;
    }

    public BigInteger getBalance() {
        return this.balance;
    }

    public BigInteger addBalance(BigInteger value) {
        this.balance = this.balance.add(value);
        return this.balance;
    }

    public BigInteger getTotalBalance() {
        return this.balance.add(this.freeze);
    }

    public BigInteger addFreeze(BigInteger value) {
        this.freeze = this.freeze.add(value);
        return this.freeze;
    }

    public BigInteger getFreeze() {
        return this.freeze;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public int getAssetChainId() {
        return this.assetChainId;
    }

    public int getAssetId() {
        return this.assetId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"address\":").append(AddressTool.getStringAddressByBytes((byte[])this.address));
        sb.append(",\"balance\":").append(this.balance);
        sb.append(",\"freeze\":").append(this.freeze);
        sb.append(",\"nonce\":").append('\"').append(this.nonce).append('\"');
        sb.append(",\"assetChainId\":").append(this.assetChainId);
        sb.append(",\"assetId\":").append(this.assetId);
        sb.append('}');
        return sb.toString();
    }
}

