/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.program;

import io.nuls.base.basic.AddressTool;
import io.nuls.contract.vm.program.ProgramMultyAssetValue;
import io.nuls.core.crypto.HexUtil;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

public class ProgramCall {
    private long number;
    private byte[] sender;
    private byte[] senderPublicKey;
    private BigInteger value;
    private List<ProgramMultyAssetValue> multyAssetValues;
    private long gasLimit;
    private long price;
    private byte[] contractAddress;
    private String methodName;
    private String methodDesc;
    private String[][] args;
    private boolean estimateGas;
    private boolean viewMethod;
    private boolean internalCall;

    public void args(String ... args) {
        this.setArgs(args);
    }

    public String[][] getArgs() {
        return this.args;
    }

    public void setArgs(String[][] args) {
        this.args = args;
    }

    public void setArgs(String[] args) {
        this.args = ProgramCall.twoDimensionalArray(args);
    }

    public static String[][] twoDimensionalArray(String[] args) {
        if (args == null) {
            return null;
        }
        String[][] two = new String[args.length][0];
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg == null) continue;
            two[i] = new String[]{arg};
        }
        return two;
    }

    public long getNumber() {
        return this.number;
    }

    public void setNumber(long number) {
        this.number = number;
    }

    public byte[] getSender() {
        return this.sender;
    }

    public void setSender(byte[] sender) {
        this.sender = sender;
    }

    public byte[] getSenderPublicKey() {
        return this.senderPublicKey;
    }

    public void setSenderPublicKey(byte[] senderPublicKey) {
        this.senderPublicKey = senderPublicKey;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public void setValue(BigInteger value) {
        this.value = value;
    }

    public long getGasLimit() {
        return this.gasLimit;
    }

    public void setGasLimit(long gasLimit) {
        this.gasLimit = gasLimit;
    }

    public long getPrice() {
        return this.price;
    }

    public void setPrice(long price) {
        this.price = price;
    }

    public byte[] getContractAddress() {
        return this.contractAddress;
    }

    public void setContractAddress(byte[] contractAddress) {
        this.contractAddress = contractAddress;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getMethodDesc() {
        return this.methodDesc;
    }

    public void setMethodDesc(String methodDesc) {
        this.methodDesc = methodDesc;
    }

    public boolean isEstimateGas() {
        return this.estimateGas;
    }

    public void setEstimateGas(boolean estimateGas) {
        this.estimateGas = estimateGas;
    }

    public boolean isViewMethod() {
        return this.viewMethod;
    }

    public void setViewMethod(boolean viewMethod) {
        this.viewMethod = viewMethod;
    }

    public boolean isInternalCall() {
        return this.internalCall;
    }

    public void setInternalCall(boolean internalCall) {
        this.internalCall = internalCall;
    }

    public List<ProgramMultyAssetValue> getMultyAssetValues() {
        return this.multyAssetValues;
    }

    public void setMultyAssetValues(List<ProgramMultyAssetValue> multyAssetValues) {
        this.multyAssetValues = multyAssetValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgramCall that = (ProgramCall)o;
        if (this.number != that.number) {
            return false;
        }
        if (this.gasLimit != that.gasLimit) {
            return false;
        }
        if (this.price != that.price) {
            return false;
        }
        if (this.estimateGas != that.estimateGas) {
            return false;
        }
        if (this.viewMethod != that.viewMethod) {
            return false;
        }
        if (this.internalCall != that.internalCall) {
            return false;
        }
        if (!Arrays.equals(this.sender, that.sender)) {
            return false;
        }
        if (!Arrays.equals(this.senderPublicKey, that.senderPublicKey)) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        if (this.multyAssetValues != null ? !Arrays.deepEquals(this.multyAssetValues.toArray(), that.multyAssetValues != null ? that.multyAssetValues.toArray() : null) : that.multyAssetValues != null) {
            return false;
        }
        if (!Arrays.equals(this.contractAddress, that.contractAddress)) {
            return false;
        }
        if (this.methodName != null ? !this.methodName.equals(that.methodName) : that.methodName != null) {
            return false;
        }
        if (this.methodDesc != null ? !this.methodDesc.equals(that.methodDesc) : that.methodDesc != null) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.args, (Object[])that.args);
    }

    public int hashCode() {
        int result = (int)(this.number ^ this.number >>> 32);
        result = 31 * result + Arrays.hashCode(this.sender);
        result = 31 * result + Arrays.hashCode(this.senderPublicKey);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (int)(this.gasLimit ^ this.gasLimit >>> 32);
        result = 31 * result + (int)(this.price ^ this.price >>> 32);
        result = 31 * result + Arrays.hashCode(this.contractAddress);
        result = 31 * result + (this.methodName != null ? this.methodName.hashCode() : 0);
        result = 31 * result + (this.methodDesc != null ? this.methodDesc.hashCode() : 0);
        result = 31 * result + (this.multyAssetValues != null ? Arrays.deepHashCode(this.multyAssetValues.toArray()) : 0);
        result = 31 * result + Arrays.deepHashCode((Object[])this.args);
        result = 31 * result + (this.estimateGas ? 1 : 0);
        result = 31 * result + (this.viewMethod ? 1 : 0);
        result = 31 * result + (this.internalCall ? 1 : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"number\":").append(this.number);
        sb.append(",\"sender\":").append(AddressTool.getStringAddressByBytes((byte[])this.sender));
        sb.append(",\"senderPublicKey\":").append(HexUtil.encode((byte[])this.senderPublicKey));
        sb.append(",\"value\":").append(this.value);
        sb.append(",\"value\":").append(this.multyAssetValues != null ? Arrays.deepToString(this.multyAssetValues.toArray()) : "null");
        sb.append(",\"gasLimit\":").append(this.gasLimit);
        sb.append(",\"price\":").append(this.price);
        sb.append(",\"contractAddress\":").append(AddressTool.getStringAddressByBytes((byte[])this.contractAddress));
        sb.append(",\"methodName\":").append('\"').append(this.methodName).append('\"');
        sb.append(",\"methodDesc\":").append('\"').append(this.methodDesc).append('\"');
        sb.append(",\"args\":").append(Arrays.deepToString((Object[])this.args));
        sb.append(",\"estimateGas\":").append(this.estimateGas);
        sb.append(",\"viewMethod\":").append(this.viewMethod);
        sb.append(",\"internalCall\":").append(this.internalCall);
        sb.append('}');
        return sb.toString();
    }
}

