/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.program;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;

public class ProgramEncodePacked
extends BaseNulsData {
    private short argsCount;
    private String[] args;

    public ProgramEncodePacked(short argsCount, String[] args) {
        this.argsCount = argsCount;
        this.args = args;
    }

    public int size() {
        int size = 1;
        if (this.args != null) {
            for (String str : this.args) {
                size += SerializeUtils.sizeOfString((String)str);
            }
        }
        return size;
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint8(this.argsCount);
        if (this.args != null) {
            for (String str : this.args) {
                stream.writeString(str);
            }
        }
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        short length = this.argsCount = byteBuffer.readUint8();
        this.args = new String[length];
        for (short k = 0; k < length; k = (short)(k + 1)) {
            this.args[k] = byteBuffer.readString();
        }
    }

    public short getArgsCount() {
        return this.argsCount;
    }

    public void setArgsCount(short argsCount) {
        this.argsCount = argsCount;
    }

    public String[] getArgs() {
        return this.args;
    }

    public void setArgs(String[] args) {
        this.args = args;
    }
}

