/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.collect.BiMap;
import io.nuls.contract.vm.ObjectRef;
import io.nuls.contract.vm.util.Utils;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.LinkedHashMap;
import java.util.Map;

public class JsonUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static String toJson(Object value) {
        try {
            return OBJECT_MAPPER.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T toObject(String value, Class<T> valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(value, valueType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T toArray(String value, Class<?> elementType) {
        ArrayType arrayType = TypeFactory.defaultInstance().constructArrayType(elementType);
        try {
            return (T)OBJECT_MAPPER.readValue(value, (JavaType)arrayType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encodeArray(Object value, Class<?> elementType, BiMap<String, String> classNames) {
        String json;
        if (elementType == ObjectRef.class) {
            int length = Array.getLength(value);
            String[] array = new String[length];
            for (int i = 0; i < length; ++i) {
                ObjectRef objectRef = (ObjectRef)Array.get(value, i);
                if (objectRef == null) continue;
                array[i] = objectRef.getEncoded(classNames);
            }
            json = JsonUtils.toJson(array);
        } else {
            json = JsonUtils.toJson(value);
        }
        return json;
    }

    public static Object decodeArray(String value, Class<?> elementType, BiMap<String, String> classNames) {
        if (elementType == ObjectRef.class) {
            Object array = JsonUtils.toArray(value, String.class);
            int length = Array.getLength(array);
            ObjectRef[] objectRefs = new ObjectRef[length];
            for (int i = 0; i < length; ++i) {
                String s = (String)Array.get(array, i);
                if (s == null) continue;
                objectRefs[i] = new ObjectRef(s, classNames);
            }
            return objectRefs;
        }
        return JsonUtils.toArray(value, elementType);
    }

    public static String encode(Object value, BiMap<String, String> classNames) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            Class<?> clazz = value.getClass().getComponentType();
            if (clazz == Integer.TYPE) {
                return "[I_" + JsonUtils.encodeArray(value, clazz, classNames);
            }
            if (clazz == Long.TYPE) {
                return "[J_" + JsonUtils.encodeArray(value, clazz, classNames);
            }
            if (clazz == Float.TYPE) {
                return "[F_" + JsonUtils.encodeArray(value, clazz, classNames);
            }
            if (clazz == Double.TYPE) {
                return "[D_" + JsonUtils.encodeArray(value, clazz, classNames);
            }
            if (clazz == Boolean.TYPE) {
                return "[Z_" + JsonUtils.encodeArray(value, clazz, classNames);
            }
            if (clazz == Byte.TYPE) {
                return "[B_" + JsonUtils.encodeArray(value, clazz, classNames);
            }
            if (clazz == Character.TYPE) {
                return "[C_" + JsonUtils.encodeArray(value, clazz, classNames);
            }
            if (clazz == Short.TYPE) {
                return "[S_" + JsonUtils.encodeArray(value, clazz, classNames);
            }
            return "[R_" + JsonUtils.encodeArray(value, clazz, classNames);
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            LinkedHashMap map1 = new LinkedHashMap(Utils.hashMapInitialCapacity(map.size()));
            map.forEach((k, v) -> map1.put(k, JsonUtils.encode(v, classNames)));
            return JsonUtils.toJson(map1);
        }
        if (value instanceof Integer) {
            return "I_" + value;
        }
        if (value instanceof Long) {
            return "J_" + value;
        }
        if (value instanceof Float) {
            return "F_" + value;
        }
        if (value instanceof Double) {
            return "D_" + value;
        }
        if (value instanceof Boolean) {
            return "Z_" + value;
        }
        if (value instanceof Byte) {
            return "B_" + value;
        }
        if (value instanceof Character) {
            return "C_" + value;
        }
        if (value instanceof Short) {
            return "S_" + value;
        }
        if (value instanceof String) {
            return "s_" + value;
        }
        if (value instanceof ObjectRef) {
            return "R_" + ((ObjectRef)value).getEncoded(classNames);
        }
        throw new IllegalArgumentException("unknown value");
    }

    public static Object decode(String str, BiMap<String, String> classNames) {
        if (str == null) {
            return null;
        }
        String prefix = str.substring(0, 1);
        String value = str.substring(2);
        if (!"{".equals(prefix)) {
            String[] parts = str.split("_", 2);
            prefix = parts[0];
            value = parts[1];
        }
        switch (prefix) {
            case "{": {
                Map map = JsonUtils.toObject(str, Map.class);
                LinkedHashMap objectMap = new LinkedHashMap(Utils.hashMapInitialCapacity(map.size()));
                map.forEach((k, v) -> objectMap.put(k, JsonUtils.decode(v, classNames)));
                return objectMap;
            }
            case "I": {
                return (int)Integer.valueOf(value);
            }
            case "J": {
                return (long)Long.valueOf(value);
            }
            case "F": {
                return Float.valueOf(Float.valueOf(value).floatValue());
            }
            case "D": {
                return (double)Double.valueOf(value);
            }
            case "Z": {
                return (boolean)Boolean.valueOf(value);
            }
            case "B": {
                return (byte)Byte.valueOf(value);
            }
            case "C": {
                return Character.valueOf(value.charAt(0));
            }
            case "S": {
                return (short)Short.valueOf(value);
            }
            case "s": {
                return value;
            }
            case "R": {
                return new ObjectRef(value, classNames);
            }
            case "[I": {
                return JsonUtils.decodeArray(value, Integer.TYPE, classNames);
            }
            case "[J": {
                return JsonUtils.decodeArray(value, Long.TYPE, classNames);
            }
            case "[F": {
                return JsonUtils.decodeArray(value, Float.TYPE, classNames);
            }
            case "[D": {
                return JsonUtils.decodeArray(value, Double.TYPE, classNames);
            }
            case "[Z": {
                return JsonUtils.decodeArray(value, Boolean.TYPE, classNames);
            }
            case "[B": {
                return JsonUtils.decodeArray(value, Byte.TYPE, classNames);
            }
            case "[C": {
                return JsonUtils.decodeArray(value, Character.TYPE, classNames);
            }
            case "[S": {
                return JsonUtils.decodeArray(value, Short.TYPE, classNames);
            }
            case "[R": {
                return JsonUtils.decodeArray(value, ObjectRef.class, classNames);
            }
        }
        throw new IllegalArgumentException("unknown string");
    }
}

