/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.contract.vm.util;

import io.nuls.core.crypto.ECKey;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.model.StringUtils;
import java.nio.charset.StandardCharsets;

public class Utils {
    public static int arrayListInitialCapacity(int size) {
        return Math.max(size, 10);
    }

    public static int hashMapInitialCapacity(int size) {
        return Math.max((int)((double)size / 0.75) + 1, 16);
    }

    public static boolean verify(String data, String signature, String pub) {
        if (data == null || signature == null || pub == null) {
            return false;
        }
        byte[] dataBytes = HexUtil.decode((String)data);
        byte[] signatureBytes = HexUtil.decode((String)signature);
        byte[] pubBytes = HexUtil.decode((String)pub);
        return ECKey.verify((byte[])dataBytes, (byte[])signatureBytes, (byte[])pubBytes);
    }

    public static byte[] dataToBytes(String data) {
        if (StringUtils.isBlank((String)data)) {
            return null;
        }
        try {
            char[] chars;
            boolean isHex = true;
            String validData = Utils.cleanHexPrefix(data);
            for (char c : chars = validData.toCharArray()) {
                int digit = Character.digit(c, 16);
                if (digit != -1) continue;
                isHex = false;
                break;
            }
            if (isHex) {
                return HexUtil.decode((String)validData);
            }
            return data.getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return data.getBytes(StandardCharsets.UTF_8);
        }
    }

    public static boolean isHexString(String data) {
        if (StringUtils.isBlank((String)data)) {
            return false;
        }
        try {
            char[] chars;
            for (char c : chars = data.toCharArray()) {
                int digit = Character.digit(c, 16);
                if (digit != -1) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String cleanHexPrefix(String input) {
        return Utils.containsHexPrefix(input) ? input.substring(2) : input;
    }

    private static boolean containsHexPrefix(String input) {
        return !StringUtils.isBlank((String)input) && input.length() > 1 && input.charAt(0) == '0' && input.charAt(1) == 'x';
    }
}

