/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.base.message.handler;

import io.nuls.base.RPCUtil;
import io.nuls.base.protocol.MessageProcessor;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.crosschain.base.message.BroadCtxHashMessage;
import io.nuls.crosschain.base.service.ProtocolService;
import io.nuls.crosschain.base.utils.HashSetTimeDuplicateProcessor;

@Component(value="BroadCtxHashHandlerV1")
public class BroadCtxHashHandler
implements MessageProcessor {
    @Autowired
    private ProtocolService protocolService;
    private HashSetTimeDuplicateProcessor processor = new HashSetTimeDuplicateProcessor(1000, 300000L);

    public String getCmd() {
        return "recvCtxHash";
    }

    public void process(int chainId, String nodeId, String message) {
        BroadCtxHashMessage realMessage = (BroadCtxHashMessage)((Object)RPCUtil.getInstanceRpcStr((String)message, BroadCtxHashMessage.class));
        if (message == null) {
            return;
        }
        if (this.processor.insertAndCheck(nodeId + realMessage)) {
            this.protocolService.receiveCtxHash(chainId, nodeId, realMessage);
        }
    }
}

