/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.base.message.handler;

import io.nuls.base.RPCUtil;
import io.nuls.base.protocol.MessageProcessor;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.crosschain.base.message.GetOtherCtxMessage;
import io.nuls.crosschain.base.service.ProtocolService;
import io.nuls.crosschain.base.utils.HashSetTimeDuplicateProcessor;

@Component(value="GetOtherCtxHandlerV1")
public class GetOtherCtxHandler
implements MessageProcessor {
    @Autowired
    private ProtocolService protocolService;
    private HashSetTimeDuplicateProcessor processor = new HashSetTimeDuplicateProcessor(1000, 300000L);

    public String getCmd() {
        return "getOtherCtx";
    }

    public void process(int chainId, String nodeId, String message) {
        GetOtherCtxMessage realMessage = (GetOtherCtxMessage)((Object)RPCUtil.getInstanceRpcStr((String)message, GetOtherCtxMessage.class));
        if (realMessage == null || realMessage.getRequestHash() == null) {
            return;
        }
        String hash = realMessage.getRequestHash().toHex();
        if (this.processor.insertAndCheck(nodeId + hash)) {
            this.protocolService.getOtherCtx(chainId, nodeId, realMessage);
        }
    }
}

