/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.base.model.bo;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;
import io.nuls.crosschain.base.message.base.BaseMessage;
import java.io.IOException;

@ApiModel
public class AssetInfo
extends BaseMessage {
    @ApiModelProperty(description="assetID")
    private int assetId;
    @ApiModelProperty(description="Asset symbols")
    private String symbol;
    @ApiModelProperty(description="Asset Name")
    private String assetName;
    @ApiModelProperty(description="Is it available")
    private boolean usable;
    @ApiModelProperty(description="accuracy")
    private int decimalPlaces;

    public AssetInfo() {
    }

    public AssetInfo(int assetId, String symbol, String assetName, boolean usable, int decimalPlaces) {
        this.assetId = assetId;
        this.symbol = symbol;
        this.assetName = assetName;
        this.usable = usable;
        this.decimalPlaces = decimalPlaces;
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint16(this.assetId);
        stream.writeString(this.symbol);
        stream.writeString(this.assetName);
        stream.writeBoolean(this.usable);
        stream.writeUint16(this.decimalPlaces);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.assetId = byteBuffer.readUint16();
        this.symbol = byteBuffer.readString();
        this.assetName = byteBuffer.readString();
        this.usable = byteBuffer.readBoolean();
        this.decimalPlaces = byteBuffer.readUint16();
    }

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfUint16();
        size += SerializeUtils.sizeOfString((String)this.symbol);
        size += SerializeUtils.sizeOfString((String)this.assetName);
        size += SerializeUtils.sizeOfBoolean();
        return size += SerializeUtils.sizeOfUint16();
    }

    public int getAssetId() {
        return this.assetId;
    }

    public void setAssetId(int assetId) {
        this.assetId = assetId;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getAssetName() {
        return this.assetName;
    }

    public void setAssetName(String assetName) {
        this.assetName = assetName;
    }

    public boolean isUsable() {
        return this.usable;
    }

    public void setUsable(boolean usable) {
        this.usable = usable;
    }

    public int getDecimalPlaces() {
        return this.decimalPlaces;
    }

    public void setDecimalPlaces(int decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
    }
}

