/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.base.model.bo;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.basic.NulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.crosschain.base.message.base.BaseMessage;
import io.nuls.crosschain.base.model.bo.AssetInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@ApiModel
public class ChainInfo
extends BaseMessage {
    @ApiModelProperty(description="chainID")
    private int chainId;
    @ApiModelProperty(description="Chain Name")
    private String chainName;
    @ApiModelProperty(description="Minimum number of links")
    private int minAvailableNodeNum;
    @ApiModelProperty(description="Maximum number of signatures")
    private int maxSignatureCount;
    @ApiModelProperty(description="Signature Byzantine Ratio")
    private int signatureByzantineRatio;
    @ApiModelProperty(description="Chain account prefix")
    private String addressPrefix;
    @ApiModelProperty(description="Chain Asset List", type=@TypeDescriptor(value=List.class, collectionElement=AssetInfo.class))
    private List<AssetInfo> assetInfoList;
    @ApiModelProperty(description="Verifier List")
    private Set<String> verifierList;
    @ApiModelProperty(description="Registration time")
    private long registerTime;

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint16(this.chainId);
        stream.writeString(this.chainName);
        stream.writeUint16(this.minAvailableNodeNum);
        stream.writeUint16(this.maxSignatureCount);
        stream.writeUint16(this.signatureByzantineRatio);
        stream.writeString(this.addressPrefix);
        stream.writeUint32(this.registerTime);
        int count = this.assetInfoList == null || this.assetInfoList.size() == 0 ? 0 : this.assetInfoList.size();
        stream.writeVarInt(count);
        if (this.assetInfoList != null && this.assetInfoList.size() > 0) {
            for (AssetInfo assetInfo : this.assetInfoList) {
                stream.writeNulsData((BaseNulsData)assetInfo);
            }
        }
        int verifierCount = this.verifierList == null || this.verifierList.size() == 0 ? 0 : this.verifierList.size();
        stream.writeVarInt(verifierCount);
        if (this.verifierList != null && this.verifierList.size() > 0) {
            for (String verifier : this.verifierList) {
                stream.writeString(verifier);
            }
        }
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.chainId = byteBuffer.readUint16();
        this.chainName = byteBuffer.readString();
        this.minAvailableNodeNum = byteBuffer.readUint16();
        this.maxSignatureCount = byteBuffer.readUint16();
        this.signatureByzantineRatio = byteBuffer.readUint16();
        this.addressPrefix = byteBuffer.readString();
        this.registerTime = byteBuffer.readUint32();
        ArrayList<AssetInfo> assetInfoList = new ArrayList<AssetInfo>();
        int count = (int)byteBuffer.readVarInt();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                assetInfoList.add((AssetInfo)byteBuffer.readNulsData((BaseNulsData)new AssetInfo()));
            }
        }
        this.assetInfoList = assetInfoList;
        int verifierCount = (int)byteBuffer.readVarInt();
        HashSet<String> verifierList = new HashSet<String>();
        if (verifierCount > 0) {
            for (int i = 0; i < verifierCount; ++i) {
                verifierList.add(byteBuffer.readString());
            }
        }
        this.verifierList = verifierList;
    }

    public int size() {
        int size = SerializeUtils.sizeOfVarInt((Integer)(this.assetInfoList == null || this.assetInfoList.size() == 0 ? 0 : this.assetInfoList.size()));
        size += SerializeUtils.sizeOfUint16() * 4;
        size += SerializeUtils.sizeOfString((String)this.chainName);
        size += SerializeUtils.sizeOfString((String)this.addressPrefix);
        size += SerializeUtils.sizeOfUint32();
        if (this.assetInfoList != null && this.assetInfoList.size() > 0) {
            for (AssetInfo assetInfo : this.assetInfoList) {
                size += SerializeUtils.sizeOfNulsData((NulsData)assetInfo);
            }
        }
        size += SerializeUtils.sizeOfVarInt((Integer)(this.verifierList == null || this.verifierList.size() == 0 ? 0 : this.verifierList.size()));
        if (this.verifierList != null && !this.verifierList.isEmpty()) {
            for (String verifier : this.verifierList) {
                size += SerializeUtils.sizeOfString((String)verifier);
            }
        }
        return size;
    }

    public int getChainId() {
        return this.chainId;
    }

    public void setChainId(int chainId) {
        this.chainId = chainId;
    }

    public String getChainName() {
        return this.chainName;
    }

    public void setChainName(String chainName) {
        this.chainName = chainName;
    }

    public List<AssetInfo> getAssetInfoList() {
        return this.assetInfoList;
    }

    public void setAssetInfoList(List<AssetInfo> assetInfoList) {
        this.assetInfoList = assetInfoList;
    }

    public int getMinAvailableNodeNum() {
        return this.minAvailableNodeNum;
    }

    public void setMinAvailableNodeNum(int minAvailableNodeNum) {
        this.minAvailableNodeNum = minAvailableNodeNum;
    }

    public int getMaxSignatureCount() {
        return this.maxSignatureCount;
    }

    public void setMaxSignatureCount(int maxSignatureCount) {
        this.maxSignatureCount = maxSignatureCount;
    }

    public int getSignatureByzantineRatio() {
        return this.signatureByzantineRatio;
    }

    public void setSignatureByzantineRatio(int signatureByzantineRatio) {
        this.signatureByzantineRatio = signatureByzantineRatio;
    }

    public String getAddressPrefix() {
        return this.addressPrefix;
    }

    public void setAddressPrefix(String addressPrefix) {
        this.addressPrefix = addressPrefix;
    }

    public Set<String> getVerifierList() {
        return this.verifierList;
    }

    public void setVerifierList(Set<String> verifierList) {
        this.verifierList = verifierList;
    }

    public long getRegisterTime() {
        return this.registerTime;
    }

    public void setRegisterTime(long registerTime) {
        this.registerTime = registerTime;
    }

    public int getMinPassCount() {
        int minPassCount = this.getVerifierList().size() * this.getSignatureByzantineRatio() / 100;
        if (minPassCount == 0) {
            minPassCount = 1;
        }
        return minPassCount;
    }

    public int getMinPassCount(int count) {
        int minPassCount = count * this.getSignatureByzantineRatio() / 100;
        if (minPassCount == 0) {
            minPassCount = 1;
        }
        return minPassCount;
    }

    public boolean verifyAssetAvailability(int chainId, int assetId) {
        if (chainId != this.chainId) {
            return false;
        }
        for (AssetInfo assetInfo : this.assetInfoList) {
            if (assetInfo.getAssetId() != assetId || !assetInfo.isUsable()) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ChainInfo) {
            return this.chainId == ((ChainInfo)((Object)obj)).getChainId();
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.chainId;
        return result;
    }
}

