/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.base.model.bo.txdata;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.model.ByteUtils;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;

public class CrossTransferData
extends BaseNulsData {
    Integer sourceType;
    byte[] sourceHash;

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        if (this.sourceType == null) {
            stream.writeUint32(10L);
        } else {
            stream.writeUint32((long)this.sourceType.intValue());
        }
        stream.writeBytesWithLength(this.sourceHash);
    }

    public void parse(NulsByteBuffer buffer) throws NulsException {
        try {
            if (!buffer.isFinished()) {
                this.sourceType = buffer.readInt32();
            }
            if (!buffer.isFinished()) {
                this.sourceHash = buffer.readByLengthByte();
            }
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public int size() {
        int s = 0;
        s += SerializeUtils.sizeOfUint32();
        return s += SerializeUtils.sizeOfBytes((byte[])this.sourceHash);
    }

    public Integer getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public byte[] getSourceHash() {
        return this.sourceHash;
    }

    public void setSourceHash(byte[] sourceHash) {
        this.sourceHash = sourceHash;
    }

    public static void main(String[] args) throws NulsException, IOException {
        CrossTransferData crossTransferData = new CrossTransferData();
        byte[] byts = ByteUtils.intToBytes((int)26);
        crossTransferData.parse(byts, 0);
        Log.info((String)"hex:{}", (Object[])new Object[]{HexUtil.encode((byte[])crossTransferData.serialize())});
        Log.info((String)"{}", (Object[])new Object[]{crossTransferData.sourceType});
        crossTransferData = new CrossTransferData();
        crossTransferData.setSourceType(26);
        crossTransferData.setSourceHash(HexUtil.decode((String)"792dc5108df2f3ab3575cff3cd1f1cfd7137ecbd05a813b6c255260e38c4d36c"));
        byte[] hex = crossTransferData.serialize();
        crossTransferData = new CrossTransferData();
        crossTransferData.parse(hex, 0);
        Log.info((String)"{}", (Object[])new Object[]{crossTransferData.sourceType});
        if (crossTransferData.sourceHash != null) {
            Log.info((String)"sourceHash:{}", (Object[])new Object[]{HexUtil.encode((byte[])crossTransferData.sourceHash)});
        }
    }
}

