/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.base.model.bo.txdata;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class VerifierChangeData
extends BaseNulsData {
    private int chainId;
    private List<String> registerAgentList;
    private List<String> cancelAgentList;

    public VerifierChangeData() {
    }

    public VerifierChangeData(List<String> registerAgentList, List<String> cancelAgentList, int chainId) {
        this.chainId = chainId;
        this.registerAgentList = registerAgentList;
        this.cancelAgentList = cancelAgentList;
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint16(this.chainId);
        int registerCount = this.registerAgentList == null ? 0 : this.registerAgentList.size();
        stream.writeVarInt(registerCount);
        if (this.registerAgentList != null) {
            for (String registerAgent : this.registerAgentList) {
                stream.writeString(registerAgent);
            }
        }
        int cancelCount = this.cancelAgentList == null ? 0 : this.cancelAgentList.size();
        stream.writeVarInt(cancelCount);
        if (this.cancelAgentList != null) {
            for (String cancelAgent : this.cancelAgentList) {
                stream.writeString(cancelAgent);
            }
        }
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        int cancelCount;
        this.chainId = byteBuffer.readUint16();
        int registerCount = (int)byteBuffer.readVarInt();
        if (registerCount > 0) {
            ArrayList<String> registerAgentList = new ArrayList<String>();
            for (int i = 0; i < registerCount; ++i) {
                registerAgentList.add(byteBuffer.readString());
            }
            this.registerAgentList = registerAgentList;
        }
        if ((cancelCount = (int)byteBuffer.readVarInt()) > 0) {
            ArrayList<String> cancelAgentList = new ArrayList<String>();
            for (int i = 0; i < cancelCount; ++i) {
                cancelAgentList.add(byteBuffer.readString());
            }
            this.cancelAgentList = cancelAgentList;
        }
    }

    public int size() {
        int size = SerializeUtils.sizeOfUint16();
        size += SerializeUtils.sizeOfVarInt((Integer)(this.registerAgentList == null ? 0 : this.registerAgentList.size()));
        if (this.registerAgentList != null) {
            for (String registerAgent : this.registerAgentList) {
                size += SerializeUtils.sizeOfString((String)registerAgent);
            }
        }
        size += SerializeUtils.sizeOfVarInt((Integer)(this.cancelAgentList == null ? 0 : this.cancelAgentList.size()));
        if (this.cancelAgentList != null) {
            for (String cancelAgent : this.cancelAgentList) {
                size += SerializeUtils.sizeOfString((String)cancelAgent);
            }
        }
        return size;
    }

    public List<String> getRegisterAgentList() {
        return this.registerAgentList;
    }

    public void setRegisterAgentList(List<String> registerAgentList) {
        this.registerAgentList = registerAgentList;
    }

    public List<String> getCancelAgentList() {
        return this.cancelAgentList;
    }

    public void setCancelAgentList(List<String> cancelAgentList) {
        this.cancelAgentList = cancelAgentList;
    }

    public int getChainId() {
        return this.chainId;
    }

    public void setChainId(int chainId) {
        this.chainId = chainId;
    }
}

