/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.base.model.bo.txdata;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class VerifierInitData
extends BaseNulsData {
    private int registerChainId;
    private List<String> verifierList;

    public VerifierInitData() {
    }

    public VerifierInitData(int registerChainId, List<String> verifierList) {
        this.registerChainId = registerChainId;
        this.verifierList = verifierList;
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint16(this.registerChainId);
        int registerCount = this.verifierList == null ? 0 : this.verifierList.size();
        stream.writeVarInt(registerCount);
        if (this.verifierList != null) {
            for (String registerAgent : this.verifierList) {
                stream.writeString(registerAgent);
            }
        }
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.registerChainId = byteBuffer.readUint16();
        int verifierCount = (int)byteBuffer.readVarInt();
        if (verifierCount > 0) {
            ArrayList<String> verifierList = new ArrayList<String>();
            for (int i = 0; i < verifierCount; ++i) {
                verifierList.add(byteBuffer.readString());
            }
            this.verifierList = verifierList;
        }
    }

    public int size() {
        int size = SerializeUtils.sizeOfUint16();
        size += SerializeUtils.sizeOfVarInt((Integer)(this.verifierList == null ? 0 : this.verifierList.size()));
        if (this.verifierList != null) {
            for (String verifier : this.verifierList) {
                size += SerializeUtils.sizeOfString((String)verifier);
            }
        }
        return size;
    }

    public int getRegisterChainId() {
        return this.registerChainId;
    }

    public void setRegisterChainId(int registerChainId) {
        this.registerChainId = registerChainId;
    }

    public List<String> getVerifierList() {
        return this.verifierList;
    }

    public void setVerifierList(List<String> verifierList) {
        this.verifierList = verifierList;
    }
}

