/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.message;

import io.nuls.base.RPCUtil;
import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.transaction.TransferService;
import io.nuls.base.api.provider.transaction.facade.GetConfirmedTxByHashReq;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.MessageProcessor;
import io.nuls.core.constant.TxStatusEnum;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.log.Log;
import io.nuls.crosschain.base.message.CrossTxRehandleMessage;
import io.nuls.crosschain.base.utils.HashSetDuplicateProcessor;
import io.nuls.crosschain.model.bo.Chain;
import io.nuls.crosschain.model.po.CtxStatusPO;
import io.nuls.crosschain.rpc.call.BlockCall;
import io.nuls.crosschain.srorage.CtxStatusService;
import io.nuls.crosschain.utils.manager.ChainManager;
import io.nuls.crosschain.utils.thread.CrossTxHandler;
import java.io.IOException;

@Component(value="CrossTxRehandleMsgHandlerV1")
public class CrossTxRehandleMsgHandler
implements MessageProcessor {
    private static HashSetDuplicateProcessor processorOfTx = new HashSetDuplicateProcessor(1000);
    @Autowired
    private CtxStatusService ctxStatusService;
    @Autowired
    private ChainManager chainManager;
    TransferService transferService = (TransferService)ServiceManager.get(TransferService.class);

    public String getCmd() {
        return "ctxRehandle";
    }

    public void process(int chainId, String nodeId, String messageStr) {
        CrossTxRehandleMessage message = (CrossTxRehandleMessage)((Object)RPCUtil.getInstanceRpcStr((String)messageStr, CrossTxRehandleMessage.class));
        this.process(chainId, message);
    }

    public void process(int chainId, CrossTxRehandleMessage message) {
        String messageHash;
        try {
            messageHash = HexUtil.encode((byte[])message.serialize());
        }
        catch (IOException e) {
            Log.error((String)"Parsing messagesCrossTxRehandleMessageMessage exception occurred");
            return;
        }
        if (processorOfTx.insertAndCheck(messageHash)) {
            Chain chain = this.chainManager.getChainMap().get(chainId);
            String ctxHash = message.getCtxHash().toHex();
            Result tx = this.transferService.getConfirmedTxByHash(new GetConfirmedTxByHashReq(ctxHash));
            if (tx.isFailed()) {
                chain.getLogger().error("handle\u3010Reprocess cross chain transactions with Byzantine signatures\u3011Failed,ctx hash : [{}] Not a valid transactionhash", new Object[]{ctxHash});
                return;
            }
            Transaction transaction = (Transaction)tx.getData();
            if (transaction.getType() != 10 && transaction.getType() != 26) {
                chain.getLogger().error("handle\u3010Reprocess cross chain transactions with Byzantine signatures\u3011Failed,ctx hash : [{}] Not a cross chain transaction", new Object[]{ctxHash});
                return;
            }
            CtxStatusPO ctxStatusPO = this.ctxStatusService.get(message.getCtxHash(), chainId);
            if (ctxStatusPO != null) {
                if (ctxStatusPO.getStatus() == TxStatusEnum.CONFIRMED.getStatus()) {
                    chain.getLogger().info("The cross chain transfer transaction has been processed before and will be reprocessed\uff1a{}", new Object[]{message.getCtxHash().toHex()});
                    ctxStatusPO.setStatus(TxStatusEnum.UNCONFIRM.getStatus());
                    this.ctxStatusService.save(message.getCtxHash(), ctxStatusPO, chainId);
                }
            } else {
                chain.getLogger().info("The cross chain transfer transaction was not stored in the pending list beforectx_status_poStore this transaction in the middle\uff1a{}", new Object[]{message.getCtxHash().toHex()});
                ctxStatusPO = new CtxStatusPO(transaction, TxStatusEnum.UNCONFIRM.getStatus());
                this.ctxStatusService.save(message.getCtxHash(), ctxStatusPO, chainId);
            }
            chain.getLogger().debug("rightctx:[{}]Perform Byzantine signature verification again", new Object[]{ctxHash});
            int syncStatus = BlockCall.getBlockStatus(chain);
            chain.getCrossTxThreadPool().execute(new CrossTxHandler(chain, (Transaction)tx.getData(), syncStatus));
        }
    }
}

