/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.model.po;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LocalVerifierPO
extends BaseNulsData {
    List<String> verifierList;

    public LocalVerifierPO() {
    }

    public LocalVerifierPO(List<String> verifierList) {
        this.verifierList = verifierList;
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        int verifierCount = this.verifierList == null ? 0 : this.verifierList.size();
        stream.writeVarInt(verifierCount);
        if (null != this.verifierList) {
            for (String verifier : this.verifierList) {
                stream.writeString(verifier);
            }
        }
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        int verifierCount = (int)byteBuffer.readVarInt();
        if (0 < verifierCount) {
            ArrayList<String> verifierList = new ArrayList<String>();
            for (int i = 0; i < verifierCount; ++i) {
                verifierList.add(byteBuffer.readString());
            }
            this.verifierList = verifierList;
        }
    }

    public int size() {
        int size = SerializeUtils.sizeOfVarInt((Integer)(this.verifierList == null ? 0 : this.verifierList.size()));
        if (null != this.verifierList) {
            for (String verifier : this.verifierList) {
                size += SerializeUtils.sizeOfString((String)verifier);
            }
        }
        return size;
    }

    public List<String> getVerifierList() {
        return this.verifierList;
    }

    public void setVerifierList(List<String> verifierList) {
        this.verifierList = verifierList;
    }
}

