/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.rpc.call;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.BigIntegerUtils;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import io.nuls.crosschain.base.model.bo.Circulation;
import io.nuls.crosschain.model.bo.Chain;
import io.nuls.crosschain.rpc.call.CommonCall;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LedgerCall {
    public static byte[] getNonce(Chain chain, String address, int assetChainId, int assetId) throws NulsException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("version", "1.0");
            params.put("chainId", chain.getChainId());
            params.put("address", address);
            params.put("assetChainId", assetChainId);
            params.put("assetId", assetId);
            HashMap result = (HashMap)CommonCall.request(ModuleE.LG.abbr, "getNonce", params);
            String nonce = (String)result.get("nonce");
            return RPCUtil.decode((String)nonce);
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static BigInteger getBalanceNonce(Chain chain, byte[] address, int assetChainId, int assetId) throws NulsException {
        try {
            String addressString = AddressTool.getStringAddressByBytes((byte[])address);
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("version", "1.0");
            params.put("chainId", chain.getChainId());
            params.put("assetChainId", assetChainId);
            params.put("assetId", assetId);
            params.put("address", addressString);
            Map result = (Map)CommonCall.request(ModuleE.LG.abbr, "getBalanceNonce", params);
            Object available = result.get("available");
            return BigIntegerUtils.stringToBigInteger((String)String.valueOf(available));
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static Map<String, Object> getBalanceAndNonce(Chain chain, String address, int assetChainId, int assetId) throws NulsException {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("version", "1.0");
        params.put("chainId", chain.getChainId());
        params.put("assetChainId", assetChainId);
        params.put("assetId", assetId);
        params.put("address", address);
        try {
            Response callResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.LG.abbr, (String)"getBalanceNonce", params);
            if (!callResp.isSuccess()) {
                return null;
            }
            return (HashMap)((HashMap)callResp.getResponseData()).get("getBalanceNonce");
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static BigInteger getBalance(Chain chain, byte[] address, int assetChainId, int assetId) throws NulsException {
        try {
            String addressString = AddressTool.getStringAddressByBytes((byte[])address);
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("version", "1.0");
            params.put("chainId", chain.getChainId());
            params.put("assetChainId", assetChainId);
            params.put("assetId", assetId);
            params.put("address", addressString);
            Map result = (Map)CommonCall.request(ModuleE.LG.abbr, "getBalance", params);
            Object available = result.get("available");
            return BigIntegerUtils.stringToBigInteger((String)String.valueOf(available));
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }

    public static List<Circulation> getAssetsById(Chain chain, String assetIds) throws NulsException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("version", "1.0");
            params.put("chainId", chain.getChainId());
            params.put("assetIds", assetIds);
            Map result = (Map)CommonCall.request(ModuleE.LG.abbr, "getAssetsById", params);
            ArrayList<Circulation> circulationList = new ArrayList<Circulation>();
            List assertList = (List)result.get("assets");
            if (assertList != null && assertList.size() > 0) {
                for (Map assertInfoMap : assertList) {
                    Circulation circulation = (Circulation)((Object)JSONUtils.map2pojo((Map)assertInfoMap, Circulation.class));
                    circulationList.add(circulation);
                }
            }
            return circulationList;
        }
        catch (Exception e) {
            throw new NulsException((Throwable)e);
        }
    }
}

