/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.servive.impl;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.BlockExtendsData;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.common.NulsCoresConfig;
import io.nuls.contract.util.Log;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.crosschain.constant.NulsCrossChainErrorCode;
import io.nuls.crosschain.model.bo.BroadFailFlag;
import io.nuls.crosschain.model.bo.Chain;
import io.nuls.crosschain.model.po.SendCtxHashPO;
import io.nuls.crosschain.rpc.call.ConsensusCall;
import io.nuls.crosschain.servive.BlockService;
import io.nuls.crosschain.srorage.ConvertCtxService;
import io.nuls.crosschain.srorage.CtxStatusService;
import io.nuls.crosschain.srorage.SendHeightService;
import io.nuls.crosschain.srorage.SendedHeightService;
import io.nuls.crosschain.srorage.VerifierChangeBroadFailedService;
import io.nuls.crosschain.utils.BroadCtxUtil;
import io.nuls.crosschain.utils.TxUtil;
import io.nuls.crosschain.utils.manager.ChainManager;
import io.nuls.crosschain.utils.thread.VerifierChangeTxHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

@Component
public class BlockServiceImpl
implements BlockService {
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private SendHeightService sendHeightService;
    @Autowired
    private SendedHeightService sendedHeightService;
    @Autowired
    private NulsCoresConfig config;
    @Autowired
    private ConvertCtxService convertCtxService;
    @Autowired
    private CtxStatusService ctxStatusService;
    @Autowired
    private VerifierChangeBroadFailedService verifierChangeBroadFailedService;

    @Override
    public Result syncStatusUpdate(Map<String, Object> params) {
        if (params.get("chainId") == null || params.get("status") == null) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)NulsCrossChainErrorCode.CHAIN_NOT_EXIST);
        }
        int syncStatus = (Integer)params.get("status");
        chain.setSyncStatus(syncStatus);
        chain.getLogger().info("Node synchronization status change,syncStatus:{}", new Object[]{syncStatus});
        return Result.getSuccess((ErrorCode)CommonCodeConstanst.SUCCESS);
    }

    @Override
    public Result newBlockHeight(Map<String, Object> params) {
        Result result = this.paramValid(params);
        if (result.isFailed()) {
            Log.error(result.getMsg());
            return result;
        }
        int chainId = (Integer)params.get("chainId");
        Chain chain = this.chainManager.getChainMap().get(chainId);
        long height = Long.valueOf(params.get("height").toString());
        chain.getLogger().debug("Received block height update information, the latest block height is\uff1a{}", new Object[]{height});
        Map<Long, SendCtxHashPO> sendHeightMap = this.sendHeightService.getList(chainId);
        if (sendHeightMap != null && sendHeightMap.size() > 0) {
            TreeSet<Long> sortSet = new TreeSet<Long>(sendHeightMap.keySet());
            HashMap<Integer, Byte> crossStatusMap = new HashMap<Integer, Byte>(16);
            HashMap<Integer, BroadFailFlag> broadFailMap = new HashMap<Integer, BroadFailFlag>(16);
            Iterator iterator = sortSet.iterator();
            while (iterator.hasNext()) {
                long cacheHeight = (Long)iterator.next();
                if (height < cacheHeight || height - cacheHeight >= 2000L) continue;
                chain.getLogger().debug("The height of the broadcast block is{}Cross chain transactions to other chains", new Object[]{cacheHeight});
                SendCtxHashPO po = sendHeightMap.get(cacheHeight);
                ArrayList<NulsHash> broadSuccessCtxHash = new ArrayList<NulsHash>();
                ArrayList<NulsHash> broadFailCtxHash = new ArrayList<NulsHash>();
                for (NulsHash ctxHash : po.getHashList()) {
                    if (BroadCtxUtil.broadCtxHash(chain, ctxHash, cacheHeight, crossStatusMap, broadFailMap)) {
                        broadSuccessCtxHash.add(ctxHash);
                        continue;
                    }
                    broadFailCtxHash.add(ctxHash);
                }
                if (broadSuccessCtxHash.size() > 0) {
                    SendCtxHashPO sendedPo = this.sendedHeightService.get(cacheHeight, chainId);
                    if (sendedPo != null) {
                        sendedPo.getHashList().addAll(broadSuccessCtxHash);
                    } else {
                        sendedPo = new SendCtxHashPO(broadSuccessCtxHash);
                    }
                    if (!this.sendedHeightService.save(cacheHeight, sendedPo, chainId)) continue;
                }
                if (broadFailCtxHash.size() > 0) {
                    int ONE_DAY_HEIGHT = 8640;
                    if (height - cacheHeight >= (long)ONE_DAY_HEIGHT) continue;
                    po.setHashList(broadFailCtxHash);
                    this.sendHeightService.save(cacheHeight, po, chainId);
                    chain.getLogger().error("The block height is {} Cross chain transaction broadcast failed for {}", new Object[]{cacheHeight, broadFailCtxHash});
                    continue;
                }
                this.sendHeightService.delete(cacheHeight, chainId);
                chain.getLogger().info("The block height is {} Cross chain transaction broadcast successful", new Object[]{cacheHeight});
            }
        }
        chain.getLogger().info("Block height update message processing completed,Height:{}\n\n", new Object[]{height});
        return Result.getSuccess((ErrorCode)CommonCodeConstanst.SUCCESS);
    }

    private Result paramValid(Map<String, Object> params) {
        if (params.get("chainId") == null || params.get("height") == null || params.get("blockHeader") == null) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        int download = (Integer)params.get("download");
        if (chainId <= 0) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)NulsCrossChainErrorCode.CHAIN_NOT_EXIST);
        }
        try {
            BlockHeader blockHeader = new BlockHeader();
            String headerHex = (String)params.get("blockHeader");
            blockHeader.parse(RPCUtil.decode((String)headerHex), 0);
            if (!this.chainManager.isCrossNetUseAble()) {
                this.chainManager.getChainHeaderMap().put(chainId, blockHeader);
                chain.getLogger().info("Waiting for consensus network networking completion");
                return Result.getSuccess((ErrorCode)CommonCodeConstanst.SUCCESS);
            }
            if (this.config.isMainNet() && this.chainManager.getRegisteredCrossChainList().size() <= 1) {
                chain.getLogger().info("There is currently no registration chain");
                this.chainManager.getChainHeaderMap().put(chainId, blockHeader);
                return Result.getSuccess((ErrorCode)CommonCodeConstanst.SUCCESS);
            }
            if (download == 1 && chain.getVerifierList() != null && !chain.getVerifierList().isEmpty()) {
                Map<String, List<String>> agentChangeMap;
                BlockHeader localHeader = this.chainManager.getChainHeaderMap().get(chainId);
                if (localHeader != null) {
                    BlockExtendsData blockExtendsData = blockHeader.getExtendsData();
                    BlockExtendsData localExtendsData = localHeader.getExtendsData();
                    if (blockExtendsData.getRoundIndex() == localExtendsData.getRoundIndex()) {
                        this.chainManager.getChainHeaderMap().put(chainId, blockHeader);
                        chain.getLogger().info("ChainHeaderMap put : {} -- {}", new Object[]{chainId, blockHeader.getHeight()});
                        return Result.getSuccess((ErrorCode)CommonCodeConstanst.SUCCESS);
                    }
                    agentChangeMap = ConsensusCall.getAgentChangeInfo(chain, localHeader.getExtend(), blockHeader.getExtend());
                } else {
                    agentChangeMap = ConsensusCall.getAgentChangeInfo(chain, null, blockHeader.getExtend());
                }
                if (agentChangeMap != null) {
                    boolean verifierChange;
                    List<String> registerAgentList = agentChangeMap.get("registerAgentList");
                    List<String> cancelAgentList = agentChangeMap.get("cancelAgentList");
                    if (localHeader == null && registerAgentList != null) {
                        registerAgentList.removeAll(chain.getVerifierList());
                    }
                    boolean bl = verifierChange = registerAgentList != null && !registerAgentList.isEmpty() || cancelAgentList != null && !cancelAgentList.isEmpty();
                    if (verifierChange) {
                        chain.getLogger().info("There is a change in verifier, create a transaction with a change in verifier, and the latest round shares a block address with the previous round\uff1a{},New Verifier List\uff1a{},Reduced list of validators\uff1a{}", new Object[]{chain.getVerifierList().toString(), registerAgentList, cancelAgentList});
                        Transaction verifierChangeTx = TxUtil.createVerifierChangeTx(registerAgentList, cancelAgentList, blockHeader.getExtendsData().getRoundStartTime(), chainId);
                        chain.getCrossTxThreadPool().execute(new VerifierChangeTxHandler(chain, verifierChangeTx, blockHeader.getHeight()));
                    }
                }
            }
            this.chainManager.getChainHeaderMap().put(chainId, blockHeader);
            chain.getLogger().info("ChainHeaderMap put : {} -- {}", new Object[]{chainId, blockHeader.getHeight()});
        }
        catch (Exception e) {
            chain.getLogger().error(e);
            return Result.getFailed((ErrorCode)CommonCodeConstanst.DATA_PARSE_ERROR);
        }
        return Result.getSuccess((ErrorCode)CommonCodeConstanst.SUCCESS);
    }
}

