/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.servive.impl;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.TransactionFeeCalculator;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.Transaction;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.model.BigIntegerUtils;
import io.nuls.core.model.ByteUtils;
import io.nuls.core.parse.JSONUtils;
import io.nuls.crosschain.base.message.CirculationMessage;
import io.nuls.crosschain.base.message.GetCirculationMessage;
import io.nuls.crosschain.base.model.bo.AssetInfo;
import io.nuls.crosschain.base.model.bo.ChainInfo;
import io.nuls.crosschain.base.model.bo.txdata.RegisteredChainMessage;
import io.nuls.crosschain.base.utils.enumeration.ChainInfoChangeType;
import io.nuls.crosschain.constant.NulsCrossChainConstant;
import io.nuls.crosschain.constant.NulsCrossChainErrorCode;
import io.nuls.crosschain.model.bo.Chain;
import io.nuls.crosschain.rpc.call.BlockCall;
import io.nuls.crosschain.rpc.call.ChainManagerCall;
import io.nuls.crosschain.rpc.call.ConsensusCall;
import io.nuls.crosschain.rpc.call.NetWorkCall;
import io.nuls.crosschain.servive.MainNetService;
import io.nuls.crosschain.srorage.CtxStatusService;
import io.nuls.crosschain.srorage.RegisteredCrossChainService;
import io.nuls.crosschain.utils.LoggerUtil;
import io.nuls.crosschain.utils.TxUtil;
import io.nuls.crosschain.utils.manager.ChainManager;
import io.nuls.crosschain.utils.manager.LocalVerifierManager;
import io.nuls.crosschain.utils.thread.CrossTxHandler;
import io.nuls.crosschain.utils.validator.CrossTxValidator;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class MainNetServiceImpl
implements MainNetService {
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private NulsCoresConfig nulsCrossChainConfig;
    @Autowired
    private RegisteredCrossChainService registeredCrossChainService;
    @Autowired
    private CtxStatusService ctxStatusService;
    @Autowired
    private CrossTxValidator txValidator;

    @Override
    public Result registerCrossChain(Map<String, Object> params) {
        if (params == null) {
            LoggerUtil.commonLog.error("Parameter error");
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR);
        }
        ChainInfo chainInfo = (ChainInfo)((Object)JSONUtils.map2pojo(params, ChainInfo.class));
        Chain chain = this.chainManager.getChainMap().get(this.nulsCrossChainConfig.getMainChainId());
        RegisteredChainMessage registeredChainMessage = this.registeredCrossChainService.get();
        if (registeredChainMessage == null || registeredChainMessage.getChainInfoList().isEmpty()) {
            registeredChainMessage = new RegisteredChainMessage();
            ArrayList<ChainInfo> chainInfoList = new ArrayList<ChainInfo>();
            registeredChainMessage.setChainInfoList(chainInfoList);
        }
        registeredChainMessage.addChainInfo(chainInfo);
        this.registeredCrossChainService.save(registeredChainMessage);
        this.chainManager.setRegisteredCrossChainList(registeredChainMessage.getChainInfoList());
        if (chain.getVerifierList() == null || chain.getVerifierList().isEmpty()) {
            chain.getLogger().info("The first time the primary network has chain registration, cross chain initialization and local verification list");
            boolean result = LocalVerifierManager.initLocalVerifier(chain, (List)ConsensusCall.getPackerInfo(chain).get("packAddressList"));
            if (!result) {
                return Result.getFailed((ErrorCode)CommonCodeConstanst.DB_SAVE_ERROR);
            }
        }
        chain.getLogger().info("There is a new cross chain registration,chainID:{},Initial Verifier List\uff1a{}", new Object[]{chainInfo.getChainId(), chainInfo.getVerifierList().toString()});
        try {
            int syncStatus = BlockCall.getBlockStatus(chain);
            chain.getCrossTxThreadPool().execute(new CrossTxHandler(chain, TxUtil.createVerifierInitTx(chain.getVerifierList(), chainInfo.getRegisterTime(), chainInfo.getChainId()), syncStatus));
            if (registeredChainMessage.haveOtherChain(chainInfo.getChainId(), chain.getChainId())) {
                chain.getLogger().info("Broadcast newly registered chain information to already registered chains");
                chain.getCrossTxThreadPool().execute(new CrossTxHandler(chain, TxUtil.createCrossChainChangeTx(chainInfo, chainInfo.getRegisterTime(), chainInfo.getChainId(), ChainInfoChangeType.NEW_REGISTER_CHAIN.getType()), syncStatus));
            }
        }
        catch (IOException e) {
            chain.getLogger().error((Exception)e);
            return Result.getFailed((ErrorCode)CommonCodeConstanst.DATA_PARSE_ERROR);
        }
        return Result.getSuccess((ErrorCode)CommonCodeConstanst.SUCCESS);
    }

    @Override
    public Result registerAssert(Map<String, Object> params) {
        if (params == null) {
            LoggerUtil.commonLog.error("Parameter error");
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(this.nulsCrossChainConfig.getMainChainId());
        int chainId = (Integer)params.get("chainId");
        int assetId = (Integer)params.get("assetId");
        String symbol = (String)params.get("symbol");
        String assetName = (String)params.get("assetName");
        boolean usable = (Boolean)params.get("usable");
        int decimalPlaces = (Integer)params.get("decimalPlaces");
        long time = ((Integer)params.get("time")).intValue();
        AssetInfo assetInfo = new AssetInfo(assetId, symbol, assetName, usable, decimalPlaces);
        this.chainManager.getChainInfo(chainId).getAssetInfoList().add(assetInfo);
        ChainInfo chainInfo = this.chainManager.getChainInfo(chainId);
        RegisteredChainMessage registeredChainMessage = this.registeredCrossChainService.get();
        registeredChainMessage.setChainInfoList(this.chainManager.getRegisteredCrossChainList());
        this.registeredCrossChainService.save(registeredChainMessage);
        try {
            int syncStatus = BlockCall.getBlockStatus(chain);
            chain.getLogger().info("New cross chain asset registration,chainId:{},assetId:{}", new Object[]{chainId, assetId});
            chain.getCrossTxThreadPool().execute(new CrossTxHandler(chain, TxUtil.createCrossChainChangeTx(chainInfo, time, chainInfo.getChainId(), ChainInfoChangeType.REGISTERED_CHAIN_CHANGE.getType()), syncStatus));
        }
        catch (IOException e) {
            chain.getLogger().error((Exception)e);
            return Result.getFailed((ErrorCode)CommonCodeConstanst.DATA_PARSE_ERROR);
        }
        return Result.getSuccess((ErrorCode)CommonCodeConstanst.SUCCESS);
    }

    @Override
    public Result cancelCrossChain(Map<String, Object> params) {
        if (params == null || params.get("chainId") == null || params.get("assetId") == null) {
            LoggerUtil.commonLog.error("Parameter error");
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        int assetId = (Integer)params.get("assetId");
        long time = ((Integer)params.get("time")).intValue();
        RegisteredChainMessage registeredChainMessage = this.registeredCrossChainService.get();
        Chain chain = this.chainManager.getChainMap().get(this.nulsCrossChainConfig.getMainChainId());
        int syncStatus = BlockCall.getBlockStatus(chain);
        boolean chainInvalid = true;
        ChainInfo realChainInfo = null;
        chain.getLogger().info("Cross chain asset deregistration,chainId:{},assetId:{}", new Object[]{chainId, assetId});
        if (assetId == 0) {
            registeredChainMessage.getChainInfoList().removeIf(chainInfo -> chainInfo.getChainId() == chainId);
        } else {
            for (ChainInfo chainInfo2 : registeredChainMessage.getChainInfoList()) {
                if (chainInfo2.getChainId() != chainId) continue;
                realChainInfo = chainInfo2;
                for (AssetInfo assetInfo : chainInfo2.getAssetInfoList()) {
                    if (assetInfo.getAssetId() == assetId) {
                        assetInfo.setUsable(false);
                    }
                    if (!assetInfo.isUsable()) continue;
                    chainInvalid = false;
                }
            }
            if (chainInvalid) {
                registeredChainMessage.getChainInfoList().removeIf(chainInfo -> chainInfo.getChainId() == chainId);
            }
        }
        try {
            if (chainInvalid) {
                chain.getLogger().info("Unregister chain,chainId:{}", new Object[]{chainId});
                chain.getCrossTxThreadPool().execute(new CrossTxHandler(chain, TxUtil.createCrossChainChangeTx(time, chainId, ChainInfoChangeType.REGISTERED_CHAIN_CHANGE.getType()), syncStatus));
            } else {
                chain.getCrossTxThreadPool().execute(new CrossTxHandler(chain, TxUtil.createCrossChainChangeTx(realChainInfo, time, chainId, ChainInfoChangeType.REGISTERED_CHAIN_CHANGE.getType()), syncStatus));
            }
        }
        catch (IOException e) {
            chain.getLogger().error((Exception)e);
            return Result.getFailed((ErrorCode)CommonCodeConstanst.DATA_PARSE_ERROR);
        }
        this.registeredCrossChainService.save(registeredChainMessage);
        this.chainManager.setRegisteredCrossChainList(registeredChainMessage.getChainInfoList());
        return Result.getSuccess((ErrorCode)CommonCodeConstanst.SUCCESS);
    }

    @Override
    public Result crossChainRegisterChange(Map<String, Object> params) {
        if (params == null || params.get("chainId") == null) {
            LoggerUtil.commonLog.error("Parameter error");
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR);
        }
        if (!this.nulsCrossChainConfig.isMainNet()) {
            LoggerUtil.commonLog.error("This chain is not the main network");
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        if (chainId != this.nulsCrossChainConfig.getMainChainId()) {
            LoggerUtil.commonLog.error("This chain is not the main network");
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR);
        }
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            LoggerUtil.commonLog.error("Chain does not exist");
            return Result.getFailed((ErrorCode)NulsCrossChainErrorCode.CHAIN_NOT_EXIST);
        }
        try {
            this.chainManager.setRegisteredCrossChainList(ChainManagerCall.getRegisteredChainInfo(this.chainManager).getChainInfoList());
        }
        catch (Exception e) {
            chain.getLogger().error("Cross chain registration information update failed");
            chain.getLogger().error(e);
        }
        return Result.getSuccess((ErrorCode)CommonCodeConstanst.SUCCESS);
    }

    @Override
    public void receiveCirculation(int chainId, String nodeId, CirculationMessage messageBody) {
        Chain chain = this.chainManager.getChainMap().get(this.nulsCrossChainConfig.getMainChainId());
        chain.getLogger().info("Received Friend Chain:{}node:{}The latest asset circulation information of the chain sent by the asset\n\n", new Object[]{chainId, nodeId});
        try {
            ChainManagerCall.sendCirculation(chainId, messageBody);
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
        }
    }

    @Override
    public Result getFriendChainCirculation(Map<String, Object> params) {
        if (params == null || params.get("chainId") == null || params.get("assetIds") == null) {
            return Result.getFailed((ErrorCode)CommonCodeConstanst.PARAMETER_ERROR);
        }
        int chainId = (Integer)params.get("chainId");
        GetCirculationMessage getCirculationMessage = new GetCirculationMessage();
        getCirculationMessage.setAssetIds((String)params.get("assetIds"));
        NetWorkCall.broadcast(chainId, getCirculationMessage, "getCirculat", true);
        return Result.getSuccess((ErrorCode)CommonCodeConstanst.SUCCESS);
    }

    @Override
    public Result tokenOutCrossChain(Map<String, Object> params) {
        int chainId = Integer.valueOf(params.get("chainId").toString());
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return Result.getFailed((ErrorCode)NulsCrossChainErrorCode.CHAIN_NOT_EXIST);
        }
        if (!this.chainManager.isCrossNetUseAble()) {
            chain.getLogger().info("Cross chain network networking exception\uff01");
            return Result.getFailed((ErrorCode)NulsCrossChainErrorCode.CROSS_CHAIN_NETWORK_UNAVAILABLE);
        }
        int assetId = Integer.valueOf(params.get("assetId").toString());
        String fromAddress = (String)params.get("from");
        String toAddress = (String)params.get("to");
        BigInteger amount = new BigInteger((String)params.get("value"));
        String contractAddress = (String)params.get("contractAddress");
        String contractToken = (String)params.get("contractNonce");
        String contractBalance = (String)params.get("contractBalance");
        long blockTime = Long.valueOf(params.get("blockTime").toString());
        Transaction tx = new Transaction(26);
        tx.setTime(blockTime);
        tx.setTxData(ByteUtils.intToBytes((int)26));
        CoinData coinData = new CoinData();
        ArrayList<CoinFrom> coinFromList = new ArrayList<CoinFrom>();
        CoinFrom coinFrom = new CoinFrom(AddressTool.getAddress((String)fromAddress), chainId, assetId, amount, NulsCrossChainConstant.CROSS_TOKEN_NONCE, 0);
        coinFromList.add(coinFrom);
        ArrayList<CoinTo> coinToList = new ArrayList<CoinTo>();
        CoinTo coinTo = new CoinTo(AddressTool.getAddress((String)toAddress), chainId, assetId, amount);
        coinToList.add(coinTo);
        coinData.setFrom(coinFromList);
        coinData.setTo(coinToList);
        HashMap<String, String> result = new HashMap<String, String>(2);
        try {
            int txSize = tx.size();
            txSize += 110;
            BigInteger targetFee = TransactionFeeCalculator.getCrossTxFee((int)(txSize += coinData.size()));
            CoinFrom feeFrom = new CoinFrom(AddressTool.getAddress((String)contractAddress), this.nulsCrossChainConfig.getMainChainId(), this.nulsCrossChainConfig.getMainAssetId(), targetFee, HexUtil.decode((String)contractToken), 0);
            targetFee = TransactionFeeCalculator.getCrossTxFee((int)(txSize += feeFrom.size()));
            feeFrom.setAmount(targetFee);
            BigInteger available = new BigInteger(contractBalance);
            if (BigIntegerUtils.isLessThan((BigInteger)available, (BigInteger)targetFee)) {
                chain.getLogger().warn("Insufficient handling fees");
                return Result.getFailed((ErrorCode)NulsCrossChainErrorCode.INSUFFICIENT_FEE);
            }
            coinData.addFrom(feeFrom);
            tx.setCoinData(coinData.serialize());
            if (!this.txValidator.validateTx(chain, tx, null)) {
                chain.getLogger().error("Transaction validation failed");
                return Result.getFailed((ErrorCode)NulsCrossChainErrorCode.COINDATA_VERIFY_FAIL);
            }
            result.put("txHash", tx.getHash().toHex());
            result.put("tx", RPCUtil.encode((byte[])tx.serialize()));
            return Result.getSuccess((ErrorCode)CommonCodeConstanst.SUCCESS).setData(result);
        }
        catch (IOException e) {
            Log.error((Throwable)e);
            return Result.getFailed((ErrorCode)CommonCodeConstanst.SERIALIZE_ERROR);
        }
        catch (NulsException e) {
            Log.error((Throwable)e);
            return Result.getFailed((ErrorCode)e.getErrorCode());
        }
    }
}

