/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.servive.impl;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.base.signture.TransactionSignature;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.constant.TxStatusEnum;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.crosschain.base.message.BroadCtxHashMessage;
import io.nuls.crosschain.base.message.BroadCtxSignMessage;
import io.nuls.crosschain.base.message.CirculationMessage;
import io.nuls.crosschain.base.message.CtxFullSignMessage;
import io.nuls.crosschain.base.message.CtxStateMessage;
import io.nuls.crosschain.base.message.GetCirculationMessage;
import io.nuls.crosschain.base.message.GetCtxStateMessage;
import io.nuls.crosschain.base.message.GetOtherCtxMessage;
import io.nuls.crosschain.base.message.NewOtherCtxMessage;
import io.nuls.crosschain.base.model.bo.Circulation;
import io.nuls.crosschain.base.service.ProtocolService;
import io.nuls.crosschain.base.service.ResetLocalVerifierService;
import io.nuls.crosschain.constant.NulsCrossChainConstant;
import io.nuls.crosschain.model.bo.Chain;
import io.nuls.crosschain.model.bo.CtxStateEnum;
import io.nuls.crosschain.model.bo.message.UntreatedMessage;
import io.nuls.crosschain.model.po.CtxStatusPO;
import io.nuls.crosschain.rpc.call.LedgerCall;
import io.nuls.crosschain.rpc.call.NetWorkCall;
import io.nuls.crosschain.srorage.CommitedOtherCtxService;
import io.nuls.crosschain.srorage.ConvertCtxService;
import io.nuls.crosschain.srorage.ConvertHashService;
import io.nuls.crosschain.srorage.CtxStateService;
import io.nuls.crosschain.srorage.CtxStatusService;
import io.nuls.crosschain.utils.CommonUtil;
import io.nuls.crosschain.utils.TxUtil;
import io.nuls.crosschain.utils.manager.ChainManager;
import java.util.ArrayList;
import java.util.List;

@Component
public class NulsProtocolServiceImpl
implements ProtocolService {
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private NulsCoresConfig config;
    @Autowired
    private ConvertCtxService convertCtxService;
    @Autowired
    private ConvertHashService convertHashService;
    @Autowired
    private CtxStatusService ctxStatusService;
    @Autowired
    private CommitedOtherCtxService otherCtxService;
    @Autowired
    private CtxStateService ctxStateService;
    @Autowired
    private static ResetLocalVerifierService resetLocalVerifierService;

    @Override
    public void getCtxState(int chainId, String nodeId, GetCtxStateMessage messageBody) {
        CtxStateMessage responseMessage = new CtxStateMessage();
        responseMessage.setRequestHash(messageBody.getRequestHash());
        responseMessage.setHandleResult(CtxStateEnum.UNCONFIRM.getStatus());
        int handleChainId = chainId;
        if (this.config.isMainNet()) {
            handleChainId = this.config.getMainChainId();
        }
        Chain chain = this.chainManager.getChainMap().get(handleChainId);
        String hashHex = messageBody.getRequestHash().toHex();
        chain.getLogger().info("Received node{}The query cross chain transaction processing result information sent over,transactionHash:{}", new Object[]{nodeId, hashHex});
        NulsHash realCtxHash = messageBody.getRequestHash();
        Transaction ctx = this.otherCtxService.get(realCtxHash, handleChainId);
        try {
            if (ctx != null) {
                int toChainId = AddressTool.getChainIdByAddress((byte[])((CoinTo)ctx.getCoinDataInstance().getTo().get(0)).getAddress());
                if (handleChainId == toChainId) {
                    responseMessage.setHandleResult(CtxStateEnum.CONFIRMED.getStatus());
                } else if (this.ctxStateService.get(messageBody.getRequestHash().getBytes(), handleChainId)) {
                    responseMessage.setHandleResult(CtxStateEnum.CONFIRMED.getStatus());
                } else {
                    responseMessage.setHandleResult(CtxStateEnum.MAINCONFIRMED.getStatus());
                    UntreatedMessage untreatedMessage = new UntreatedMessage(chainId, nodeId, messageBody, messageBody.getRequestHash());
                    chain.getGetCtxStateQueue().offer(untreatedMessage);
                }
            }
            chain.getLogger().info("The result of cross chain transaction processing is\uff1a{}(0:Confirming,1:The main network has been confirmed,2:Confirm completion),Hash:{}\n\n", new Object[]{responseMessage.getHandleResult(), hashHex});
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
        }
        NetWorkCall.sendToNode(chainId, responseMessage, nodeId, "recvCtxState");
    }

    @Override
    public void receiveCtxState(int chainId, String nodeId, CtxStateMessage messageBody) {
        int handleChainId = chainId;
        if (this.config.isMainNet()) {
            handleChainId = this.config.getMainChainId();
        }
        Chain chain = this.chainManager.getChainMap().get(handleChainId);
        chain.getLogger().debug("Received node{}Transaction processing result message sent, transactionhash:{},Processing results:{}\n\n", new Object[]{nodeId, messageBody.getRequestHash().toHex(), messageBody.getHandleResult()});
        NulsHash requestHash = messageBody.getRequestHash();
        if (!chain.getCtxStateMap().keySet().contains(requestHash)) {
            chain.getCtxStateMap().put(requestHash, new ArrayList());
        }
        chain.getCtxStateMap().get(messageBody.getRequestHash()).add(messageBody.getHandleResult());
    }

    @Override
    public void receiveCtxSign(int chainId, String nodeId, BroadCtxSignMessage messageBody) {
        int handleChainId = chainId;
        if (this.config.isMainNet()) {
            handleChainId = this.config.getMainChainId();
        }
        Chain chain = this.chainManager.getChainMap().get(handleChainId);
        NulsHash localHash = messageBody.getLocalHash();
        String nativeHex = localHash.toHex();
        String signHex = "";
        if (messageBody.getSignature() != null) {
            signHex = HexUtil.encode((byte[])messageBody.getSignature());
        }
        chain.getLogger().info("Received in chain node{}Cross chain transactions broadcasted overHashAnd signature,Hash:{},autograph:{}", new Object[]{nodeId, nativeHex, signHex});
        CtxStatusPO ctxStatusPO = this.ctxStatusService.get(localHash, handleChainId);
        if (ctxStatusPO == null) {
            UntreatedMessage untreatedSignMessage = new UntreatedMessage(chainId, nodeId, messageBody, localHash);
            chain.getFutureMessageMap().putIfAbsent(localHash, new ArrayList());
            chain.getFutureMessageMap().get(localHash).add(untreatedSignMessage);
            chain.getLogger().info("The current node has not yet confirmed the cross chain transaction, caching signature messages");
            return;
        }
        if (ctxStatusPO.getStatus() != TxStatusEnum.UNCONFIRM.getStatus() || messageBody.getSignature() == null) {
            chain.getLogger().debug("Cross chain transactions have been processed at this node,Hash:{}\n\n", new Object[]{nativeHex});
            return;
        }
        if (System.currentTimeMillis() / 1000L - ctxStatusPO.getTx().getTime() > 2592000L) {
            chain.getLogger().info("Cross chain transaction id old,Hash:{}\n\n", new Object[]{nativeHex});
            return;
        }
        try {
            UntreatedMessage untreatedSignMessage = new UntreatedMessage(chainId, nodeId, messageBody, localHash);
            chain.getSignMessageByzantineQueue().offer(untreatedSignMessage);
        }
        catch (Exception e) {
            chain.getLogger().error(e);
        }
    }

    @Override
    public void receiveCtxHash(int chainId, String nodeId, BroadCtxHashMessage messageBody) {
        int handleChainId = chainId;
        if (this.config.isMainNet()) {
            handleChainId = this.config.getMainChainId();
        }
        Chain chain = this.chainManager.getChainMap().get(handleChainId);
        NulsHash mainHash = messageBody.getConvertHash();
        String mainHex = mainHash.toHex();
        chain.getLogger().info("Received other chain nodes{}Cross chain transactions broadcasted over,Hash\uff1a{}", new Object[]{nodeId, mainHex});
        if (this.convertHashService.get(mainHash, handleChainId) != null) {
            chain.getLogger().info("This node has already received the cross chain transaction,Hash\uff1a{}\n\n", new Object[]{mainHex});
            return;
        }
        if (chain.getOtherCtxStageMap().get(mainHash) == null && chain.getOtherCtxStageMap().putIfAbsent(mainHash, 1) == null) {
            chain.getLogger().info("First time receiving cross chain transactionHashBroadcast information,Hash:{}", new Object[]{mainHex});
            GetOtherCtxMessage responseMessage = new GetOtherCtxMessage();
            responseMessage.setRequestHash(mainHash);
            NetWorkCall.sendToNode(chainId, responseMessage, nodeId, "getOtherCtx");
            chain.getLogger().info("To send chain nodes{}Obtain complete cross chain transactions,Hash:{}", new Object[]{nodeId, mainHex});
        } else {
            UntreatedMessage untreatedSignMessage = new UntreatedMessage(chainId, nodeId, messageBody, mainHash);
            chain.getHashMessageQueue().offer(untreatedSignMessage);
        }
        chain.getLogger().info("Cross chain transactions of other chain broadcastsHashMessage reception completed,Hash\uff1a{}\n\n", new Object[]{mainHex});
    }

    @Override
    public void getOtherCtx(int chainId, String nodeId, GetOtherCtxMessage messageBody) {
        CtxStatusPO ctxStatusPO;
        NewOtherCtxMessage responseMessage = new NewOtherCtxMessage();
        NulsHash mainHash = messageBody.getRequestHash();
        responseMessage.setRequestHash(mainHash);
        int handleChainId = chainId;
        if (this.config.isMainNet()) {
            handleChainId = this.config.getMainChainId();
        }
        Chain chain = this.chainManager.getChainMap().get(handleChainId);
        String nativeHex = messageBody.getRequestHash().toHex();
        chain.getLogger().info("Received request chain node{}Obtaining complete cross chain transaction information sent,Hash:{}", new Object[]{nodeId, nativeHex});
        NulsHash localHash = mainHash;
        if (!this.config.isMainNet()) {
            localHash = this.convertHashService.get(mainHash, handleChainId);
        }
        if ((ctxStatusPO = this.ctxStatusService.get(localHash, handleChainId)) == null) {
            chain.getLogger().error("Transaction does not exist,hash:{}", new Object[]{nativeHex});
            return;
        }
        if (ctxStatusPO.getTx().getType() != 25) {
            List<String> packAddressList = chain.getVerifierList();
            int byzantineCount = CommonUtil.getByzantineCount(chain, packAddressList.size());
            TransactionSignature transactionSignature = new TransactionSignature();
            try {
                transactionSignature.parse(ctxStatusPO.getTx().getTransactionSignature(), 0);
            }
            catch (NulsException e) {
                Log.error((String)"Failed to parse transaction signature");
                return;
            }
            if (transactionSignature.getP2PHKSignatures().size() < byzantineCount && ctxStatusPO.getStatus() == TxStatusEnum.UNCONFIRM.getStatus()) {
                chain.getLogger().info("The cross chain transaction obtained has not been confirmed at this node,hash:{}", new Object[]{nativeHex});
                return;
            }
        }
        Transaction localCtx = ctxStatusPO.getTx();
        if (!this.config.isMainNet() && localCtx.getType() == this.config.getCrossCtxType()) {
            try {
                localCtx = TxUtil.friendConvertToMain(chain, localCtx, 10, true);
            }
            catch (Exception e) {
                chain.getLogger().error("Error converting cross chain transaction of this chain protocol to cross chain transaction of main network protocol,Hash:{}\n\n", new Object[]{nativeHex});
                chain.getLogger().error(e);
                return;
            }
        }
        responseMessage.setCtx(localCtx);
        NetWorkCall.sendToNode(chainId, responseMessage, nodeId, "recvOtherCtx");
        chain.getLogger().info("Send the complete cross chain transaction to the requesting connection node{},Hash:{}\n\n", new Object[]{nodeId, nativeHex});
    }

    @Override
    public void receiveOtherCtx(int chainId, String nodeId, NewOtherCtxMessage messageBody) {
        int handleChainId = chainId;
        if (this.config.isMainNet()) {
            handleChainId = this.config.getMainChainId();
        }
        Chain chain = this.chainManager.getChainMap().get(handleChainId);
        NulsHash ctxHash = messageBody.getCtx().getHash();
        String ctxHashHex = ctxHash.toHex();
        chain.getLogger().info("Received other chain nodes{}The complete cross chain transaction sent over,Hash:{},Transaction type\uff1a{}", new Object[]{nodeId, ctxHashHex, messageBody.getCtx().getType()});
        if (this.convertHashService.get(ctxHash, handleChainId) != null) {
            chain.getLogger().debug("This node has received and processed the cross chain transaction,Hash:{}\n\n", new Object[]{ctxHashHex});
            return;
        }
        if (NulsCrossChainConstant.CTX_STATE_PROCESSING.equals(chain.getOtherCtxStageMap().put(ctxHash, NulsCrossChainConstant.CTX_STATE_PROCESSING))) {
            chain.getLogger().debug("The cross chain transaction is currently being processed,Hash:{}\n\n", new Object[]{ctxHashHex});
            return;
        }
        UntreatedMessage untreatedCtxMessage = new UntreatedMessage(chainId, nodeId, messageBody, ctxHash);
        chain.getOtherCtxMessageQueue().offer(untreatedCtxMessage);
        chain.getLogger().debug("Other chain nodes{}The complete cross chain transaction message sent has been received,Hash:{}", new Object[]{nodeId, ctxHashHex});
    }

    @Override
    public void getCirculation(int chainId, String nodeId, GetCirculationMessage messageBody) {
        int handleChainId = chainId;
        if (this.config.isMainNet()) {
            handleChainId = this.config.getMainChainId();
        }
        Chain chain = this.chainManager.getChainMap().get(handleChainId);
        chain.getLogger().info("Main network node{}This node queries the circulation of assets in this chain,Assets queriedIDby\uff1a{}\n\n", new Object[]{nodeId, messageBody.getAssetIds()});
        CirculationMessage message = new CirculationMessage();
        try {
            List<Circulation> circulationList = LedgerCall.getAssetsById(chain, messageBody.getAssetIds());
            message.setCirculationList(circulationList);
            NetWorkCall.sendToNode(chainId, message, nodeId, "recvCirculat");
        }
        catch (NulsException e) {
            chain.getLogger().error(e);
        }
    }

    @Override
    public void receiveCtxFullSign(int chainId, String nodeId, CtxFullSignMessage messageBody) {
        int handleChainId = chainId;
        if (this.config.isMainNet()) {
            handleChainId = this.config.getMainChainId();
        }
        Chain chain = this.chainManager.getChainMap().get(handleChainId);
        if (messageBody.getTransactionSignature() == null || messageBody.getTransactionSignature().length == 0) {
            chain.getLogger().error("The full signature of the cross chain transaction is empty,txHash:{}", new Object[]{messageBody.getLocalTxHash().toHex()});
            return;
        }
        chain.getLogger().debug("Received the full Byzantine signature of a cross-chain transaction from another node,txHash:{},sign:{}", new Object[]{messageBody.getLocalTxHash().toHex(), HexUtil.encode((byte[])messageBody.getTransactionSignature())});
        UntreatedMessage untreatedSignMessage = new UntreatedMessage(chainId, nodeId, messageBody, messageBody.getLocalTxHash());
        chain.getHashMessageQueue().offer(untreatedSignMessage);
    }
}

