/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.servive.impl;

import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.Transaction;
import io.nuls.base.signture.SignatureUtil;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.crosschain.base.model.bo.ChainInfo;
import io.nuls.crosschain.base.model.bo.txdata.RegisteredChainMessage;
import io.nuls.crosschain.base.model.bo.txdata.VerifierInitData;
import io.nuls.crosschain.base.service.VerifierInitService;
import io.nuls.crosschain.base.utils.enumeration.ChainInfoChangeType;
import io.nuls.crosschain.constant.NulsCrossChainErrorCode;
import io.nuls.crosschain.model.bo.Chain;
import io.nuls.crosschain.rpc.call.BlockCall;
import io.nuls.crosschain.rpc.call.ConsensusCall;
import io.nuls.crosschain.srorage.ConvertHashService;
import io.nuls.crosschain.srorage.RegisteredCrossChainService;
import io.nuls.crosschain.utils.TxUtil;
import io.nuls.crosschain.utils.manager.ChainManager;
import io.nuls.crosschain.utils.manager.LocalVerifierManager;
import io.nuls.crosschain.utils.thread.CrossTxHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@Component
public class VerifierInitServiceImpl
implements VerifierInitService {
    @Autowired
    private NulsCoresConfig config;
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private ConvertHashService convertHashService;
    @Autowired
    private RegisteredCrossChainService registeredCrossChainService;

    @Override
    public Map<String, Object> validate(int chainId, List<Transaction> txs, Map<Integer, List<Transaction>> txMap, BlockHeader blockHeader) {
        ArrayList<Transaction> invalidTxList = new ArrayList<Transaction>();
        Chain chain = this.chainManager.getChainMap().get(chainId);
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        String errorCode = null;
        for (Transaction verifierInitTx : txs) {
            try {
                int minPassCount;
                ArrayList<String> verifierList;
                VerifierInitData verifierInitData = new VerifierInitData();
                verifierInitData.parse(verifierInitTx.getTxData(), 0);
                List<String> initVerifierList = verifierInitData.getVerifierList();
                int verifierChainId = verifierInitData.getRegisterChainId();
                if (initVerifierList == null || initVerifierList.isEmpty() || verifierChainId <= 0) {
                    chain.getLogger().error("Verifier change information is invalid,chainId:{}", new Object[]{verifierChainId});
                }
                if (!this.config.isMainNet()) {
                    verifierList = new ArrayList<String>(Arrays.asList(this.config.getVerifiers().split(",")));
                    verifierChainId = this.config.getMainChainId();
                    minPassCount = verifierList.size() * this.config.getMainByzantineRatio() / 100;
                    if (minPassCount == 0) {
                        minPassCount = 1;
                    }
                } else {
                    ChainInfo chainInfo = this.chainManager.getChainInfo(verifierChainId);
                    if (chainInfo == null) {
                        chain.getLogger().error("Chain not registered,chainId:{}", new Object[]{verifierChainId});
                        throw new NulsException(NulsCrossChainErrorCode.CHAIN_UNREGISTERED);
                    }
                    verifierList = new ArrayList<String>(chainInfo.getVerifierList());
                    minPassCount = chainInfo.getMinPassCount();
                }
                if (verifierList.isEmpty()) {
                    chain.getLogger().error("The chain has not registered a verifier yet,chainId:{}", new Object[]{verifierChainId});
                    throw new NulsException(NulsCrossChainErrorCode.CHAIN_UNREGISTERED_VERIFIER);
                }
                if (!SignatureUtil.validateCtxSignture((Transaction)verifierInitTx)) {
                    chain.getLogger().info("Main network protocol cross chain transaction signature verification failed\uff01");
                    throw new NulsException(NulsCrossChainErrorCode.SIGNATURE_ERROR);
                }
                if (TxUtil.signByzantineVerify(chain, verifierInitTx, verifierList, minPassCount, verifierChainId)) continue;
                chain.getLogger().info("Signature Byzantine verification failed\uff01");
                throw new NulsException(NulsCrossChainErrorCode.CTX_SIGN_BYZANTINE_FAIL);
            }
            catch (NulsException e) {
                chain.getLogger().error(e);
                errorCode = e.getErrorCode().getCode();
                invalidTxList.add(verifierInitTx);
            }
        }
        result.put("txList", invalidTxList);
        result.put("errorCode", errorCode);
        return result;
    }

    @Override
    public boolean commit(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return false;
        }
        int syncStatus = BlockCall.getBlockStatus(chain);
        ArrayList<Transaction> commitSuccessList = new ArrayList<Transaction>();
        for (Transaction verifierInitTx : txs) {
            try {
                VerifierInitData verifierInitData = new VerifierInitData();
                verifierInitData.parse(verifierInitTx.getTxData(), 0);
                List<String> initVerifierList = verifierInitData.getVerifierList();
                int verifierChainId = !this.config.isMainNet() ? this.config.getMainChainId() : verifierInitData.getRegisterChainId();
                ChainInfo chainInfo = this.chainManager.getChainInfo(verifierChainId);
                chainInfo.setVerifierList(new HashSet<String>(initVerifierList));
                chain.getLogger().info("chain{}Initialize the list of validators as{}", new Object[]{verifierChainId, chainInfo.getVerifierList().toString()});
                RegisteredChainMessage registeredChainMessage = new RegisteredChainMessage();
                registeredChainMessage.setChainInfoList(this.chainManager.getRegisteredCrossChainList());
                if (!this.registeredCrossChainService.save(registeredChainMessage)) {
                    this.rollback(chainId, commitSuccessList, blockHeader);
                    return false;
                }
                commitSuccessList.add(verifierInitTx);
                this.chainManager.setCrossNetUseAble(true);
                if (!this.config.isMainNet()) {
                    List localVerifierList = (List)ConsensusCall.getPackerInfo(chain).get("packAddressList");
                    if (chain.getVerifierList() == null || chain.getVerifierList().isEmpty()) {
                        chain.getLogger().info("Parallel link receives primary network initialization verifier transaction, initializes local verifier,localVerifierList:{}", new Object[]{localVerifierList});
                        boolean result = LocalVerifierManager.initLocalVerifier(chain, localVerifierList);
                        if (!result) {
                            return false;
                        }
                    }
                    chain.getCrossTxThreadPool().execute(new CrossTxHandler(chain, TxUtil.createVerifierInitTx(localVerifierList, blockHeader.getTime(), chainId), syncStatus));
                    continue;
                }
                chain.getLogger().info("chain\uff1a{}Initialize completed, send the registered cross chain information to the chain", new Object[]{verifierChainId});
                chain.getCrossTxThreadPool().execute(new CrossTxHandler(chain, TxUtil.createCrossChainChangeTx(this.chainManager.getRegisteredCrossChainList(), blockHeader.getTime(), chainInfo.getChainId(), ChainInfoChangeType.INIT_REGISTER_CHAIN.getType()), syncStatus));
            }
            catch (NulsException e) {
                chain.getLogger().error(e);
                this.rollback(chainId, commitSuccessList, blockHeader);
                return false;
            }
            catch (IOException io) {
                chain.getLogger().error((Exception)io);
                this.rollback(chainId, commitSuccessList, blockHeader);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean rollback(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        Chain chain = this.chainManager.getChainMap().get(chainId);
        if (chain == null) {
            return false;
        }
        for (Transaction verifierInitTx : txs) {
            try {
                VerifierInitData verifierInitData = new VerifierInitData();
                verifierInitData.parse(verifierInitTx.getTxData(), 0);
                List<String> initVerifierList = verifierInitData.getVerifierList();
                int verifierChainId = !this.config.isMainNet() ? this.config.getMainChainId() : verifierInitData.getRegisterChainId();
                ChainInfo chainInfo = this.chainManager.getChainInfo(verifierChainId);
                chainInfo.getVerifierList().removeAll(initVerifierList);
                RegisteredChainMessage registeredChainMessage = new RegisteredChainMessage();
                registeredChainMessage.setChainInfoList(this.chainManager.getRegisteredCrossChainList());
                if (this.registeredCrossChainService.save(registeredChainMessage)) continue;
                return false;
            }
            catch (NulsException e) {
                chain.getLogger().error(e);
                return false;
            }
        }
        return true;
    }
}

