/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.srorage.imp;

import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.Log;
import io.nuls.core.model.ByteUtils;
import io.nuls.core.rockdb.model.Entry;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.crosschain.model.po.SendCtxHashPO;
import io.nuls.crosschain.srorage.SendHeightService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class SendHeightServiceImpl
implements SendHeightService {
    @Override
    public boolean save(long height, SendCtxHashPO po, int chainID) {
        if (height == 0L || po == null) {
            return false;
        }
        try {
            return RocksDBService.put((String)("send_height" + chainID), (byte[])ByteUtils.longToBytes((long)height), (byte[])po.serialize());
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return false;
        }
    }

    @Override
    public SendCtxHashPO get(long height, int chainID) {
        if (height == 0L) {
            return null;
        }
        try {
            byte[] valueBytes = RocksDBService.get((String)("send_height" + chainID), (byte[])ByteUtils.longToBytes((long)height));
            if (valueBytes == null) {
                return null;
            }
            SendCtxHashPO po = new SendCtxHashPO();
            po.parse(valueBytes, 0);
            return po;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return null;
        }
    }

    @Override
    public boolean delete(long height, int chainID) {
        try {
            if (height == 0L) {
                return false;
            }
            return RocksDBService.delete((String)("send_height" + chainID), (byte[])ByteUtils.longToBytes((long)height));
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return false;
        }
    }

    @Override
    public Map<Long, SendCtxHashPO> getList(int chainID) {
        try {
            List list = RocksDBService.entryList((String)("send_height" + chainID));
            HashMap<Long, SendCtxHashPO> poMap = new HashMap<Long, SendCtxHashPO>(16);
            for (Entry entry : list) {
                SendCtxHashPO po = new SendCtxHashPO();
                po.parse((byte[])entry.getValue(), 0);
                poMap.put(ByteUtils.byteToLong((byte[])((byte[])entry.getKey())), po);
            }
            return poMap;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return null;
        }
    }
}

