/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.utils.thread;

import io.nuls.base.data.Transaction;
import io.nuls.core.exception.NulsException;
import io.nuls.crosschain.base.model.bo.txdata.VerifierChangeData;
import io.nuls.crosschain.model.bo.Chain;
import io.nuls.crosschain.utils.TxUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class VerifierChangeTxHandler
implements Runnable {
    private Chain chain;
    private Transaction transaction;
    private long height;

    public VerifierChangeTxHandler(Chain chain, Transaction transaction, long height) {
        this.chain = chain;
        this.transaction = transaction;
        this.height = height;
        chain.getLogger().info("TxHash: {}", new Object[]{transaction.getHash().toHex()});
    }

    @Override
    public void run() {
        TxUtil.verifierChangeWait(this.chain, this.height);
        boolean result = true;
        VerifierChangeData txData = new VerifierChangeData();
        boolean txChanged = false;
        try {
            txData.parse(this.transaction.getTxData(), 0);
        }
        catch (NulsException e) {
            this.chain.getLogger().error(e);
            return;
        }
        do {
            Transaction processTx;
            if ((processTx = this.chain.isExistVerifierChangeTx(this.transaction)) == null) continue;
            VerifierChangeData processTxData = new VerifierChangeData();
            try {
                processTxData.parse(processTx.getTxData(), 0);
            }
            catch (NulsException e) {
                this.chain.getLogger().error(e);
                return;
            }
            if (processTxData.getCancelAgentList() != null && processTxData.getCancelAgentList().size() + 1 > this.chain.getVerifierList().size() * 30 / 100) {
                try {
                    TimeUnit.SECONDS.sleep(2L);
                }
                catch (InterruptedException e) {
                    this.chain.getLogger().error((Exception)e);
                }
                this.chain.getLogger().info("The number of exit nodes of the currently processing verifier change transaction is greater than or equal to 30%, and it needs to wait for the completion of the transaction processing");
                result = false;
                continue;
            }
            txData = this.mergeVerifierChangeTx(txData, processTxData);
            txChanged = true;
        } while (!result);
        this.verifierSplitHandle(this.chain, this.transaction, this.height, txData, txChanged);
    }

    private VerifierChangeData mergeVerifierChangeTx(VerifierChangeData txData, VerifierChangeData processTxData) {
        VerifierChangeData mergeTxData = new VerifierChangeData();
        HashSet<String> appendSet = null;
        if (txData.getRegisterAgentList() != null && !txData.getRegisterAgentList().isEmpty()) {
            appendSet = new HashSet<String>(txData.getRegisterAgentList());
            this.chain.getLogger().info("New witness list for current transaction\uff1a{}", new Object[]{txData.getRegisterAgentList()});
        }
        if (processTxData.getRegisterAgentList() != null && !processTxData.getRegisterAgentList().isEmpty()) {
            if (appendSet != null) {
                appendSet.addAll(processTxData.getRegisterAgentList());
            } else {
                appendSet = new HashSet<String>(processTxData.getRegisterAgentList());
            }
            this.chain.getLogger().info("List of new examiners in processing transactions:{}", new Object[]{processTxData.getRegisterAgentList()});
        }
        if (appendSet != null && !appendSet.isEmpty()) {
            mergeTxData.setRegisterAgentList(new ArrayList<String>(appendSet));
            mergeTxData.getRegisterAgentList().sort(Comparator.naturalOrder());
            this.chain.getLogger().info("New witness list for transactions after merger:{}", new Object[]{mergeTxData.getRegisterAgentList()});
        }
        HashSet<String> reduceSet = null;
        if (txData.getCancelAgentList() != null && !txData.getCancelAgentList().isEmpty()) {
            reduceSet = new HashSet<String>(txData.getCancelAgentList());
            this.chain.getLogger().info("The list of validators for the reduction of transactions in process is:{}", new Object[]{txData.getCancelAgentList()});
        }
        if (processTxData.getCancelAgentList() != null && !processTxData.getCancelAgentList().isEmpty()) {
            if (reduceSet != null) {
                reduceSet.addAll(processTxData.getCancelAgentList());
            } else {
                reduceSet = new HashSet<String>(processTxData.getCancelAgentList());
            }
            this.chain.getLogger().info("The list of verifiers for current transaction decrease is:{}", new Object[]{processTxData.getCancelAgentList()});
        }
        if (reduceSet != null && !reduceSet.isEmpty()) {
            mergeTxData.setCancelAgentList(new ArrayList<String>(reduceSet));
            mergeTxData.getCancelAgentList().sort(Comparator.naturalOrder());
            this.chain.getLogger().info("Reduced verifier list of transactions after consolidation:{}", new Object[]{mergeTxData.getCancelAgentList()});
        }
        return mergeTxData;
    }

    private void verifierSplitHandle(Chain chain, Transaction transaction, long height, VerifierChangeData txData, boolean txChanged) {
        boolean needSplit = false;
        int maxCount = 0;
        int cancelCount = 0;
        if (txData.getCancelAgentList() != null && !txData.getCancelAgentList().isEmpty() && txData.getCancelAgentList().size() > 1) {
            maxCount = chain.getVerifierList().size() * 30 / 100;
            cancelCount = txData.getCancelAgentList().size();
            if (txData.getCancelAgentList().size() > maxCount) {
                needSplit = true;
            }
        }
        if (needSplit) {
            if (!txChanged) {
                txData.getCancelAgentList().sort(Comparator.naturalOrder());
            }
            List<String> firstCancelList = txData.getCancelAgentList().subList(0, maxCount);
            List<String> secondCancelList = txData.getCancelAgentList().subList(maxCount, cancelCount);
            try {
                Transaction firstTx = TxUtil.createVerifierChangeTx(txData.getRegisterAgentList(), firstCancelList, transaction.getTime(), chain.getChainId());
                Transaction secondTx = TxUtil.createVerifierChangeTx(new ArrayList<String>(), secondCancelList, transaction.getTime(), chain.getChainId());
                chain.getLogger().info("The exit node of the transaction changed by the verifier is greater than 30% of the current node, which is divided into two transactions,firstTx:{},secondTx:{}", new Object[]{firstTx.getHash().toHex(), secondTx.getHash().toHex()});
                chain.getCrossTxThreadPool().execute(new VerifierChangeTxHandler(chain, firstTx, height));
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e) {
                    chain.getLogger().error((Exception)e);
                }
                chain.getCrossTxThreadPool().execute(new VerifierChangeTxHandler(chain, secondTx, height + 2L));
            }
            catch (IOException e) {
                chain.getLogger().error((Exception)e);
            }
        } else {
            try {
                transaction.setTxData(txData.serialize());
            }
            catch (IOException e) {
                chain.getLogger().error((Exception)e);
                return;
            }
            TxUtil.handleNewCtx(transaction, chain, txData.getCancelAgentList());
        }
    }
}

