/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.crosschain.utils.thread.handler;

import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.base.signture.P2PHKSignature;
import io.nuls.base.signture.TransactionSignature;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.crypto.ECKey;
import io.nuls.core.crypto.HexUtil;
import io.nuls.crosschain.base.message.CtxFullSignMessage;
import io.nuls.crosschain.base.service.ResetLocalVerifierService;
import io.nuls.crosschain.model.bo.Chain;
import io.nuls.crosschain.model.bo.message.UntreatedMessage;
import io.nuls.crosschain.model.po.CtxStatusPO;
import io.nuls.crosschain.rpc.call.ConsensusCall;
import io.nuls.crosschain.srorage.ConvertCtxService;
import io.nuls.crosschain.srorage.CtxStatusService;
import io.nuls.crosschain.utils.CommonUtil;
import java.util.List;

public class SaveCtxFullSignHandler
implements Runnable {
    private Chain chain;
    private CtxStatusService ctxStatusService;
    private ResetLocalVerifierService resetLocalVerifierService;
    private ConvertCtxService convertCtxService;
    private NulsCoresConfig config;

    public SaveCtxFullSignHandler(Chain chain, NulsCoresConfig config, CtxStatusService ctxStatusService, ResetLocalVerifierService resetLocalVerifierService, ConvertCtxService convertCtxService) {
        this.ctxStatusService = ctxStatusService;
        this.resetLocalVerifierService = resetLocalVerifierService;
        this.config = config;
        this.chain = chain;
        this.convertCtxService = convertCtxService;
    }

    @Override
    public void run() {
        while (!this.chain.getTxFullSignMessageQueue().isEmpty()) {
            try {
                UntreatedMessage untreatedMessage = this.chain.getTxFullSignMessageQueue().take();
                CtxFullSignMessage message = (CtxFullSignMessage)untreatedMessage.getMessage();
                this.chain.getLogger().info("Start storing cross-chain transaction signatures pushed by other nodes: localTxHash:{},sign:{}", new Object[]{message.getLocalTxHash().toHex(), HexUtil.encode((byte[])message.getTransactionSignature())});
                CtxStatusPO ctxStatusPO = this.ctxStatusService.get(message.getLocalTxHash(), this.chain.getChainId());
                if (ctxStatusPO == null) {
                    this.chain.getLogger().warn("No corresponding cross-chain transaction was found locally:{}", new Object[]{message.getLocalTxHash().toHex()});
                    continue;
                }
                Transaction tx = ctxStatusPO.getTx();
                List<String> packAddressList = this.getPackingAddressList(tx, tx.getHash(), this.chain);
                this.chain.getLogger().info("Gets the number of validators address listed:{}", new Object[]{packAddressList.size()});
                TransactionSignature localTxSign = new TransactionSignature();
                localTxSign.parse(tx.getTransactionSignature(), 0);
                this.chain.getLogger().debug("Gets the number of signatures for local cross-chain transactions:{}", new Object[]{localTxSign.getP2PHKSignatures().size()});
                TransactionSignature messageTxSign = new TransactionSignature();
                messageTxSign.parse(message.getTransactionSignature(), 0);
                this.chain.getLogger().debug("Gets the number of signatures contained in the message:{}", new Object[]{messageTxSign.getP2PHKSignatures().size()});
                Transaction convertCtx = ctxStatusPO.getTx();
                if (!this.config.isMainNet() && convertCtx.getType() == this.config.getCrossCtxType()) {
                    convertCtx = this.convertCtxService.get(message.getLocalTxHash(), this.chain.getChainId());
                }
                this.chain.getLogger().info("Signature verification hash:{}", new Object[]{convertCtx.getHash().toHex()});
                int signVerifyPassNumber = 0;
                for (P2PHKSignature sign : messageTxSign.getP2PHKSignatures()) {
                    if (!ECKey.verify((byte[])convertCtx.getHash().getBytes(), (byte[])sign.getSignData().getSignBytes(), (byte[])sign.getPublicKey())) continue;
                    localTxSign.getP2PHKSignatures().add(sign);
                    ++signVerifyPassNumber;
                }
                this.chain.getLogger().debug("Result of verifying the signature in the message,total:{},pass:{}", new Object[]{messageTxSign.getP2PHKSignatures().size(), signVerifyPassNumber});
                localTxSign.setP2PHKSignatures(CommonUtil.getMisMatchSigns(this.chain, localTxSign, packAddressList));
                this.chain.getLogger().debug("Number of transaction signatures after the merger:{}", new Object[]{localTxSign.getP2PHKSignatures().size()});
                tx.setTransactionSignature(localTxSign.serialize());
                ctxStatusPO.setTx(tx);
                this.ctxStatusService.save(message.getLocalTxHash(), ctxStatusPO, this.chain.getChainId());
                this.chain.getLogger().info("Save transaction transaction signature:{}", new Object[]{untreatedMessage.getCacheHash().toHex()});
            }
            catch (Exception e) {
                this.chain.getLogger().error("An error occurred processing the full signature pushed by another node", e);
            }
        }
    }

    private List<String> getPackingAddressList(Transaction ctx, NulsHash realHash, Chain chain) {
        List packAddressList;
        Float signCountOverflow = Float.valueOf(0.0f);
        if (ctx.getType() == 25) {
            String txHash = realHash.toHex();
            if (this.resetLocalVerifierService.isResetOtherVerifierTx(txHash)) {
                packAddressList = chain.getVerifierList();
                signCountOverflow = Float.valueOf(1.0f);
            } else {
                packAddressList = (List)ConsensusCall.getSeedNodeList(chain).get("packAddressList");
            }
        } else {
            packAddressList = chain.getVerifierList();
        }
        return packAddressList;
    }
}

