/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.model.po;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.ledger.constant.LedgerConstant;
import java.io.IOException;
import java.math.BigInteger;

public class TxUnconfirmed
extends BaseNulsData {
    private String address;
    private int assetChainId;
    private int assetId;
    private byte[] fromNonce = LedgerConstant.getInitNonceByte();
    private byte[] nonce = LedgerConstant.getInitNonceByte();
    private byte[] nextNonce = LedgerConstant.getInitNonceByte();
    private BigInteger amount = BigInteger.ZERO;

    public TxUnconfirmed() {
    }

    public TxUnconfirmed(String address, int assetChainId, int assetId, byte[] pFromNonce, byte[] pNonce, BigInteger amount) {
        this.address = address;
        this.assetChainId = assetChainId;
        this.assetId = assetId;
        System.arraycopy(pFromNonce, 0, this.fromNonce, 0, 8);
        System.arraycopy(pNonce, 0, this.nonce, 0, 8);
        this.amount = amount;
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeString(this.address);
        stream.writeUint16(this.assetChainId);
        stream.writeUint16(this.assetId);
        stream.write(this.fromNonce);
        stream.write(this.nonce);
        stream.write(this.nextNonce);
        stream.writeBigInteger(this.amount);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.address = byteBuffer.readString();
        this.assetChainId = byteBuffer.readUint16();
        this.assetId = byteBuffer.readUint16();
        this.fromNonce = byteBuffer.readBytes(8);
        this.nonce = byteBuffer.readBytes(8);
        this.nextNonce = byteBuffer.readBytes(8);
        this.amount = byteBuffer.readBigInteger();
    }

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfString((String)this.address);
        size += SerializeUtils.sizeOfInt16();
        size += SerializeUtils.sizeOfInt16();
        size += this.fromNonce.length;
        size += this.nonce.length;
        size += this.nextNonce.length;
        return size += SerializeUtils.sizeOfBigInteger();
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public int getAssetChainId() {
        return this.assetChainId;
    }

    public void setAssetChainId(int assetChainId) {
        this.assetChainId = assetChainId;
    }

    public int getAssetId() {
        return this.assetId;
    }

    public void setAssetId(int assetId) {
        this.assetId = assetId;
    }

    public byte[] getFromNonce() {
        return this.fromNonce;
    }

    public void setFromNonce(byte[] fromNonce) {
        this.fromNonce = fromNonce;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public void setNonce(byte[] nonce) {
        this.nonce = nonce;
    }

    public byte[] getNextNonce() {
        return this.nextNonce;
    }

    public void setNextNonce(byte[] nextNonce) {
        this.nextNonce = nextNonce;
    }

    public BigInteger getAmount() {
        return this.amount;
    }

    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }
}

