/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.model.po.sub;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.ledger.constant.LedgerConstant;
import java.io.IOException;
import java.math.BigInteger;

public class FreezeHeightState
extends BaseNulsData {
    private String txHash;
    private byte[] nonce = LedgerConstant.getInitNonceByte();
    private BigInteger amount = BigInteger.ZERO;
    private long height = 0L;
    private long createTime = 0L;

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeString(this.txHash);
        stream.write(this.nonce);
        stream.writeBigInteger(this.amount);
        stream.writeUint32(this.height);
        stream.writeUint32(this.createTime);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.txHash = byteBuffer.readString();
        this.nonce = byteBuffer.readBytes(8);
        this.amount = byteBuffer.readBigInteger();
        this.height = byteBuffer.readUint32();
        this.createTime = byteBuffer.readUint32();
    }

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfString((String)this.txHash);
        size += this.nonce.length;
        size += SerializeUtils.sizeOfBigInteger();
        size += SerializeUtils.sizeOfUint32();
        return size += SerializeUtils.sizeOfUint32();
    }

    public String getTxHash() {
        return this.txHash;
    }

    public void setTxHash(String txHash) {
        this.txHash = txHash;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public void setNonce(byte[] nonce) {
        this.nonce = nonce;
    }

    public BigInteger getAmount() {
        return this.amount;
    }

    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }

    public long getHeight() {
        return this.height;
    }

    public void setHeight(long height) {
        this.height = height;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }
}

