/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.rpc.cmd;

import io.nuls.base.RPCUtil;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.ledger.constant.LedgerConstant;
import io.nuls.ledger.constant.LedgerErrorCode;
import io.nuls.ledger.model.FreezeLockState;
import io.nuls.ledger.model.po.AccountState;
import io.nuls.ledger.model.po.AccountStateUnconfirmed;
import io.nuls.ledger.model.po.sub.FreezeHeightState;
import io.nuls.ledger.model.po.sub.FreezeLockTimeState;
import io.nuls.ledger.rpc.cmd.BaseLedgerCmd;
import io.nuls.ledger.service.AccountStateService;
import io.nuls.ledger.service.UnconfirmedStateService;
import io.nuls.ledger.utils.LedgerUtil;
import io.nuls.ledger.utils.LoggerUtil;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
@NulsCoresCmd(module=ModuleE.LG)
public class AccountStateCmd
extends BaseLedgerCmd {
    @Autowired
    private AccountStateService accountStateService;
    @Autowired
    private UnconfirmedStateService unconfirmedStateService;

    @CmdAnnotation(cmd="getBalance", version=1.0, description="Obtain account assets(Blocked)")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Run ChainId,Value range[1-65535]"), @Parameter(parameterName="assetChainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Asset ChainId,Value range[1-65535]"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="assetId,Value range[1-65535]"), @Parameter(parameterName="address", requestType=@TypeDescriptor(value=String.class), parameterDes="Asset location address")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="total", valueType=BigInteger.class, description="Total amount"), @Key(name="freeze", valueType=BigInteger.class, description="Freeze amount"), @Key(name="available", valueType=String.class, description="Available amount")}))
    public Response getBalance(Map params) {
        Integer chainId = (Integer)params.get("chainId");
        Integer assetChainId = (Integer)params.get("assetChainId");
        String address = LedgerUtil.getRealAddressStr((String)params.get("address"));
        Integer assetId = (Integer)params.get("assetId");
        if (!this.chainHanlder(chainId)) {
            return this.failed(LedgerErrorCode.CHAIN_INIT_FAIL);
        }
        LoggerUtil.logger(chainId).debug("chainId={},assetChainId={},address={},assetId={}", new Object[]{chainId, assetChainId, address, assetId});
        AccountState accountState = this.accountStateService.getAccountStateReCal(address, chainId, assetChainId, assetId);
        HashMap<String, BigInteger> rtMap = new HashMap<String, BigInteger>(5);
        rtMap.put("freeze", accountState.getFreezeTotal());
        rtMap.put("total", accountState.getTotalAmount());
        rtMap.put("available", accountState.getAvailableAmount());
        BigInteger permanentLocked = BigInteger.ZERO;
        BigInteger timeHeightLocked = BigInteger.ZERO;
        for (FreezeLockTimeState freezeLockTimeState : accountState.getFreezeLockTimeStates()) {
            if (LedgerUtil.isPermanentLock(freezeLockTimeState.getLockTime())) {
                permanentLocked = permanentLocked.add(freezeLockTimeState.getAmount());
                continue;
            }
            timeHeightLocked = timeHeightLocked.add(freezeLockTimeState.getAmount());
        }
        for (FreezeHeightState freezeHeightState : accountState.getFreezeHeightStates()) {
            timeHeightLocked = timeHeightLocked.add(freezeHeightState.getAmount());
        }
        rtMap.put("permanentLocked", permanentLocked);
        rtMap.put("timeHeightLocked", timeHeightLocked);
        Response response = this.success(rtMap);
        return response;
    }

    @CmdAnnotation(cmd="getBalanceList", version=1.0, description="Obtain a collection of account assets")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Running ChainId,Value range[1-65535]"), @Parameter(parameterName="assetKeyList", requestType=@TypeDescriptor(value=List.class, collectionElement=String.class), parameterDes="assetkeyaggregate, [assetChainId-assetId]"), @Parameter(parameterName="address", requestType=@TypeDescriptor(value=String.class), parameterDes="Asset location address")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="list", valueType=Map.class, description="Account asset collection")}))
    public Response getBalanceList(Map params) {
        Integer chainId = (Integer)params.get("chainId");
        List assetKeyList = (List)params.get("assetKeyList");
        if (assetKeyList == null) {
            return this.failed(LedgerErrorCode.PARAMETER_ERROR, "invalid `assetKeyList`");
        }
        String address = LedgerUtil.getRealAddressStr((String)params.get("address"));
        if (!this.chainHanlder(chainId)) {
            return this.failed(LedgerErrorCode.CHAIN_INIT_FAIL);
        }
        HashMap resultList = new HashMap();
        HashMap resultMap = new HashMap();
        for (String assetKey : assetKeyList) {
            assetKey = assetKey.trim();
            String[] assetInfo = assetKey.split("-");
            int assetChainId = Integer.parseInt(assetInfo[0].trim());
            int assetId = Integer.parseInt(assetInfo[1].trim());
            AccountState accountState = this.accountStateService.getAccountStateReCal(address, chainId, assetChainId, assetId);
            HashMap<String, BigInteger> rtMap = new HashMap<String, BigInteger>(5);
            rtMap.put("freeze", accountState.getFreezeTotal());
            rtMap.put("total", accountState.getTotalAmount());
            rtMap.put("available", accountState.getAvailableAmount());
            BigInteger permanentLocked = BigInteger.ZERO;
            BigInteger timeHeightLocked = BigInteger.ZERO;
            for (FreezeLockTimeState freezeLockTimeState : accountState.getFreezeLockTimeStates()) {
                if (LedgerUtil.isPermanentLock(freezeLockTimeState.getLockTime())) {
                    permanentLocked = permanentLocked.add(freezeLockTimeState.getAmount());
                    continue;
                }
                timeHeightLocked = timeHeightLocked.add(freezeLockTimeState.getAmount());
            }
            for (FreezeHeightState freezeHeightState : accountState.getFreezeHeightStates()) {
                timeHeightLocked = timeHeightLocked.add(freezeHeightState.getAmount());
            }
            rtMap.put("permanentLocked", permanentLocked);
            rtMap.put("timeHeightLocked", timeHeightLocked);
            resultList.put(assetKey, rtMap);
        }
        resultMap.put("list", resultList);
        Response response = this.success(resultMap);
        return response;
    }

    @CmdAnnotation(cmd="getFreezeList", version=1.0, description="Paging to obtain account locked asset list")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Run ChainId,Value range[1-65535]"), @Parameter(parameterName="assetChainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Asset ChainId,Value range[1-65535]"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="assetId,Value range[1-65535]"), @Parameter(parameterName="address", requestType=@TypeDescriptor(value=String.class), parameterDes="Asset location address"), @Parameter(parameterName="pageNumber", requestType=@TypeDescriptor(value=int.class), parameterDes="Starting page count"), @Parameter(parameterName="pageSize", requestType=@TypeDescriptor(value=int.class), parameterDes="Display quantity per page")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="totalCount", valueType=Integer.class, description="Total number of records"), @Key(name="pageNumber", valueType=Integer.class, description="Starting page count"), @Key(name="pageSize", valueType=Integer.class, description="Display quantity per page"), @Key(name="list", valueType=List.class, valueElement=FreezeLockState.class, description="Lock Amount List")}))
    public Response getFreezeList(Map params) {
        FreezeLockState freezeLockState;
        Integer chainId = (Integer)params.get("chainId");
        Integer assetChainId = (Integer)params.get("assetChainId");
        String address = LedgerUtil.getRealAddressStr((String)params.get("address"));
        Integer assetId = (Integer)params.get("assetId");
        Integer pageNumber = (Integer)params.get("pageNumber");
        Integer pageSize = (Integer)params.get("pageSize");
        if (!this.chainHanlder(chainId)) {
            return this.failed(LedgerErrorCode.CHAIN_INIT_FAIL);
        }
        AccountState accountState = this.accountStateService.getAccountStateReCal(address, chainId, assetChainId, assetId);
        ArrayList<FreezeLockState> freezeLockStates = new ArrayList<FreezeLockState>();
        for (FreezeLockTimeState freezeLockTimeState : accountState.getFreezeLockTimeStates()) {
            freezeLockState = new FreezeLockState();
            freezeLockState.setAmount(freezeLockTimeState.getAmount());
            freezeLockState.setLockedValue(freezeLockTimeState.getLockTime());
            freezeLockState.setTime(freezeLockTimeState.getCreateTime());
            freezeLockState.setTxHash(freezeLockTimeState.getTxHash());
            freezeLockStates.add(freezeLockState);
        }
        for (FreezeHeightState freezeHeightState : accountState.getFreezeHeightStates()) {
            freezeLockState = new FreezeLockState();
            freezeLockState.setAmount(freezeHeightState.getAmount());
            freezeLockState.setLockedValue(freezeHeightState.getHeight());
            freezeLockState.setTime(freezeHeightState.getCreateTime());
            freezeLockState.setTxHash(freezeHeightState.getTxHash());
            freezeLockStates.add(freezeLockState);
        }
        freezeLockStates.sort((x, y) -> Long.compare(y.getTime(), x.getTime()));
        int currIdx = pageNumber > 1 ? (pageNumber - 1) * pageSize : 0;
        List resultList = new ArrayList();
        resultList = currIdx + pageSize > freezeLockStates.size() ? freezeLockStates.subList(currIdx, freezeLockStates.size()) : freezeLockStates.subList(currIdx, currIdx + pageSize);
        HashMap<String, Serializable> rtMap = new HashMap<String, Serializable>(4);
        rtMap.put("totalCount", Integer.valueOf(freezeLockStates.size()));
        rtMap.put("pageNumber", pageNumber);
        rtMap.put("pageSize", pageSize);
        rtMap.put("list", (Serializable)((Object)resultList));
        return this.success(rtMap);
    }

    @CmdAnnotation(cmd="getNonce", version=1.0, description="Obtain account assetsNONCEvalue")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Running ChainId,Value range[1-65535]"), @Parameter(parameterName="assetChainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Asset ChainId,Value range[1-65535]"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="assetId,Value range[1-65535]"), @Parameter(parameterName="address", requestType=@TypeDescriptor(value=String.class), parameterDes="Asset location address"), @Parameter(parameterName="isConfirmed", requestType=@TypeDescriptor(value=boolean.class), parameterDes="Optional items,defaultfalse. filltrue,Then it must be obtained from the confirmed transaction")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="nonce", valueType=String.class, description="Account assetsnoncevalue"), @Key(name="nonceType", valueType=Integer.class, description="1\uff1aConfirmednoncevalue,0\uff1aunacknowledgednoncevalue")}))
    public Response getNonce(Map params) {
        Integer chainId = (Integer)params.get("chainId");
        Integer assetChainId = (Integer)params.get("assetChainId");
        String address = LedgerUtil.getRealAddressStr((String)params.get("address"));
        Integer assetId = (Integer)params.get("assetId");
        boolean isConfirmed = false;
        if (null != params.get("isConfirmed")) {
            isConfirmed = Boolean.valueOf(params.get("isConfirmed").toString());
        }
        if (!this.chainHanlder(chainId)) {
            return this.failed(LedgerErrorCode.CHAIN_INIT_FAIL);
        }
        HashMap<String, Object> rtMap = new HashMap<String, Object>(2);
        AccountState accountState = this.accountStateService.getAccountState(address, chainId, assetChainId, assetId);
        AccountStateUnconfirmed accountStateUnconfirmed = this.unconfirmedStateService.getUnconfirmedInfo(address, chainId, assetChainId, assetId, accountState);
        if (isConfirmed || null == accountStateUnconfirmed) {
            rtMap.put("nonce", RPCUtil.encode((byte[])accountState.getNonce()));
            rtMap.put("nonceType", LedgerConstant.CONFIRMED_NONCE);
        } else {
            rtMap.put("nonce", RPCUtil.encode((byte[])accountStateUnconfirmed.getNonce()));
            rtMap.put("nonceType", LedgerConstant.UNCONFIRMED_NONCE);
        }
        return this.success(rtMap);
    }

    @CmdAnnotation(cmd="getBalanceNonce", version=1.0, description="Obtain account asset balance andNONCEvalue")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Running ChainId,Value range[1-65535]"), @Parameter(parameterName="assetChainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Asset ChainId,Value range[1-65535]"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="assetId,Value range[1-65535]"), @Parameter(parameterName="address", requestType=@TypeDescriptor(value=String.class), parameterDes="Asset location address"), @Parameter(parameterName="isConfirmed", requestType=@TypeDescriptor(value=boolean.class), parameterDes="Optional items,defaultfalse. filltrue,Then it must be obtained from the confirmed transaction")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="nonce", valueType=String.class, description="Account assetsnoncevalue"), @Key(name="nonceType", valueType=Integer.class, description="1\uff1aConfirmednoncevalue,0\uff1aunacknowledgednoncevalue"), @Key(name="available", valueType=BigInteger.class, description="Available amount"), @Key(name="freeze", valueType=BigInteger.class, description="Total locked amount"), @Key(name="permanentLocked", valueType=BigInteger.class, description="Permanently locked amount"), @Key(name="timeHeightLocked", valueType=BigInteger.class, description="Height or Time Locked Amount")}))
    public Response getBalanceNonce(Map params) {
        Integer chainId = (Integer)params.get("chainId");
        Integer assetChainId = (Integer)params.get("assetChainId");
        String address = LedgerUtil.getRealAddressStr((String)params.get("address"));
        Integer assetId = (Integer)params.get("assetId");
        boolean isConfirmed = false;
        if (null != params.get("isConfirmed")) {
            isConfirmed = Boolean.valueOf(params.get("isConfirmed").toString());
        }
        if (!this.chainHanlder(chainId)) {
            return this.failed(LedgerErrorCode.CHAIN_INIT_FAIL);
        }
        AccountState accountState = this.accountStateService.getAccountStateReCal(address, chainId, assetChainId, assetId);
        HashMap<String, Object> rtMap = new HashMap<String, Object>(6);
        AccountStateUnconfirmed accountStateUnconfirmed = this.unconfirmedStateService.getUnconfirmedInfo(address, chainId, assetChainId, assetId, accountState);
        if (isConfirmed || null == accountStateUnconfirmed) {
            rtMap.put("nonce", RPCUtil.encode((byte[])accountState.getNonce()));
            rtMap.put("nonceType", LedgerConstant.CONFIRMED_NONCE);
            rtMap.put("available", accountState.getAvailableAmount());
        } else {
            rtMap.put("available", accountState.getAvailableAmount().subtract(accountStateUnconfirmed.getAmount()));
            rtMap.put("nonce", RPCUtil.encode((byte[])accountStateUnconfirmed.getNonce()));
            rtMap.put("nonceType", LedgerConstant.UNCONFIRMED_NONCE);
        }
        rtMap.put("freeze", accountState.getFreezeTotal());
        BigInteger permanentLocked = BigInteger.ZERO;
        BigInteger timeHeightLocked = BigInteger.ZERO;
        for (FreezeLockTimeState freezeLockTimeState : accountState.getFreezeLockTimeStates()) {
            if (LedgerUtil.isPermanentLock(freezeLockTimeState.getLockTime())) {
                permanentLocked = permanentLocked.add(freezeLockTimeState.getAmount());
                continue;
            }
            timeHeightLocked = timeHeightLocked.add(freezeLockTimeState.getAmount());
        }
        for (FreezeHeightState freezeHeightState : accountState.getFreezeHeightStates()) {
            timeHeightLocked = timeHeightLocked.add(freezeHeightState.getAmount());
        }
        rtMap.put("permanentLocked", permanentLocked);
        rtMap.put("timeHeightLocked", timeHeightLocked);
        Response response = this.success(rtMap);
        return response;
    }
}

