/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.rpc.cmd;

import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.ledger.rpc.cmd.BaseLedgerCmd;
import io.nuls.ledger.service.AssetRegMngService;
import io.nuls.ledger.utils.LoggerUtil;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
@NulsCoresCmd(module=ModuleE.LG)
public class AssetsRegCmd
extends BaseLedgerCmd {
    @Autowired
    NulsCoresConfig ledgerConfig;
    @Autowired
    AssetRegMngService assetRegMngService;

    @CmdAnnotation(cmd="getAssetRegInfo", version=1.0, description="View registered asset information within the chain")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Run ChainId,Value range[1-65535]"), @Parameter(parameterName="assetType", requestType=@TypeDescriptor(value=int.class), parameterDes="Asset type")})
    @ResponseData(name="Return value", description="Return alistobject", responseType=@TypeDescriptor(value=List.class, collectionElement=Map.class, mapKeys={@Key(name="assetId", valueType=int.class, description="assetid"), @Key(name="assetType", valueType=int.class, description="Asset type"), @Key(name="assetOwnerAddress", valueType=String.class, description="Address of asset owner"), @Key(name="initNumber", valueType=BigInteger.class, description="Asset initialization value"), @Key(name="decimalPlace", valueType=int.class, description="Decimal Division"), @Key(name="assetName", valueType=String.class, description="Asset Name"), @Key(name="assetSymbol", valueType=String.class, description="Asset symbols"), @Key(name="txHash", valueType=String.class, description="transactionhashvalue")}))
    public Response getAssetRegInfo(Map params) {
        HashMap<String, List<Map<String, Object>>> rtMap = new HashMap<String, List<Map<String, Object>>>(1);
        try {
            if (null == params.get("assetType")) {
                params.put("assetType", "0");
            }
            List<Map<String, Object>> assets = this.assetRegMngService.getLedgerRegAssets(Integer.valueOf(params.get("chainId").toString()), Integer.valueOf(params.get("assetType").toString()));
            rtMap.put("assets", assets);
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
            return this.failed(e.getMessage());
        }
        return this.success(rtMap);
    }

    @CmdAnnotation(cmd="getAssetRegInfoByAssetId", version=1.0, description="Through assetsidView registered asset information within the chain")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Run ChainId,Value range[1-65535]"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=String.class), parameterValidRange="[1-65535]", parameterDes="assetid")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="assetId", valueType=int.class, description="assetid"), @Key(name="assetType", valueType=int.class, description="Asset type"), @Key(name="assetOwnerAddress", valueType=String.class, description="Address of asset owner"), @Key(name="initNumber", valueType=BigInteger.class, description="Asset initialization value"), @Key(name="decimalPlace", valueType=int.class, description="Decimal Division"), @Key(name="assetName", valueType=String.class, description="Asset Name"), @Key(name="assetSymbol", valueType=String.class, description="Asset symbols"), @Key(name="txHash", valueType=String.class, description="transactionhashvalue")}))
    public Response getAssetRegInfoByAssetId(Map params) {
        Map<Object, Object> rtMap = new HashMap(1);
        try {
            rtMap = this.assetRegMngService.getLedgerRegAsset((int)Integer.valueOf(params.get("chainId").toString()), Integer.valueOf(params.get("assetId").toString()));
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
            return this.failed(e.getMessage());
        }
        return this.success(rtMap);
    }
}

