/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.rpc.cmd;

import io.nuls.base.basic.AddressTool;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.ledger.model.po.LedgerAsset;
import io.nuls.ledger.rpc.call.CallRpcService;
import io.nuls.ledger.rpc.cmd.BaseLedgerCmd;
import io.nuls.ledger.service.AccountStateService;
import io.nuls.ledger.service.AssetRegMngService;
import io.nuls.ledger.utils.LoggerUtil;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

@Component
@NulsCoresCmd(module=ModuleE.LG)
public class AssetsRegContractCmd
extends BaseLedgerCmd {
    @Autowired
    NulsCoresConfig ledgerConfig;
    @Autowired
    CallRpcService rpcService;
    @Autowired
    AccountStateService accountStateService;
    @Autowired
    AssetRegMngService assetRegMngService;

    @CmdAnnotation(cmd="chainAssetContractReg", version=1.0, description="In chain asset contract registration interface")
    @Parameters(value={@Parameter(parameterName="assetName", requestType=@TypeDescriptor(value=String.class), parameterDes="Asset Name: large\u3001Lowercase letters\u3001number\u3001Underline\uff08The underline cannot be at both ends\uff091~20byte"), @Parameter(parameterName="initNumber", requestType=@TypeDescriptor(value=BigInteger.class), parameterDes="Initial value of assets"), @Parameter(parameterName="decimalPlace", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-18]", parameterDes="The minimum number of split digits for assets"), @Parameter(parameterName="assetSymbol", requestType=@TypeDescriptor(value=String.class), parameterDes="Asset unit symbol: large\u3001Lowercase letters\u3001number\u3001Underline\uff08The underline cannot be at both ends\uff091~20byte"), @Parameter(parameterName="contractAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="New Asset Smart Contract Address")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="chainId", valueType=int.class, description="chainid"), @Key(name="assetId", valueType=int.class, description="assetid")}))
    public Response chainAssetContractReg(Map params) {
        HashMap<String, Integer> rtMap = new HashMap<String, Integer>(3);
        try {
            LoggerUtil.COMMON_LOG.debug("params={}", new Object[]{JSONUtils.obj2json((Object)params)});
            params.put("chainId", this.ledgerConfig.getChainId());
            params.put("address", params.get("contractAddress"));
            LedgerAsset asset = new LedgerAsset();
            asset.map2pojo(params, (short)2);
            int assetId = this.assetRegMngService.registerContractAsset(asset.getChainId(), asset);
            rtMap.put("assetId", assetId);
            rtMap.put("chainId", asset.getChainId());
            LoggerUtil.COMMON_LOG.debug("return={}", new Object[]{JSONUtils.obj2json(rtMap)});
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
            return this.failed(e.getMessage());
        }
        return this.success(rtMap);
    }

    @CmdAnnotation(cmd="chainAssetContractRollBack", version=1.0, description="In chain asset contract registration interface")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="chainId"), @Parameter(parameterName="contractAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="New Asset Smart Contract Address")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=boolean.class, description="successtrue,failfalse")}))
    public Response chainAssetContractRollBack(Map params) {
        HashMap<String, Boolean> rtMap = new HashMap<String, Boolean>(1);
        try {
            this.assetRegMngService.rollBackContractAsset(this.ledgerConfig.getChainId(), params.get("contractAddress").toString());
            rtMap.put("value", true);
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
            return this.failed(e.getMessage());
        }
        return this.success(rtMap);
    }

    @CmdAnnotation(cmd="getAssetContractAddress", version=1.0, description="Asset contract address inquiry")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="chainId"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="assetid")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="contractAddress", valueType=String.class, description="Contract address")}))
    public Response getAssetContractAddress(Map params) {
        HashMap<String, String> rtMap = new HashMap<String, String>(1);
        try {
            String address = this.assetRegMngService.getRegAssetContractAddr(Integer.valueOf(params.get("chainId").toString()), Integer.valueOf(params.get("assetId").toString()));
            rtMap.put("contractAddress", address);
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
            return this.failed(e.getMessage());
        }
        return this.success(rtMap);
    }

    @CmdAnnotation(cmd="getAssetContractAssetId", version=1.0, description="Asset contract assetsIDquery")
    @Parameters(value={@Parameter(parameterName="contractAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="Contract address")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="chainId", valueType=int.class, description="chainId"), @Key(name="assetId", valueType=int.class, description="assetId")}))
    public Response getAssetContractAssetId(Map params) {
        HashMap<String, Integer> rtMap = new HashMap<String, Integer>(2);
        try {
            String address = params.get("contractAddress").toString();
            int chainId = AddressTool.getChainIdByAddress((String)address);
            int assetId = this.assetRegMngService.getRegAssetId(chainId, address);
            rtMap.put("chainId", chainId);
            rtMap.put("assetId", assetId);
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
            return this.failed(e.getMessage());
        }
        return this.success(rtMap);
    }

    @CmdAnnotation(cmd="getAssetContract", version=1.0, description="Contract asset inquiry")
    @Parameters(value={@Parameter(parameterName="contractAddress", requestType=@TypeDescriptor(value=String.class), parameterDes="Contract address")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="assetId", valueType=int.class, description="assetid"), @Key(name="assetType", valueType=int.class, description="Asset type"), @Key(name="assetOwnerAddress", valueType=String.class, description="Address of asset owner"), @Key(name="initNumber", valueType=BigInteger.class, description="Asset initialization value"), @Key(name="decimalPlace", valueType=int.class, description="Decimal Division"), @Key(name="assetName", valueType=String.class, description="Asset Name"), @Key(name="assetSymbol", valueType=String.class, description="Asset symbols")}))
    public Response getAssetRegInfoByAddress(Map params) {
        Map<Object, Object> rtMap = new HashMap(1);
        try {
            String address = params.get("contractAddress").toString();
            int chainId = AddressTool.getChainIdByAddress((String)address);
            int assetId = this.assetRegMngService.getRegAssetId(chainId, address);
            rtMap = this.assetRegMngService.getLedgerRegAsset(chainId, assetId);
            if (null != rtMap) {
                rtMap.remove("txHash");
            }
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
            return this.failed(e.getMessage());
        }
        return this.success(rtMap);
    }
}

