/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.rpc.cmd;

import io.nuls.base.data.Transaction;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.CmdPriority;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.ledger.constant.LedgerErrorCode;
import io.nuls.ledger.model.ValidateResult;
import io.nuls.ledger.rpc.cmd.BaseLedgerCmd;
import io.nuls.ledger.service.TransactionService;
import io.nuls.ledger.service.UnconfirmedStateService;
import io.nuls.ledger.utils.LoggerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
@NulsCoresCmd(module=ModuleE.LG)
public class LgmTransactionCmd
extends BaseLedgerCmd {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UnconfirmedStateService unconfirmedStateService;

    @CmdAnnotation(cmd="commitUnconfirmedTx", version=1.0, description="Unconfirmed transaction submission ledger(Verify and updatenoncevalue)")
    @Parameters(value={@Parameter(parameterName="chainId", parameterType="int", parameterValidRange="[1-65535]", parameterDes="Running ChainId,Value range[1-65535]"), @Parameter(parameterName="tx", parameterType="String", parameterDes="transactionHexvalue")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="orphan", valueType=Boolean.class, description="true Orphan trading,false Non orphan transactions")}))
    public Response commitUnconfirmedTx(Map params) {
        Integer chainId = (Integer)params.get("chainId");
        if (!this.chainHanlder(chainId)) {
            return this.failed(LedgerErrorCode.CHAIN_INIT_FAIL);
        }
        Response response = null;
        try {
            String txStr = params.get("tx").toString();
            Transaction tx = this.parseTxs(txStr, chainId);
            if (null == tx) {
                LoggerUtil.logger(chainId).error("txStr is invalid chainId={},txHex={}", new Object[]{chainId, txStr});
                return this.failed(LedgerErrorCode.TX_IS_WRONG);
            }
            ValidateResult validateResult = this.transactionService.unConfirmTxProcess(chainId, tx);
            HashMap<String, Boolean> rtMap = new HashMap<String, Boolean>(1);
            if (validateResult.isSuccess() || validateResult.isOrphan()) {
                rtMap.put("orphan", validateResult.isOrphan());
                response = this.success(rtMap);
            } else {
                response = this.failed(validateResult.toErrorCode());
                LoggerUtil.logger(chainId).error("####commitUnconfirmedTx chainId={},txHash={},value={}=={}", new Object[]{chainId, tx.getHash().toHex(), validateResult.getValidateCode(), validateResult.getValidateDesc()});
            }
        }
        catch (Exception e) {
            LoggerUtil.logger(chainId).error("commitUnconfirmedTx exception ={}", e);
            return this.failed(LedgerErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        return response;
    }

    @CmdAnnotation(cmd="commitBatchUnconfirmedTxs", version=1.0, description="Unconfirmed transaction batch submission ledger(Verify and updatenoncevalue)")
    @Parameters(value={@Parameter(parameterName="chainId", parameterType="int", parameterValidRange="[1-65535]", parameterDes="Running ChainId,Value range[1-65535]"), @Parameter(parameterName="txList", parameterType="List", parameterDes="[]transactionHexValue List")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="orphan", valueType=List.class, valueElement=String.class, description="Orphan TradingHashlist"), @Key(name="fail", valueType=List.class, valueElement=String.class, description="Verification failed transactionHashlist")}))
    public Response commitBatchUnconfirmedTxs(Map params) {
        Integer chainId = (Integer)params.get("chainId");
        if (!this.chainHanlder(chainId)) {
            return this.failed(LedgerErrorCode.CHAIN_INIT_FAIL);
        }
        try {
            List txStrList = (List)params.get("txList");
            ArrayList<Transaction> txList = new ArrayList<Transaction>();
            Response parseResponse = this.parseTxs(txStrList, txList, chainId);
            if (!parseResponse.isSuccess()) {
                LoggerUtil.logger(chainId).debug("commitBatchUnconfirmedTxs response={}", new Object[]{parseResponse});
                return parseResponse;
            }
            ArrayList<String> orphanList = new ArrayList<String>();
            ArrayList<String> failList = new ArrayList<String>();
            for (Transaction tx : txList) {
                String txHash = tx.getHash().toHex();
                ValidateResult validateResult = this.transactionService.unConfirmTxProcess(chainId, tx);
                if (validateResult.isSuccess()) continue;
                if (validateResult.isOrphan()) {
                    orphanList.add(txHash);
                    continue;
                }
                failList.add(txHash);
            }
            HashMap<String, ArrayList<String>> rtMap = new HashMap<String, ArrayList<String>>(2);
            rtMap.put("fail", failList);
            rtMap.put("orphan", orphanList);
            return this.success(rtMap);
        }
        catch (Exception e) {
            LoggerUtil.logger(chainId).error("commitBatchUnconfirmedTxs exception ={}", e);
            return this.failed(LedgerErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="commitBlockTxs", priority=CmdPriority.HIGH, version=1.0, description="Submit block")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Running ChainId,Value range[1-65535]"), @Parameter(parameterName="txList", requestType=@TypeDescriptor(value=List.class, collectionElement=String.class), parameterDes="transactionHexValue List"), @Parameter(parameterName="blockHeight", requestType=@TypeDescriptor(value=long.class), parameterDes="block height")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Boolean.class, description="true Success,false fail")}))
    public Response commitBlockTxs(Map params) {
        HashMap<String, Boolean> rtData = new HashMap<String, Boolean>(1);
        Integer chainId = (Integer)params.get("chainId");
        if (!this.chainHanlder(chainId)) {
            return this.failed(LedgerErrorCode.CHAIN_INIT_FAIL);
        }
        long blockHeight = Long.valueOf(params.get("blockHeight").toString());
        List txStrList = (List)params.get("txList");
        LoggerUtil.logger(chainId).info("commitBlockTxs chainId={},blockHeight={},txs={}", new Object[]{chainId, blockHeight, txStrList.size()});
        if (null == txStrList || 0 == txStrList.size()) {
            LoggerUtil.logger(chainId).error("txList is blank");
            return this.failed("txList is blank");
        }
        boolean value = false;
        ArrayList<Transaction> txList = new ArrayList<Transaction>();
        Response parseResponse = this.parseTxs(txStrList, txList, chainId);
        if (!parseResponse.isSuccess()) {
            LoggerUtil.logger(chainId).debug("commitBlockTxs response={}", new Object[]{parseResponse});
            return parseResponse;
        }
        if (this.transactionService.confirmBlockProcess(chainId, txList, blockHeight)) {
            value = true;
        }
        rtData.put("value", value);
        Response response = this.success(rtData);
        LoggerUtil.logger(chainId).info("response={}", new Object[]{value});
        return response;
    }

    @CmdAnnotation(cmd="rollBackUnconfirmTx", version=1.0, description="Rollback submitted unconfirmed transactions")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Running ChainId,Value range[1-65535]"), @Parameter(parameterName="tx", requestType=@TypeDescriptor(value=String.class), parameterDes="transactionHexvalue")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Boolean.class, description="true Success,false fail")}))
    public Response rollBackUnconfirmTx(Map params) {
        HashMap<String, Boolean> rtData = new HashMap<String, Boolean>(1);
        boolean value = false;
        Integer chainId = (Integer)params.get("chainId");
        if (!this.chainHanlder(chainId)) {
            return this.failed(LedgerErrorCode.CHAIN_INIT_FAIL);
        }
        try {
            String txStr = params.get("tx").toString();
            Transaction tx = this.parseTxs(txStr, chainId);
            if (null == tx) {
                LoggerUtil.logger(chainId).debug("tx is invalid chainId={},txHex={}", new Object[]{chainId, txStr});
                return this.failed("tx is invalid");
            }
            LoggerUtil.logger(chainId).debug("rollBackUnconfirmTx chainId={},txHash={}", new Object[]{chainId, tx.getHash().toHex()});
            if (this.transactionService.rollBackUnconfirmTx(chainId, tx)) {
                value = true;
            }
        }
        catch (Exception e) {
            LoggerUtil.logger(chainId).error(e);
        }
        rtData.put("value", value);
        Response response = this.success(rtData);
        LoggerUtil.logger(chainId).debug("response={}", new Object[]{rtData.get("value")});
        return response;
    }

    @CmdAnnotation(cmd="clearUnconfirmTxs", version=1.0, description="Clear all unconfirmed transactions from accounts")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Running ChainId,Value range[1-65535]")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Boolean.class, description="true Success,false fail")}))
    public Response clearUnconfirmTxs(Map params) {
        HashMap<String, Boolean> rtData = new HashMap<String, Boolean>(1);
        boolean value = false;
        Integer chainId = (Integer)params.get("chainId");
        if (!this.chainHanlder(chainId)) {
            return this.failed(LedgerErrorCode.CHAIN_INIT_FAIL);
        }
        try {
            LoggerUtil.logger(chainId).debug("clearUnconfirmTxs chainId={}", new Object[]{chainId});
            this.unconfirmedStateService.clearAllAccountUnconfirmed(chainId);
            value = true;
        }
        catch (Exception e) {
            LoggerUtil.logger(chainId).error(e);
        }
        rtData.put("value", value);
        Response response = this.success(rtData);
        LoggerUtil.logger(chainId).debug("response={}", new Object[]{response});
        return response;
    }

    @CmdAnnotation(cmd="rollBackBlockTxs", priority=CmdPriority.HIGH, version=1.0, description="Block rollback")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Running ChainId,Value range[1-65535]"), @Parameter(parameterName="txList", requestType=@TypeDescriptor(value=List.class, collectionElement=String.class), parameterDes="[]transactionHexValue List"), @Parameter(parameterName="blockHeight", parameterType="long", parameterDes="block height")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Boolean.class, description="true Success,false fail")}))
    public Response rollBackBlockTxs(Map params) {
        HashMap<String, Boolean> rtData = new HashMap<String, Boolean>(1);
        boolean value = false;
        Integer chainId = (Integer)params.get("chainId");
        if (!this.chainHanlder(chainId)) {
            return this.failed(LedgerErrorCode.CHAIN_INIT_FAIL);
        }
        try {
            long blockHeight = Long.valueOf(params.get("blockHeight").toString());
            List txStrList = (List)params.get("txList");
            if (null == txStrList || 0 == txStrList.size()) {
                LoggerUtil.logger(chainId).error("txList is blank");
                return this.failed("txList is blank");
            }
            ArrayList<Transaction> txList = new ArrayList<Transaction>();
            Response parseResponse = this.parseTxs(txStrList, txList, chainId);
            if (!parseResponse.isSuccess()) {
                LoggerUtil.logger(chainId).debug("commitBlockTxs response={}", new Object[]{parseResponse});
                return parseResponse;
            }
            LoggerUtil.logger(chainId).debug("rollBackBlockTxs chainId={},blockHeight={},txStrList={}", new Object[]{chainId, blockHeight, txStrList.size()});
            value = this.transactionService.rollBackConfirmTxs(chainId, blockHeight, txList);
        }
        catch (Exception e) {
            LoggerUtil.logger(chainId).error(e);
        }
        rtData.put("value", value);
        Response response = this.success(rtData);
        LoggerUtil.logger(chainId).debug("rollBackBlockTxs response={}", new Object[]{response});
        return response;
    }
}

