/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.service.impl;

import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.rpc.util.NulsDateUtils;
import io.nuls.ledger.model.po.AccountState;
import io.nuls.ledger.model.po.sub.FreezeHeightState;
import io.nuls.ledger.model.po.sub.FreezeLockTimeState;
import io.nuls.ledger.service.FreezeStateService;
import io.nuls.ledger.storage.Repository;
import io.nuls.ledger.utils.LedgerUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

@Component
public class FreezeStateServiceImpl
implements FreezeStateService {
    @Autowired
    Repository repository;

    private BigInteger unFreezeLockTimeState(List<FreezeLockTimeState> timeList, AccountState accountState) {
        long nowTime = NulsDateUtils.getCurrentTimeSeconds();
        long nowTimeMl = NulsDateUtils.getCurrentTimeMillis();
        ArrayList<FreezeLockTimeState> timeRemove = new ArrayList<FreezeLockTimeState>();
        timeList.sort((x, y) -> Long.compare(x.getLockTime(), y.getLockTime()));
        for (FreezeLockTimeState freezeLockTimeState : timeList) {
            if (freezeLockTimeState.getLockTime() > nowTime || LedgerUtil.isPermanentLock(freezeLockTimeState.getLockTime())) continue;
            timeRemove.add(freezeLockTimeState);
        }
        BigInteger addToAmount = BigInteger.ZERO;
        for (FreezeLockTimeState freezeLockTimeState : timeRemove) {
            timeList.remove((Object)freezeLockTimeState);
            addToAmount = addToAmount.add(freezeLockTimeState.getAmount());
        }
        return addToAmount;
    }

    private BigInteger unFreezeLockTimeStateV2(List<FreezeLockTimeState> timeList, AccountState accountState) {
        long nowTime = NulsDateUtils.getCurrentTimeSeconds();
        long nowTimeMl = NulsDateUtils.getCurrentTimeMillis();
        ArrayList<FreezeLockTimeState> timeRemove = new ArrayList<FreezeLockTimeState>();
        timeList.sort((x, y) -> Long.compare(x.getLockTime(), y.getLockTime()));
        for (FreezeLockTimeState freezeLockTimeState : timeList) {
            if (freezeLockTimeState.getLockTime() > nowTime && (freezeLockTimeState.getLockTime() <= 1000000000000L || freezeLockTimeState.getLockTime() > nowTimeMl) || LedgerUtil.isPermanentLock(freezeLockTimeState.getLockTime())) continue;
            timeRemove.add(freezeLockTimeState);
        }
        BigInteger addToAmount = BigInteger.ZERO;
        for (FreezeLockTimeState freezeLockTimeState : timeRemove) {
            timeList.remove((Object)freezeLockTimeState);
            addToAmount = addToAmount.add(freezeLockTimeState.getAmount());
        }
        return addToAmount;
    }

    private BigInteger unFreezeLockHeightState(int addressChainId, List<FreezeHeightState> heightList, AccountState accountState) {
        long nowHeight = this.repository.getBlockHeight(addressChainId);
        ArrayList<FreezeHeightState> heightRemove = new ArrayList<FreezeHeightState>();
        heightList.sort((x, y) -> Long.compare(x.getHeight(), y.getHeight()));
        for (FreezeHeightState freezeHeightState : heightList) {
            if (freezeHeightState.getHeight() > nowHeight) break;
            heightRemove.add(freezeHeightState);
        }
        BigInteger addToAmount = BigInteger.ZERO;
        for (FreezeHeightState freezeHeightState : heightRemove) {
            heightList.remove((Object)freezeHeightState);
            addToAmount = addToAmount.add(freezeHeightState.getAmount());
        }
        return addToAmount;
    }

    @Override
    public boolean recalculateFreeze(int addressChainId, AccountState accountState) {
        List<FreezeLockTimeState> timeList = accountState.getFreezeLockTimeStates();
        List<FreezeHeightState> heightList = accountState.getFreezeHeightStates();
        if (timeList.size() == 0 && heightList.size() == 0) {
            return true;
        }
        BigInteger addTimeAmount = BigInteger.ZERO;
        addTimeAmount = LedgerUtil.getVersion(addressChainId) > 1 ? this.unFreezeLockTimeStateV2(timeList, accountState) : this.unFreezeLockTimeState(timeList, accountState);
        BigInteger addHeightAmount = this.unFreezeLockHeightState(addressChainId, heightList, accountState);
        accountState.addTotalToAmount(addTimeAmount);
        accountState.addTotalToAmount(addHeightAmount);
        return true;
    }
}

