/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.service.impl;

import io.nuls.base.data.Coin;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.Transaction;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.rpc.util.NulsDateUtils;
import io.nuls.ledger.constant.LedgerConstant;
import io.nuls.ledger.constant.LedgerErrorCode;
import io.nuls.ledger.model.AccountBalance;
import io.nuls.ledger.model.Uncfd2CfdKey;
import io.nuls.ledger.model.ValidateResult;
import io.nuls.ledger.model.po.AccountState;
import io.nuls.ledger.model.po.BlockSnapshotAccounts;
import io.nuls.ledger.model.po.TxUnconfirmed;
import io.nuls.ledger.model.po.sub.AccountStateSnapshot;
import io.nuls.ledger.model.po.sub.AmountNonce;
import io.nuls.ledger.service.AccountStateService;
import io.nuls.ledger.service.AssetRegMngService;
import io.nuls.ledger.service.ChainAssetsService;
import io.nuls.ledger.service.FreezeStateService;
import io.nuls.ledger.service.TransactionService;
import io.nuls.ledger.service.UnconfirmedStateService;
import io.nuls.ledger.service.processor.CommontTransactionProcessor;
import io.nuls.ledger.service.processor.LockedTransactionProcessor;
import io.nuls.ledger.storage.LgBlockSyncRepository;
import io.nuls.ledger.storage.Repository;
import io.nuls.ledger.utils.CoinDataUtil;
import io.nuls.ledger.utils.LedgerUtil;
import io.nuls.ledger.utils.LockerUtil;
import io.nuls.ledger.utils.LoggerUtil;
import io.nuls.ledger.validator.CoinDataValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Component
public class TransactionServiceImpl
implements TransactionService {
    @Autowired
    AccountStateService accountStateService;
    @Autowired
    UnconfirmedStateService unconfirmedStateService;
    @Autowired
    CoinDataValidator coinDataValidator;
    @Autowired
    LockedTransactionProcessor lockedTransactionProcessor;
    @Autowired
    CommontTransactionProcessor commontTransactionProcessor;
    @Autowired
    Repository repository;
    @Autowired
    LgBlockSyncRepository lgBlockSyncRepository;
    @Autowired
    FreezeStateService freezeStateService;
    @Autowired
    ChainAssetsService chainAssetsService;
    @Autowired
    AssetRegMngService assetRegMngService;
    private Map<String, Integer> ledgerNonce = new ConcurrentHashMap<String, Integer>(5120);
    private Map<String, Integer> ledgerHash = new ConcurrentHashMap<String, Integer>(5120);

    @Override
    public ValidateResult unConfirmTxProcess(int addressChainId, Transaction transaction) throws Exception {
        CoinData coinData = CoinDataUtil.parseCoinData(transaction.getCoinData());
        if (null == coinData) {
            return ValidateResult.getSuccess();
        }
        if (!this.coinDataValidator.validateTxAmount(coinData, transaction.getType())) {
            return ValidateResult.getResult(LedgerErrorCode.TX_AMOUNT_INVALIDATE, new String[]{transaction.getHash().toHex()});
        }
        ConcurrentHashMap<String, TxUnconfirmed> accountsMap = new ConcurrentHashMap<String, TxUnconfirmed>(8);
        byte[] txNonce = LedgerUtil.getNonceByTx(transaction);
        ValidateResult validateResult = this.coinDataValidator.analysisCoinData(addressChainId, transaction, accountsMap, txNonce);
        if (!validateResult.isSuccess()) {
            return validateResult;
        }
        Set keys = accountsMap.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            TxUnconfirmed txUnconfirmed = (TxUnconfirmed)((Object)accountsMap.get(it.next()));
            ValidateResult updateResult = this.unconfirmedStateService.updateUnconfirmedTx(transaction.getHash().toHex(), addressChainId, txNonce, txUnconfirmed);
            if (updateResult.isSuccess()) continue;
            return updateResult;
        }
        return ValidateResult.getSuccess();
    }

    private boolean confirmBlockTxProcess(long blockHeight, int addressChainId, List<Transaction> txList, Map<String, AccountBalance> updateAccounts, List<Uncfd2CfdKey> delUncfd2CfdKeys, Map<String, Integer> clearUncfs, Map<String, List<String>> assetAddressIndex) throws Exception {
        for (Transaction transaction : txList) {
            AccountBalance accountBalance;
            byte[] nonce8Bytes = LedgerUtil.getNonceByTx(transaction);
            String nonce8Str = LedgerUtil.getNonceEncode(nonce8Bytes);
            String txHash = transaction.getHash().toHex();
            this.ledgerHash.put(txHash, 1);
            CoinData coinData = CoinDataUtil.parseCoinData(transaction.getCoinData());
            if (null == coinData) {
                LoggerUtil.logger(addressChainId).info("txHash = {},coinData is null continue.", new Object[]{txHash});
                continue;
            }
            List froms = coinData.getFrom();
            for (CoinFrom from : froms) {
                boolean process;
                String address = LedgerUtil.getRealAddressStr(from.getAddress());
                if (LedgerUtil.isNotLocalChainAccount(addressChainId, from.getAddress())) {
                    LoggerUtil.logger(addressChainId).info("address={} not localChainAccount", new Object[]{address});
                    if (LedgerUtil.isCrossTx(transaction.getType())) continue;
                    LoggerUtil.logger(addressChainId).error("address={} Not local chain Exception", new Object[]{address});
                    return false;
                }
                if (this.assetRegMngService.isContractAsset(from.getAssetsChainId(), from.getAssetsId())) {
                    LoggerUtil.logger(addressChainId).info("hash={} asset={}-{}  from is contract asset", new Object[]{txHash, from.getAssetsChainId(), from.getAssetsId()});
                    continue;
                }
                accountBalance = this.getAccountBalance(addressChainId, (Coin)from, updateAccounts, address);
                LedgerUtil.dealAssetAddressIndex(assetAddressIndex, from.getAssetsChainId(), from.getAssetsId(), address);
                if (from.getLocked() == 0) {
                    AmountNonce amountNonce = new AmountNonce(from.getNonce(), nonce8Bytes, from.getAmount());
                    accountBalance.getPreAccountState().getNonces().add(amountNonce);
                    String accountKeyStr = LedgerUtil.getKeyStr(address, from.getAssetsChainId(), from.getAssetsId());
                    if (this.unconfirmedStateService.existTxUnconfirmedTx(addressChainId, accountKeyStr, nonce8Str)) {
                        delUncfd2CfdKeys.add(new Uncfd2CfdKey(accountKeyStr, nonce8Str));
                    } else {
                        clearUncfs.put(accountKeyStr, 1);
                    }
                    process = this.commontTransactionProcessor.processFromCoinData(from, nonce8Bytes, accountBalance.getNowAccountState());
                    this.ledgerNonce.put(LedgerUtil.getAccountNoncesStrKey(address, from.getAssetsChainId(), from.getAssetsId(), nonce8Str), 1);
                } else {
                    process = this.lockedTransactionProcessor.processCoinData((Coin)from, nonce8Bytes, txHash, accountBalance.getNowAccountState(), transaction.getTime(), address, true);
                }
                if (process) continue;
                LoggerUtil.logger(addressChainId).error("address={},txHash = {} processFromCoinData is fail.", new Object[]{addressChainId, transaction.getHash().toHex()});
                return false;
            }
            List tos = coinData.getTo();
            for (CoinTo to : tos) {
                String address = LedgerUtil.getRealAddressStr(to.getAddress());
                if (LedgerUtil.isNotLocalChainAccount(addressChainId, to.getAddress())) {
                    LoggerUtil.logger(addressChainId).info("address={} not localChainAccount", new Object[]{address});
                    if (LedgerUtil.isCrossTx(transaction.getType())) continue;
                    LoggerUtil.logger(addressChainId).error("address={} Not local chain Exception", new Object[]{address});
                    return false;
                }
                if (this.assetRegMngService.isContractAsset(to.getAssetsChainId(), to.getAssetsId())) {
                    LoggerUtil.logger(addressChainId).info("hash={} asset={}-{} rec contract asset", new Object[]{txHash, to.getAssetsChainId(), to.getAssetsId()});
                    continue;
                }
                accountBalance = this.getAccountBalance(addressChainId, (Coin)to, updateAccounts, address);
                LedgerUtil.dealAssetAddressIndex(assetAddressIndex, to.getAssetsChainId(), to.getAssetsId(), address);
                if (to.getLockTime() == 0L) {
                    this.commontTransactionProcessor.processToCoinData(to, accountBalance.getNowAccountState());
                    continue;
                }
                this.lockedTransactionProcessor.processCoinData((Coin)to, nonce8Bytes, txHash, accountBalance.getNowAccountState(), transaction.getTime(), address, false);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean confirmBlockProcess(int addressChainId, List<Transaction> txList, long blockHeight) {
        try {
            HashMap<String, List<String>> assetAddressIndex;
            HashMap<String, Integer> clearUncfs;
            ArrayList<Uncfd2CfdKey> delUncfd2CfdKeys;
            HashMap<byte[], byte[]> accountStatesMap;
            BlockSnapshotAccounts blockSnapshotAccounts;
            HashMap<String, AccountState> updateMemAccounts;
            HashMap<String, AccountBalance> updateAccounts;
            block19: {
                this.cleanBlockCommitTempDatas();
                LockerUtil.LEDGER_LOCKER.lock();
                long currentDbHeight = this.repository.getBlockHeight(addressChainId);
                if (blockHeight - currentDbHeight != 1L) {
                    LoggerUtil.logger(addressChainId).error("addressChainId ={},blockHeight={},ledgerBlockHeight={}", new Object[]{addressChainId, blockHeight, currentDbHeight});
                    boolean bl = false;
                    return bl;
                }
                int accountMapSize = txList.size() * 3;
                updateAccounts = new HashMap<String, AccountBalance>(accountMapSize);
                updateMemAccounts = new HashMap<String, AccountState>(accountMapSize);
                blockSnapshotAccounts = new BlockSnapshotAccounts();
                accountStatesMap = new HashMap<byte[], byte[]>(accountMapSize);
                delUncfd2CfdKeys = new ArrayList<Uncfd2CfdKey>();
                clearUncfs = new HashMap<String, Integer>(txList.size());
                assetAddressIndex = new HashMap<String, List<String>>(4);
                if (this.confirmBlockTxProcess(blockHeight, addressChainId, txList, updateAccounts, delUncfd2CfdKeys, clearUncfs, assetAddressIndex)) break block19;
                boolean bl = false;
                return bl;
            }
            try {
                for (Map.Entry entry : updateAccounts.entrySet()) {
                    blockSnapshotAccounts.addAccountState(((AccountBalance)entry.getValue()).getPreAccountState());
                    this.freezeStateService.recalculateFreeze(addressChainId, ((AccountBalance)entry.getValue()).getNowAccountState());
                    ((AccountBalance)entry.getValue()).getNowAccountState().setLatestUnFreezeTime(NulsDateUtils.getCurrentTimeSeconds());
                    accountStatesMap.put(((String)entry.getKey()).getBytes(LedgerConstant.DEFAULT_ENCODING), ((AccountBalance)entry.getValue()).getNowAccountState().serialize());
                    updateMemAccounts.put((String)entry.getKey(), ((AccountBalance)entry.getValue()).getNowAccountState());
                }
            }
            catch (Exception e) {
                LoggerUtil.logger(addressChainId).error("confirmBlockProcess blockSnapshotAccounts addAccountState error!");
                LoggerUtil.logger(addressChainId).error(e);
                this.cleanBlockCommitTempDatas();
                boolean entry = false;
                LockerUtil.LEDGER_LOCKER.unlock();
                return entry;
            }
            try {
                this.repository.saveBlockSnapshot(addressChainId, blockHeight, blockSnapshotAccounts);
                this.chainAssetsService.updateChainAssets(addressChainId, assetAddressIndex);
                if (accountStatesMap.size() > 0) {
                    this.repository.batchUpdateAccountState(addressChainId, accountStatesMap, updateMemAccounts);
                }
                for (Map.Entry entry : clearUncfs.entrySet()) {
                    this.unconfirmedStateService.clearAccountUnconfirmed(addressChainId, (String)entry.getKey());
                }
                this.unconfirmedStateService.batchDeleteUnconfirmedTx(addressChainId, delUncfd2CfdKeys);
                if (blockHeight > 1000L) {
                    this.repository.delBlockSnapshot(addressChainId, blockHeight - 1000L);
                }
            }
            catch (Exception e) {
                this.cleanBlockCommitTempDatas();
                LoggerUtil.logger(addressChainId).error(e);
                LoggerUtil.logger(addressChainId).error("confirmBlockProcess  error! go rollBackBlock!addrChainId={},height={}", new Object[]{addressChainId, blockHeight});
                this.rollBackBlock(addressChainId, blockSnapshotAccounts.getAccounts(), blockHeight);
                boolean bl = false;
                LockerUtil.LEDGER_LOCKER.unlock();
                return bl;
            }
            this.repository.saveOrUpdateBlockHeight(addressChainId, blockHeight);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LoggerUtil.logger(addressChainId).error("confirmBlockProcess error", e);
            this.cleanBlockCommitTempDatas();
            boolean bl = false;
            return bl;
        }
        finally {
            LockerUtil.LEDGER_LOCKER.unlock();
        }
    }

    private AccountBalance getAccountBalance(int addressChainId, Coin coin, Map<String, AccountBalance> updateAccounts, String address) {
        int assetId;
        int assetChainId = coin.getAssetsChainId();
        String key = LedgerUtil.getKeyStr(address, assetChainId, assetId = coin.getAssetsId());
        AccountBalance accountBalance = updateAccounts.get(key);
        if (null == accountBalance) {
            AccountState accountState = this.accountStateService.getAccountStateReCal(address, addressChainId, assetChainId, assetId);
            AccountStateSnapshot bakAccountState = new AccountStateSnapshot(addressChainId, assetChainId, assetId, address, accountState.deepClone());
            accountBalance = new AccountBalance(accountState, bakAccountState);
            updateAccounts.put(key, accountBalance);
        }
        return accountBalance;
    }

    @Override
    public synchronized boolean rollBackBlock(int addressChainId, List<AccountStateSnapshot> preAccountStates, long blockHeight) {
        try {
            this.accountStateService.rollAccountState(addressChainId, preAccountStates);
            this.repository.delBlockSnapshot(addressChainId, blockHeight);
        }
        catch (Exception e) {
            LoggerUtil.logger(addressChainId).error("rollBackBlock error!!", e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rollBackConfirmTxs(int addressChainId, long blockHeight, List<Transaction> txs) {
        try {
            LockerUtil.LEDGER_LOCKER.lock();
            this.cleanBlockCommitTempDatas();
            long currentDbHeight = this.repository.getBlockHeight(addressChainId);
            if (blockHeight - currentDbHeight == 1L) {
                LoggerUtil.logger(addressChainId).debug("addressChainId ={},blockHeight={},ledgerBlockHeight={}", new Object[]{addressChainId, blockHeight, currentDbHeight});
                boolean bl = true;
                return bl;
            }
            if (blockHeight != currentDbHeight) {
                LoggerUtil.logger(addressChainId).error("addressChainId ={},blockHeight={},ledgerBlockHeight={}", new Object[]{addressChainId, blockHeight, currentDbHeight});
                boolean bl = false;
                return bl;
            }
            BlockSnapshotAccounts blockSnapshotAccounts = this.repository.getBlockSnapshot(addressChainId, blockHeight);
            if (null == blockSnapshotAccounts) {
                LoggerUtil.logger(addressChainId).error("addressChainId ={},blockHeight={},blockSnapshotAccounts is null.", new Object[]{addressChainId, blockHeight});
                boolean bl = false;
                return bl;
            }
            this.repository.saveOrUpdateBlockHeight(addressChainId, blockHeight - 1L);
            List<AccountStateSnapshot> preAccountStates = blockSnapshotAccounts.getAccounts();
            this.accountStateService.rollAccountState(addressChainId, preAccountStates);
            this.repository.delBlockSnapshot(addressChainId, blockHeight);
            txs.forEach(tx -> {
                String txHash = tx.getHash().toHex();
                CoinData coinData = CoinDataUtil.parseCoinData(tx.getCoinData());
                try {
                    this.lgBlockSyncRepository.deleteAccountHash(addressChainId, txHash);
                }
                catch (Exception e) {
                    LoggerUtil.logger(addressChainId).error(e);
                }
                if (null != coinData) {
                    String nonce8BytesStr = LedgerUtil.getNonceEncodeByTx(tx);
                    List froms = coinData.getFrom();
                    for (CoinFrom from : froms) {
                        if (LedgerUtil.isNotLocalChainAccount(addressChainId, from.getAddress()) || from.getLocked() != 0) continue;
                        try {
                            this.lgBlockSyncRepository.deleteAccountNonces(addressChainId, LedgerUtil.getAccountNoncesStrKey(LedgerUtil.getRealAddressStr(from.getAddress()), from.getAssetsChainId(), from.getAssetsId(), nonce8BytesStr));
                        }
                        catch (Exception e) {
                            LoggerUtil.logger(addressChainId).error(e);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            LoggerUtil.logger(addressChainId).error("rollBackConfirmTxs error!!", e);
            this.repository.saveOrUpdateBlockHeight(addressChainId, blockHeight);
            boolean bl = false;
            return bl;
        }
        finally {
            LockerUtil.LEDGER_LOCKER.unlock();
        }
        return true;
    }

    @Override
    public boolean rollBackUnconfirmTx(int addressChainId, Transaction transaction) {
        CoinData coinData = CoinDataUtil.parseCoinData(transaction.getCoinData());
        if (null == coinData) {
            return true;
        }
        List froms = coinData.getFrom();
        String txHash = transaction.getHash().toHex();
        for (CoinFrom from : froms) {
            if (LedgerUtil.isNotLocalChainAccount(addressChainId, from.getAddress())) {
                if (LedgerUtil.isCrossTx(transaction.getType())) continue;
                LoggerUtil.logger(addressChainId).error("address={} Not local chain Exception", new Object[]{LedgerUtil.getRealAddressStr(from.getAddress())});
                return false;
            }
            String address = LedgerUtil.getRealAddressStr(from.getAddress());
            int assetChainId = from.getAssetsChainId();
            int assetId = from.getAssetsId();
            String assetKey = LedgerUtil.getKeyStr(address, assetChainId, assetId);
            return this.unconfirmedStateService.rollUnconfirmedTx(addressChainId, assetKey, txHash);
        }
        return true;
    }

    private void cleanBlockCommitTempDatas() {
        this.ledgerNonce.clear();
        this.ledgerHash.clear();
    }

    @Override
    public boolean fromNonceExist(int addressChainId, String accountNonceKey) throws Exception {
        return this.ledgerNonce.containsKey(accountNonceKey);
    }

    @Override
    public boolean hadTxExist(int addressChainId, String hash) throws Exception {
        return this.ledgerHash.containsKey(hash);
    }
}

