/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.service.impl;

import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.rpc.util.NulsDateUtils;
import io.nuls.ledger.constant.LedgerErrorCode;
import io.nuls.ledger.model.Uncfd2CfdKey;
import io.nuls.ledger.model.ValidateResult;
import io.nuls.ledger.model.po.AccountState;
import io.nuls.ledger.model.po.AccountStateUnconfirmed;
import io.nuls.ledger.model.po.TxUnconfirmed;
import io.nuls.ledger.service.AccountStateService;
import io.nuls.ledger.service.UnconfirmedStateService;
import io.nuls.ledger.storage.Repository;
import io.nuls.ledger.storage.UnconfirmedRepository;
import io.nuls.ledger.utils.LedgerUtil;
import io.nuls.ledger.utils.LockerUtil;
import io.nuls.ledger.utils.LoggerUtil;
import java.util.List;
import java.util.Map;

@Component
public class UnconfirmedStateServiceImpl
implements UnconfirmedStateService {
    @Autowired
    private Repository repository;
    @Autowired
    private AccountStateService accountStateService;
    @Autowired
    private UnconfirmedRepository unconfirmedRepository;

    @Override
    public AccountStateUnconfirmed getUnconfirmedInfo(String address, int addressChainId, int assetChainId, int assetId, AccountState accountState) {
        String key = LedgerUtil.getKeyStr(address, assetChainId, assetId);
        AccountStateUnconfirmed accountStateUnconfirmed = this.unconfirmedRepository.getMemAccountStateUnconfirmed(addressChainId, key);
        if (null != accountStateUnconfirmed && !accountStateUnconfirmed.isOverTime()) {
            if (LedgerUtil.equalsNonces(accountState.getNonce(), accountStateUnconfirmed.getNonce())) {
                return null;
            }
        } else {
            return null;
        }
        return accountStateUnconfirmed;
    }

    @Override
    public AccountStateUnconfirmed getUnconfirmedInfoAndClear(String address, int addressChainId, int assetChainId, int assetId, AccountState accountState) {
        String key = LedgerUtil.getKeyStr(address, assetChainId, assetId);
        AccountStateUnconfirmed accountStateUnconfirmed = this.unconfirmedRepository.getMemAccountStateUnconfirmed(addressChainId, key);
        if (null != accountStateUnconfirmed) {
            if (accountStateUnconfirmed.isOverTime()) {
                try {
                    this.clearAccountUnconfirmed(addressChainId, key);
                    return null;
                }
                catch (Exception e) {
                    LoggerUtil.logger(addressChainId).error(e);
                }
            } else if (LedgerUtil.equalsNonces(accountState.getNonce(), accountStateUnconfirmed.getNonce())) {
                return null;
            }
        } else {
            return null;
        }
        return accountStateUnconfirmed;
    }

    @Override
    public AccountStateUnconfirmed getUnconfirmedJustNonce(String address, int addressChainId, int assetChainId, int assetId, AccountState accountState) {
        String key = LedgerUtil.getKeyStr(address, assetChainId, assetId);
        AccountStateUnconfirmed accountStateUnconfirmed = this.unconfirmedRepository.getMemAccountStateUnconfirmed(addressChainId, key);
        if (null != accountStateUnconfirmed && !accountStateUnconfirmed.isOverTime()) {
            if (LedgerUtil.equalsNonces(accountState.getNonce(), accountStateUnconfirmed.getNonce())) {
                return null;
            }
            return accountStateUnconfirmed;
        }
        return null;
    }

    @Override
    public void mergeUnconfirmedNonce(int addressChainId, AccountState accountState, String assetKey, Map<String, TxUnconfirmed> txsUnconfirmed, AccountStateUnconfirmed accountStateUnconfirmed) {
        try {
            AccountStateUnconfirmed accountStateUnconfirmedDB = this.unconfirmedRepository.getMemAccountStateUnconfirmed(addressChainId, assetKey);
            if (null != accountStateUnconfirmedDB && accountStateUnconfirmedDB.isOverTime()) {
                this.unconfirmedRepository.delMemAccountStateUnconfirmed(addressChainId, assetKey);
                this.unconfirmedRepository.clearMemUnconfirmedTxs(addressChainId, assetKey);
                accountStateUnconfirmedDB = null;
            }
            if (null == accountStateUnconfirmedDB) {
                this.unconfirmedRepository.saveMemAccountStateUnconfirmed(addressChainId, assetKey, accountStateUnconfirmed);
            } else {
                accountStateUnconfirmedDB.setUnconfirmedAmount(accountStateUnconfirmedDB.getUnconfirmedAmount().add(accountStateUnconfirmed.getUnconfirmedAmount()));
            }
            this.unconfirmedRepository.saveMemUnconfirmedTxs(addressChainId, assetKey, txsUnconfirmed);
        }
        catch (Exception e) {
            LoggerUtil.logger(addressChainId).error("@@@@mergeUnconfirmedNonce exception");
        }
    }

    @Override
    public boolean rollUnconfirmedTx(int addressChainId, String assetKey, String txHash) {
        AccountStateUnconfirmed accountStateUnconfirmed = this.unconfirmedRepository.getMemAccountStateUnconfirmed(addressChainId, assetKey);
        try {
            if (null != accountStateUnconfirmed && LedgerUtil.equalsNonces(accountStateUnconfirmed.getNonce(), LedgerUtil.getNonceDecodeByTxHash(txHash))) {
                TxUnconfirmed preTxUnconfirmed = this.unconfirmedRepository.getMemUnconfirmedTx(addressChainId, assetKey, LedgerUtil.getNonceEncode(accountStateUnconfirmed.getFromNonce()));
                TxUnconfirmed nowTxUnconfirmed = this.unconfirmedRepository.getMemUnconfirmedTx(addressChainId, assetKey, LedgerUtil.getNonceEncode(accountStateUnconfirmed.getNonce()));
                if (null != preTxUnconfirmed && null != nowTxUnconfirmed) {
                    System.arraycopy(preTxUnconfirmed.getNonce(), 0, accountStateUnconfirmed.getNonce(), 0, 8);
                    System.arraycopy(preTxUnconfirmed.getFromNonce(), 0, accountStateUnconfirmed.getFromNonce(), 0, 8);
                    accountStateUnconfirmed.setUnconfirmedAmount(accountStateUnconfirmed.getUnconfirmedAmount().subtract(nowTxUnconfirmed.getAmount()));
                    accountStateUnconfirmed.setCreateTime(NulsDateUtils.getCurrentTimeSeconds());
                } else {
                    this.unconfirmedRepository.delMemAccountStateUnconfirmed(addressChainId, assetKey);
                }
            }
            TxUnconfirmed txUnconfirmed = this.unconfirmedRepository.getMemUnconfirmedTx(addressChainId, assetKey, LedgerUtil.getNonceEncodeByTxHash(txHash));
            this.unconfirmedRepository.clearMemUnconfirmedTxs(addressChainId, assetKey, txUnconfirmed);
        }
        catch (Exception e) {
            LoggerUtil.logger(addressChainId).error("@@@@rollUnconfirmTx exception assetKey={},txHash={}", new Object[]{assetKey, txHash});
            LoggerUtil.logger(addressChainId).error(e);
            return false;
        }
        return true;
    }

    @Override
    public boolean existTxUnconfirmedTx(int addressChainId, String assetKey, String nonce) throws Exception {
        TxUnconfirmed txUnconfirmed = this.unconfirmedRepository.getMemUnconfirmedTx(addressChainId, assetKey, nonce);
        if (null != txUnconfirmed) {
            this.unconfirmedRepository.addUncfd2Cfd(addressChainId, assetKey, txUnconfirmed.getAmount());
        }
        return txUnconfirmed != null;
    }

    @Override
    public void clearAccountUnconfirmed(int addressChainId, String accountKey) throws Exception {
        this.unconfirmedRepository.delMemAccountStateUnconfirmed(addressChainId, accountKey);
        this.unconfirmedRepository.clearMemUnconfirmedTxs(addressChainId, accountKey);
    }

    @Override
    public void clearAllAccountUnconfirmed(int addressChainId) throws Exception {
        LockerUtil.UNCONFIRMED_SYNC_LOCKER.lock();
        try {
            this.unconfirmedRepository.clearAllMemUnconfirmedTxs(addressChainId);
        }
        finally {
            LockerUtil.UNCONFIRMED_SYNC_LOCKER.unlock();
        }
    }

    @Override
    public void batchDeleteUnconfirmedTx(int addressChainId, List<Uncfd2CfdKey> keys) throws Exception {
        for (Uncfd2CfdKey uncfd2CfdKey : keys) {
            this.unconfirmedRepository.delMemUnconfirmedTx(addressChainId, uncfd2CfdKey.getAssetKey(), uncfd2CfdKey.getNonceKey());
        }
    }

    @Override
    public ValidateResult updateUnconfirmedTx(String txHash, int addressChainId, byte[] txNonce, TxUnconfirmed txUnconfirmed) {
        String keyStr = LedgerUtil.getKeyStr(txUnconfirmed.getAddress(), txUnconfirmed.getAssetChainId(), txUnconfirmed.getAssetId());
        AccountState accountState = this.accountStateService.getAccountState(txUnconfirmed.getAddress(), addressChainId, txUnconfirmed.getAssetChainId(), txUnconfirmed.getAssetId());
        AccountStateUnconfirmed accountStateUnconfirmed = this.getUnconfirmedInfoAndClear(txUnconfirmed.getAddress(), addressChainId, txUnconfirmed.getAssetChainId(), txUnconfirmed.getAssetId(), accountState);
        byte[] preNonce = null;
        preNonce = null == accountStateUnconfirmed ? accountState.getNonce() : accountStateUnconfirmed.getNonce();
        if (!LedgerUtil.equalsNonces(txUnconfirmed.getFromNonce(), preNonce)) {
            return ValidateResult.getResult(LedgerErrorCode.VALIDATE_FAIL, new String[]{txUnconfirmed.getAddress(), LedgerUtil.getNonceEncode(txUnconfirmed.getFromNonce()), "account lastNonce=" + LedgerUtil.getNonceEncode(preNonce)});
        }
        if (null == accountStateUnconfirmed) {
            accountStateUnconfirmed = new AccountStateUnconfirmed(txUnconfirmed.getFromNonce(), txUnconfirmed.getNonce(), txUnconfirmed.getAmount());
            this.unconfirmedRepository.saveMemAccountStateUnconfirmed(addressChainId, keyStr, accountStateUnconfirmed);
        } else {
            System.arraycopy(txUnconfirmed.getFromNonce(), 0, accountStateUnconfirmed.getFromNonce(), 0, 8);
            System.arraycopy(txUnconfirmed.getNonce(), 0, accountStateUnconfirmed.getNonce(), 0, 8);
            accountStateUnconfirmed.setUnconfirmedAmount(accountStateUnconfirmed.getUnconfirmedAmount().add(txUnconfirmed.getAmount()));
            accountStateUnconfirmed.setCreateTime(NulsDateUtils.getCurrentTimeSeconds());
        }
        try {
            TxUnconfirmed preTxUnconfirmed = this.unconfirmedRepository.getMemUnconfirmedTx(addressChainId, keyStr, LedgerUtil.getNonceEncode(txUnconfirmed.getFromNonce()));
            if (null != preTxUnconfirmed) {
                System.arraycopy(txUnconfirmed.getNonce(), 0, preTxUnconfirmed.getNextNonce(), 0, 8);
            }
            this.unconfirmedRepository.saveMemUnconfirmedTx(addressChainId, keyStr, LedgerUtil.getNonceEncode(txNonce), txUnconfirmed);
        }
        catch (Exception e) {
            LoggerUtil.logger(addressChainId).error(e);
            return ValidateResult.getResult(LedgerErrorCode.VALIDATE_FAIL, new String[]{txUnconfirmed.getAddress(), LedgerUtil.getNonceEncode(txUnconfirmed.getFromNonce()), "updateUnconfirmTx exception"});
        }
        return ValidateResult.getSuccess();
    }
}

