/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.service.v5;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.TransactionProcessor;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.ledger.constant.LedgerErrorCode;
import io.nuls.ledger.model.po.LedgerAsset;
import io.nuls.ledger.model.tx.txdata.TxLedgerAsset;
import io.nuls.ledger.service.AssetRegMngService;
import io.nuls.ledger.utils.LoggerUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component(value="AssetRegTransferProcessorV5")
public class AssetRegTransferProcessor
implements TransactionProcessor {
    @Autowired
    private AssetRegMngService assetRegMngService;

    public int getType() {
        return 27;
    }

    private LedgerAsset buildLedgerAssetByTx(Transaction tx, int chainId) throws NulsException {
        String txHash = tx.getHash().toHex();
        TxLedgerAsset txLedgerAsset = new TxLedgerAsset();
        txLedgerAsset.parse(tx.getTxData(), 0);
        byte[] stream = tx.getCoinData();
        CoinData coinData = new CoinData();
        coinData.parse(new NulsByteBuffer(stream));
        List coinTos = coinData.getTo();
        List coinFroms = coinData.getFrom();
        byte[] fromAddress = null;
        BigInteger destroyAsset = ((CoinTo)coinTos.get(0)).getAmount();
        fromAddress = ((CoinFrom)coinFroms.get(0)).getAddress();
        LedgerAsset asset = new LedgerAsset(txLedgerAsset, chainId, destroyAsset, txHash, tx.getTime(), fromAddress, 1);
        return asset;
    }

    public Map<String, Object> validate(int chainId, List<Transaction> txs, Map<Integer, List<Transaction>> txMap, BlockHeader blockHeader) {
        ArrayList<Transaction> errorList = new ArrayList<Transaction>();
        HashMap<String, Object> rtData = new HashMap<String, Object>(2);
        rtData.put("errorCode", "");
        rtData.put("txList", errorList);
        try {
            HashMap assetMap = new HashMap();
            for (Transaction tx : txs) {
                String txHash = tx.getHash().toHex();
                TxLedgerAsset txLedgerAsset = new TxLedgerAsset();
                txLedgerAsset.parse(tx.getTxData(), 0);
                byte[] stream = tx.getCoinData();
                CoinData coinData = new CoinData();
                coinData.parse(new NulsByteBuffer(stream));
                List coinTos = coinData.getTo();
                List coinFroms = coinData.getFrom();
                BigInteger destroyAsset = BigInteger.ZERO;
                byte[] toAddress = null;
                byte[] fromAddress = null;
                if (coinTos.size() != 1) {
                    rtData.put("errorCode", LedgerErrorCode.TX_IS_WRONG);
                    errorList.add(tx);
                    continue;
                }
                destroyAsset = ((CoinTo)coinTos.get(0)).getAmount();
                toAddress = ((CoinTo)coinTos.get(0)).getAddress();
                if (coinFroms.size() != 1) {
                    rtData.put("errorCode", LedgerErrorCode.TX_IS_WRONG);
                    errorList.add(tx);
                    continue;
                }
                fromAddress = ((CoinFrom)coinFroms.get(0)).getAddress();
                ErrorCode errorCode = this.assetRegMngService.batchAssetRegValidator(txLedgerAsset, toAddress, destroyAsset, chainId);
                if (null == errorCode) {
                    LoggerUtil.COMMON_LOG.debug("txHash = {},reg batchValidate success!", new Object[]{txHash});
                    continue;
                }
                rtData.put("errorCode", errorCode.getCode());
                LoggerUtil.COMMON_LOG.error("txHash = {},reg batchValidate fail!", new Object[]{txHash});
                errorList.add(tx);
            }
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
            throw new RuntimeException(e);
        }
        return rtData;
    }

    public boolean commit(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        ArrayList<LedgerAsset> assets = new ArrayList<LedgerAsset>();
        try {
            for (Transaction tx : txs) {
                LedgerAsset asset = this.buildLedgerAssetByTx(tx, chainId);
                assets.add(asset);
            }
            this.assetRegMngService.registerTxAssets(chainId, assets);
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
            return false;
        }
        return true;
    }

    public boolean rollback(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        try {
            ArrayList<LedgerAsset> list = new ArrayList<LedgerAsset>();
            for (Transaction tx : txs) {
                LedgerAsset ledgerAsset = this.buildLedgerAssetByTx(tx, chainId);
                list.add(ledgerAsset);
            }
            this.assetRegMngService.rollBackTxAssets(chainId, list);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

