/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.storage.impl;

import io.nuls.common.NulsCoresConfig;
import io.nuls.core.basic.InitializingBean;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.ByteUtils;
import io.nuls.core.rockdb.manager.RocksDBManager;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.ledger.storage.AccountIndexRepository;
import io.nuls.ledger.utils.LoggerUtil;
import java.io.File;
import java.util.List;
import java.util.Map;

@Component
public class AccountIndexRepositoryImpl
implements AccountIndexRepository,
InitializingBean {
    @Autowired
    private NulsCoresConfig config;

    String getLedgerAssetIndexTableName(int chainId) {
        return "ledger_asset_index_" + chainId;
    }

    String getLedgerAddressIndexTableName(int addressChainId, int assetChainId, int assetId) {
        return "ledger_asset_addr_index_" + addressChainId + "_" + assetChainId + "_" + assetId;
    }

    public String initAssetsIndexDb(int addressChainId) {
        String table = this.getLedgerAssetIndexTableName(addressChainId);
        try {
            RocksDBManager.setDataPath((String)(this.config.getDataPath() + File.separator + ModuleE.LG.name));
            if (!RocksDBService.existTable((String)table)) {
                RocksDBService.createTable((String)table);
            }
        }
        catch (Exception e) {
            LoggerUtil.logger(addressChainId).error(e);
        }
        return table;
    }

    public String initLedgerAddressIndexDb(int addressChainId, int assetChainId, int assetId) {
        String table = this.getLedgerAddressIndexTableName(addressChainId, assetChainId, assetId);
        try {
            RocksDBManager.setDataPath((String)(this.config.getDataPath() + File.separator + ModuleE.LG.name));
            if (!RocksDBService.existTable((String)table)) {
                RocksDBService.createTable((String)table);
            }
        }
        catch (Exception e) {
            LoggerUtil.logger(addressChainId).error(e);
        }
        return table;
    }

    @Override
    public void updateAssetsIndex(int addressChainId, byte[] key, byte[] value) {
        String table = this.initAssetsIndexDb(addressChainId);
        try {
            RocksDBService.put((String)table, (byte[])key, (byte[])value);
        }
        catch (Exception e) {
            LoggerUtil.logger(addressChainId).error(e);
        }
    }

    @Override
    public void updateAssetsAddressIndex(int addressChainId, int assetChainId, int assetId, byte[] addressKey, byte[] value) {
        String table = this.initLedgerAddressIndexDb(addressChainId, assetChainId, assetId);
        try {
            RocksDBService.put((String)table, (byte[])addressKey, (byte[])value);
        }
        catch (Exception e) {
            LoggerUtil.logger(addressChainId).error(e);
        }
    }

    @Override
    public void updateAssetsAddressIndex(int addressChainId, int assetChainId, int assetId, Map<byte[], byte[]> kvs) {
        String table = this.initLedgerAddressIndexDb(addressChainId, assetChainId, assetId);
        try {
            RocksDBService.batchPut((String)table, kvs);
        }
        catch (Exception e) {
            LoggerUtil.logger(addressChainId).error(e);
        }
    }

    @Override
    public List<String> assetsKeyList(int addressChainId) {
        String table = this.initAssetsIndexDb(addressChainId);
        List assetKeys = RocksDBService.keyList((String)table);
        return ByteUtils.bytesToStrings((List)assetKeys);
    }

    @Override
    public List<String> assetsAddressKeyList(int addressChainId, int assetChainId, int assetId) {
        String table = this.initLedgerAddressIndexDb(addressChainId, assetChainId, assetId);
        List assetKeys = RocksDBService.keyList((String)table);
        return ByteUtils.bytesToStrings((List)assetKeys);
    }

    public void afterPropertiesSet() throws NulsException {
    }
}

