/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.storage.impl;

import io.nuls.common.NulsCoresConfig;
import io.nuls.core.basic.InitializingBean;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.ByteUtils;
import io.nuls.core.rockdb.manager.RocksDBManager;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.ledger.model.po.LedgerAsset;
import io.nuls.ledger.storage.AssetRegMngRepository;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Component
public class AssetRegMngRepositoryImpl
implements AssetRegMngRepository,
InitializingBean {
    @Autowired
    private NulsCoresConfig config;
    Map<String, Integer> DB_CONTRACT_ASSETS_IDS_MAP = new ConcurrentHashMap<String, Integer>();

    String getLedgerAssetRegMngTableName(int chainId) throws Exception {
        String tableName = "ledger_asset_reg_mng_" + chainId;
        RocksDBManager.setDataPath((String)(this.config.getDataPath() + File.separator + ModuleE.LG.name));
        if (!RocksDBService.existTable((String)tableName)) {
            RocksDBService.createTable((String)tableName);
        }
        return tableName;
    }

    String getLedgerAssetRegHashIndexTableName(int chainId) throws Exception {
        String tableName = "ledger_asset_reg_hash_index_" + chainId;
        RocksDBManager.setDataPath((String)(this.config.getDataPath() + File.separator + ModuleE.LG.name));
        if (!RocksDBService.existTable((String)tableName)) {
            RocksDBService.createTable((String)tableName);
        }
        return tableName;
    }

    String getLedgerAssetRegContractAddrIndexTableName(int chainId) throws Exception {
        String tableName = "ledger_asset_reg_contract_index_" + chainId;
        RocksDBManager.setDataPath((String)(this.config.getDataPath() + File.separator + ModuleE.LG.name));
        if (!RocksDBService.existTable((String)tableName)) {
            RocksDBService.createTable((String)tableName);
        }
        return tableName;
    }

    public void afterPropertiesSet() throws NulsException {
    }

    @Override
    public void saveLedgerAssetReg(int chainId, LedgerAsset ledgerAsset) throws Exception {
        String assetRegTable = this.getLedgerAssetRegMngTableName(chainId);
        String assetContractAddrTable = this.getLedgerAssetRegContractAddrIndexTableName(chainId);
        if (2 == ledgerAsset.getAssetType()) {
            this.DB_CONTRACT_ASSETS_IDS_MAP.put(chainId + "_" + ledgerAsset.getAssetId(), 1);
        }
        RocksDBService.put((String)assetContractAddrTable, (byte[])ledgerAsset.getAssetOwnerAddress(), (byte[])ByteUtils.intToBytes((int)ledgerAsset.getAssetId()));
        RocksDBService.put((String)assetRegTable, (byte[])ByteUtils.intToBytes((int)ledgerAsset.getAssetId()), (byte[])ledgerAsset.serialize());
    }

    @Override
    public void batchSaveLedgerAssetReg(int chainId, Map<byte[], byte[]> ledgerAssets, Map<byte[], byte[]> ledgerAssetsHashs) throws Exception {
        String assetRegTable = this.getLedgerAssetRegMngTableName(chainId);
        String assetHashTable = this.getLedgerAssetRegHashIndexTableName(chainId);
        if (ledgerAssetsHashs.size() > 0) {
            RocksDBService.batchPut((String)assetHashTable, ledgerAssetsHashs);
        }
        if (ledgerAssets.size() > 0) {
            RocksDBService.batchPut((String)assetRegTable, ledgerAssets);
        }
    }

    @Override
    public void batchRollBackLedgerAssetReg(int chainId, List<byte[]> txHashs) throws Exception {
        String assetHashTable = this.getLedgerAssetRegHashIndexTableName(chainId);
        List assetIds = RocksDBService.multiGetAsList((String)assetHashTable, txHashs);
        if (null != assetIds && assetIds.size() > 0) {
            String assetRegTable = this.getLedgerAssetRegMngTableName(chainId);
            RocksDBService.deleteKeys((String)assetRegTable, (List)assetIds);
        }
        if (txHashs.size() > 0) {
            RocksDBService.deleteKeys((String)assetHashTable, txHashs);
        }
    }

    @Override
    public int getLedgerAssetIdByContractAddr(int chainId, byte[] address) throws Exception {
        String assetContractAddrTable = this.getLedgerAssetRegContractAddrIndexTableName(chainId);
        byte[] assetIdByte = RocksDBService.get((String)assetContractAddrTable, (byte[])address);
        if (null == assetIdByte) {
            return 0;
        }
        return ByteUtils.bytesToInt((byte[])assetIdByte);
    }

    @Override
    public int getLedgerAssetIdByHash(int chainId, byte[] hash) throws Exception {
        String hashTableName = this.getLedgerAssetRegHashIndexTableName(chainId);
        byte[] assetIdByte = RocksDBService.get((String)hashTableName, (byte[])hash);
        if (null != assetIdByte) {
            return ByteUtils.bytesToInt((byte[])assetIdByte);
        }
        return 0;
    }

    @Override
    public LedgerAsset getLedgerAssetByAssetId(int chainId, int assetId) throws Exception {
        String assetRegTable = this.getLedgerAssetRegMngTableName(chainId);
        byte[] assetByte = RocksDBService.get((String)assetRegTable, (byte[])ByteUtils.intToBytes((int)assetId));
        if (null != assetRegTable) {
            LedgerAsset ledgerAsset = new LedgerAsset();
            ledgerAsset.parse(assetByte, 0);
            return ledgerAsset;
        }
        return null;
    }

    @Override
    public void deleteLedgerAssetReg(int chainId, int assetId) throws Exception {
        String assetRegTable = this.getLedgerAssetRegMngTableName(chainId);
        RocksDBService.delete((String)assetRegTable, (byte[])ByteUtils.intToBytes((int)assetId));
        this.DB_CONTRACT_ASSETS_IDS_MAP.remove(chainId + "_" + assetId);
    }

    @Override
    public void deleteLedgerAssetRegIndex(int chainId, byte[] address) throws Exception {
        String assetContractAddrTable = this.getLedgerAssetRegContractAddrIndexTableName(chainId);
        RocksDBService.delete((String)assetContractAddrTable, (byte[])address);
    }

    @Override
    public List<LedgerAsset> getAllRegLedgerAssets(int chainId) throws Exception {
        String assetRegTable = this.getLedgerAssetRegMngTableName(chainId);
        List list = RocksDBService.valueList((String)assetRegTable);
        ArrayList<LedgerAsset> rtList = new ArrayList<LedgerAsset>();
        if (null != list) {
            for (byte[] assetByte : list) {
                LedgerAsset ledgerAsset = new LedgerAsset();
                ledgerAsset.parse(assetByte, 0);
                rtList.add(ledgerAsset);
            }
        }
        return rtList;
    }

    @Override
    public int loadDatas(int chainId) throws Exception {
        String assetContractTable;
        List list2;
        String assetHashTable = this.getLedgerAssetRegHashIndexTableName(chainId);
        int assetId = 0;
        List list1 = RocksDBService.valueList((String)assetHashTable);
        if (list1 != null) {
            for (byte[] value : list1) {
                int hashAssetId = ByteUtils.bytesToInt((byte[])value);
                if (hashAssetId <= assetId) continue;
                assetId = hashAssetId;
            }
        }
        if ((list2 = RocksDBService.valueList((String)(assetContractTable = this.getLedgerAssetRegContractAddrIndexTableName(chainId)))) != null) {
            for (byte[] value : list2) {
                int addressAssetId = ByteUtils.bytesToInt((byte[])value);
                this.DB_CONTRACT_ASSETS_IDS_MAP.put(chainId + "_" + addressAssetId, 1);
                if (addressAssetId <= assetId) continue;
                assetId = addressAssetId;
            }
        }
        return assetId;
    }

    @Override
    public void batchUpdateAccountState(int addressChainId, Map<byte[], byte[]> accountStateMap) throws Exception {
        RocksDBService.batchPut((String)this.getLedgerAccountTableName(addressChainId), accountStateMap);
    }

    @Override
    public void batchDelAccountState(int addressChainId, List<byte[]> keys) throws Exception {
        RocksDBService.deleteKeys((String)this.getLedgerAccountTableName(addressChainId), keys);
    }

    @Override
    public boolean isContractAsset(int chainId, int assetId) {
        return null != this.DB_CONTRACT_ASSETS_IDS_MAP.get(chainId + "_" + assetId);
    }

    String getLedgerAccountTableName(int chainId) {
        return "account_" + chainId;
    }
}

