/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.storage.impl;

import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.model.ByteUtils;
import io.nuls.core.rockdb.manager.RocksDBManager;
import io.nuls.core.rockdb.service.BatchOperation;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.ledger.model.po.LedgerAsset;
import io.nuls.ledger.storage.CrossChainAssetRegMngRepository;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Component
public class CrossChainAssetRegMngRepositoryImpl
implements CrossChainAssetRegMngRepository {
    @Autowired
    private NulsCoresConfig config;
    String tableNamePrefix = "ledger_cross_chain_asset_";

    String getTableName(int chainId) throws Exception {
        String tableName = this.tableNamePrefix + chainId;
        RocksDBManager.setDataPath((String)(this.config.getDataPath() + File.separator + ModuleE.LG.name));
        if (!RocksDBService.existTable((String)tableName)) {
            RocksDBService.createTable((String)tableName);
        }
        return tableName;
    }

    byte[] genAssetKey(int assetChainId, int assetId) {
        return ByteUtils.toBytes((CharSequence)(assetChainId + "_" + assetId), (String)StandardCharsets.UTF_8.toString());
    }

    @Override
    public void saveCrossChainAsset(int chainId, LedgerAsset ledgerAsset) throws Exception {
        String assetRegTable = this.getTableName(chainId);
        RocksDBService.put((String)assetRegTable, (byte[])this.genAssetKey(ledgerAsset.getChainId(), ledgerAsset.getAssetId()), (byte[])ledgerAsset.serialize());
    }

    @Override
    public void saveCrossChainAssetList(int chainId, List<LedgerAsset> ledgerAssetList) throws Exception {
        String assetRegTable = this.getTableName(chainId);
        HashMap<byte[], byte[]> valuesMap = new HashMap<byte[], byte[]>();
        for (LedgerAsset asset : ledgerAssetList) {
            valuesMap.put(this.genAssetKey(asset.getChainId(), asset.getAssetId()), asset.serialize());
        }
        RocksDBService.batchPut((String)assetRegTable, valuesMap);
    }

    @Override
    public void deleteCrossChainAsset(int chainId, int assetChainId, int assetId) throws Exception {
        String assetRegTable = this.getTableName(chainId);
        RocksDBService.delete((String)assetRegTable, (byte[])this.genAssetKey(assetChainId, assetId));
    }

    @Override
    public void deleteCrossChainAssetList(int chainId, List<String> assetKeyList) throws Exception {
        String assetRegTable = this.getTableName(chainId);
        ArrayList<byte[]> keyList = new ArrayList<byte[]>();
        for (String assetKey : assetKeyList) {
            keyList.add(ByteUtils.toBytes((CharSequence)assetKey, (String)StandardCharsets.UTF_8.toString()));
        }
        RocksDBService.deleteKeys((String)assetRegTable, keyList);
    }

    @Override
    public void batchOperationCrossChainAssetList(int chainId, List<LedgerAsset> saveAssetList, List<String> deleteAssetKeyList) throws Exception {
        String assetRegTable = this.getTableName(chainId);
        BatchOperation batch = RocksDBService.createWriteBatch((String)assetRegTable);
        if (saveAssetList != null && !saveAssetList.isEmpty()) {
            for (LedgerAsset asset : saveAssetList) {
                batch.put(this.genAssetKey(asset.getChainId(), asset.getAssetId()), asset.serialize());
            }
        }
        if (deleteAssetKeyList != null && !deleteAssetKeyList.isEmpty()) {
            for (String assetKey : deleteAssetKeyList) {
                batch.delete(ByteUtils.toBytes((CharSequence)assetKey, (String)StandardCharsets.UTF_8.toString()));
            }
        }
        batch.executeBatch();
    }

    @Override
    public LedgerAsset getCrossChainAsset(int chainId, int assetChainId, int assetId) throws Exception {
        String assetRegTable = this.getTableName(chainId);
        byte[] assetByte = RocksDBService.get((String)assetRegTable, (byte[])this.genAssetKey(assetChainId, assetId));
        if (null != assetRegTable) {
            LedgerAsset ledgerAsset = new LedgerAsset();
            ledgerAsset.parse(assetByte, 0);
            return ledgerAsset;
        }
        return null;
    }

    @Override
    public List<LedgerAsset> getAllCrossChainAssets(int chainId) throws Exception {
        String assetRegTable = this.getTableName(chainId);
        List list = RocksDBService.valueList((String)assetRegTable);
        ArrayList<LedgerAsset> rtList = new ArrayList<LedgerAsset>();
        if (null != list) {
            for (byte[] assetByte : list) {
                LedgerAsset ledgerAsset = new LedgerAsset();
                ledgerAsset.parse(assetByte, 0);
                rtList.add(ledgerAsset);
            }
        }
        return rtList;
    }
}

