/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.ledger.storage.impl;

import io.nuls.core.basic.InitializingBean;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.ledger.model.po.AccountStateUnconfirmed;
import io.nuls.ledger.model.po.TxUnconfirmed;
import io.nuls.ledger.storage.UnconfirmedRepository;
import io.nuls.ledger.utils.LedgerUtil;
import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Component
public class UnconfirmedRepositoryImpl
implements UnconfirmedRepository,
InitializingBean {
    Map<String, Map<String, AccountStateUnconfirmed>> chainAccountUnconfirmed = new ConcurrentHashMap<String, Map<String, AccountStateUnconfirmed>>(16);

    @Override
    public AccountStateUnconfirmed getMemAccountStateUnconfirmed(int chainId, String accountKey) {
        Map<String, AccountStateUnconfirmed> map = this.chainAccountUnconfirmed.get(String.valueOf(chainId));
        if (null != map) {
            return map.get(accountKey);
        }
        return null;
    }

    @Override
    public void delMemAccountStateUnconfirmed(int chainId, String accountKey) {
        Map<String, AccountStateUnconfirmed> map = this.chainAccountUnconfirmed.get(String.valueOf(chainId));
        if (null != map) {
            map.remove(accountKey);
        }
    }

    @Override
    public void saveMemAccountStateUnconfirmed(int chainId, String accountKey, AccountStateUnconfirmed accountStateUnconfirmed) {
        Map<String, AccountStateUnconfirmed> map = this.chainAccountUnconfirmed.get(String.valueOf(chainId));
        if (null == map) {
            map = new ConcurrentHashMap<String, AccountStateUnconfirmed>();
            this.chainAccountUnconfirmed.put(String.valueOf(chainId), map);
        }
        map.put(accountKey, accountStateUnconfirmed);
    }

    @Override
    public TxUnconfirmed getMemUnconfirmedTx(int chainId, String accountKey, String nonceKey) {
        AccountStateUnconfirmed accountStateUnconfirmed = this.getMemAccountStateUnconfirmed(chainId, accountKey);
        if (null != accountStateUnconfirmed) {
            return accountStateUnconfirmed.getTxUnconfirmed(nonceKey);
        }
        return null;
    }

    @Override
    public void delMemUnconfirmedTx(int chainId, String accountKey, String nonceKey) {
        AccountStateUnconfirmed accountStateUnconfirmed = this.getMemAccountStateUnconfirmed(chainId, accountKey);
        if (null != accountStateUnconfirmed) {
            accountStateUnconfirmed.delTxUnconfirmed(nonceKey);
        }
    }

    @Override
    public void saveMemUnconfirmedTxs(int chainId, String accountKey, Map<String, TxUnconfirmed> txUnconfirmedMap) {
        AccountStateUnconfirmed accountStateUnconfirmed = this.getMemAccountStateUnconfirmed(chainId, accountKey);
        if (null != accountStateUnconfirmed) {
            accountStateUnconfirmed.addTxUnconfirmeds(txUnconfirmedMap);
        }
    }

    @Override
    public void saveMemUnconfirmedTx(int chainId, String accountKey, String nonce, TxUnconfirmed txUnconfirmed) {
        AccountStateUnconfirmed accountStateUnconfirmed = this.getMemAccountStateUnconfirmed(chainId, accountKey);
        if (null != accountStateUnconfirmed) {
            accountStateUnconfirmed.addTxUnconfirmed(nonce, txUnconfirmed);
        }
    }

    @Override
    public void addUncfd2Cfd(int chainId, String accountKey, BigInteger addAmount) {
        AccountStateUnconfirmed accountStateUnconfirmed = this.getMemAccountStateUnconfirmed(chainId, accountKey);
        if (null == accountStateUnconfirmed) {
            return;
        }
        accountStateUnconfirmed.setToConfirmedAmount(accountStateUnconfirmed.getToConfirmedAmount().add(addAmount));
    }

    @Override
    public void clearMemUnconfirmedTxs(int chainId, String accountKey, TxUnconfirmed txUnconfirmed) {
        AccountStateUnconfirmed accountStateUnconfirmed = this.getMemAccountStateUnconfirmed(chainId, accountKey);
        if (null == accountStateUnconfirmed || null == txUnconfirmed) {
            return;
        }
        Map<String, TxUnconfirmed> accountUnconfirmedTxs = accountStateUnconfirmed.getTxUnconfirmedMap();
        if (null != accountUnconfirmedTxs) {
            String key = LedgerUtil.getNonceEncode(txUnconfirmed.getNonce());
            TxUnconfirmed memTxUnconfirmed = accountUnconfirmedTxs.get(key);
            while (null != memTxUnconfirmed) {
                key = LedgerUtil.getNonceEncode(memTxUnconfirmed.getNonce());
                String keyNext = LedgerUtil.getNonceEncode(memTxUnconfirmed.getNextNonce());
                accountUnconfirmedTxs.remove(key);
                memTxUnconfirmed = accountUnconfirmedTxs.get(keyNext);
            }
        }
    }

    @Override
    public void clearMemUnconfirmedTxs(int chainId, String accountKey) {
        AccountStateUnconfirmed accountStateUnconfirmed = this.getMemAccountStateUnconfirmed(chainId, accountKey);
        if (null == accountStateUnconfirmed) {
            return;
        }
        accountStateUnconfirmed.clearTxUnconfirmeds();
    }

    @Override
    public void clearAllMemUnconfirmedTxs(int chainId) {
        Map<String, AccountStateUnconfirmed> allChainUnconfirmed = this.chainAccountUnconfirmed.get(String.valueOf(chainId));
        if (null == allChainUnconfirmed) {
            return;
        }
        allChainUnconfirmed.clear();
    }

    public void afterPropertiesSet() throws NulsException {
    }
}

