/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.network;

import io.nuls.common.INulsCoresBootstrap;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.log.Log;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.modulebootstrap.Module;
import io.nuls.network.constant.ManagerStatusEnum;
import io.nuls.network.manager.ConnectionManager;
import io.nuls.network.manager.MessageManager;
import io.nuls.network.manager.NodeGroupManager;
import io.nuls.network.manager.StorageManager;
import io.nuls.network.manager.TaskManager;
import io.nuls.network.storage.InitDB;
import io.nuls.network.storage.impl.DbServiceImpl;
import io.nuls.network.utils.IpUtil;
import io.nuls.network.utils.LoggerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;

@Component
public class NetworkBootstrap
implements INulsCoresBootstrap {
    @Autowired
    NulsCoresConfig networkConfig;
    private boolean hadRun = false;

    @Override
    public int order() {
        return 2;
    }

    @Override
    public void mainFunction(String[] args) {
        this.init();
    }

    private boolean validatCfg() {
        if (this.networkConfig.getPacketMagic() > 0xFFFFFFFFL) {
            Log.error((String)"Network cfg error.packageMagic:{}>{}", (Object[])new Object[]{this.networkConfig.getPacketMagic(), 0xFFFFFFFFL});
            return false;
        }
        if (this.networkConfig.getChainId() > 65535) {
            Log.error((String)"Network cfg error.chainId:{}>{}", (Object[])new Object[]{this.networkConfig.getChainId(), 65535});
            return false;
        }
        if (this.networkConfig.getPort() > 65535) {
            Log.error((String)"Network cfg error.port:{}>{}", (Object[])new Object[]{this.networkConfig.getPort(), 65535});
            return false;
        }
        if (this.networkConfig.getCrossPort() > 65535) {
            Log.error((String)"Network cfg error.crossPort:{}>{}", (Object[])new Object[]{this.networkConfig.getCrossPort(), 65535});
            return false;
        }
        return true;
    }

    private void jsonCfgInit() throws Exception {
        try {
            String seedIps = this.networkConfig.getSelfSeedIps();
            ArrayList<String> ipList = new ArrayList<String>();
            if (StringUtils.isNotBlank((String)seedIps)) {
                String[] seedIpsArray;
                for (String seedIp : seedIpsArray = seedIps.split(",")) {
                    if (null == (seedIp = IpUtil.changeHostToIpStr(seedIp))) continue;
                    ipList.add(seedIp);
                }
                this.networkConfig.setSeedIpList(ipList);
            }
            if (this.networkConfig.getMainChainId() == this.networkConfig.getChainId()) {
                this.networkConfig.setMoonNode(true);
            } else {
                this.networkConfig.setMoonNode(false);
            }
            this.networkConfig.setMaxInSameIp(10);
            this.networkConfig.setCrossMaxInSameIp(10);
            String seedMoonIp = this.networkConfig.getMoonSeedIps();
            ArrayList<String> ipMoonList = new ArrayList<String>();
            Collections.addAll(ipMoonList, seedMoonIp.split(","));
            this.networkConfig.setMoonSeedIpList(ipMoonList);
            this.networkConfig.getLocalIps().addAll(IpUtil.getIps());
        }
        catch (Exception e) {
            Log.error((String)"Network NetworkBootstrap cfgInit failed", (Throwable)e);
            throw new RuntimeException("Network NetworkBootstrap cfgInit failed");
        }
    }

    private void dbInit() throws Exception {
        RocksDBService.init((String)(this.networkConfig.getDataPath() + File.separator + ModuleE.NW.name));
        InitDB dbService = (InitDB)SpringLiteContext.getBean(DbServiceImpl.class);
        dbService.initTableName();
    }

    private void managerInit() throws Exception {
        StorageManager.getInstance().init();
        NodeGroupManager.getInstance().init();
        MessageManager.getInstance().init();
        ConnectionManager.getInstance().init();
        TaskManager.getInstance().init();
    }

    public void init() {
        try {
            System.setProperty("io.netty.tryReflectionSetAccessible", "true");
            if (!this.validatCfg()) {
                System.exit(-1);
            }
            this.jsonCfgInit();
            this.dbInit();
            this.managerInit();
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            Log.error((String)"exit,start fail...");
            System.exit(-1);
        }
    }

    @Override
    public Module moduleInfo() {
        return new Module(ModuleE.NW.abbr, "1.0");
    }

    public boolean doStart() {
        Log.info((String)"doStart begin=========");
        NodeGroupManager.getInstance().start();
        LoggerUtil.COMMON_LOG.info("doStart end=========");
        return true;
    }

    @Override
    public void onDependenciesReady() {
        LoggerUtil.COMMON_LOG.info("network onDependenciesReady");
        try {
            this.doStart();
            if (!this.hadRun) {
                ConnectionManager.getInstance().start();
                TaskManager.getInstance().start();
                this.hadRun = true;
            } else {
                ConnectionManager.getInstance().change(ManagerStatusEnum.RUNNING);
                NodeGroupManager.getInstance().change(ManagerStatusEnum.RUNNING);
            }
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error(e);
            LoggerUtil.COMMON_LOG.error("exit,start fail...");
            System.exit(-1);
        }
        LoggerUtil.COMMON_LOG.info("network RUNNING......");
    }
}

